/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.util.function.Function;
import smile.data.type.DataType;
import smile.data.type.DataTypes;

public class ObjectType
implements DataType {
    static ObjectType instance = new ObjectType(Object.class);
    static ObjectType BooleanObjectType = new ObjectType(Boolean.class);
    static ObjectType CharObjectType = new ObjectType(Character.class);
    static ObjectType ByteObjectType = new ObjectType(Byte.class);
    static ObjectType ShortObjectType = new ObjectType(Short.class);
    static ObjectType IntegerObjectType = new ObjectType(Integer.class);
    static ObjectType LongObjectType = new ObjectType(Long.class);
    static ObjectType FloatObjectType = new ObjectType(Float.class);
    static ObjectType DoubleObjectType = new ObjectType(Double.class);
    private final Class<?> clazz;
    private final Function<Object, String> format;

    ObjectType(Class<?> clazz) {
        this.clazz = clazz;
        this.format = clazz == Float.class ? o -> DataTypes.FloatType.toString(o) : (clazz == Double.class ? o -> DataTypes.DoubleType.toString(o) : (clazz == Integer.class ? o -> DataTypes.IntegerType.toString(o) : (clazz == Long.class ? o -> DataTypes.IntegerType.toString(o) : Object::toString)));
    }

    public Class<?> getObjectClass() {
        return this.clazz;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.clazz == Boolean.class;
    }

    @Override
    public boolean isChar() {
        return this.clazz == Character.class;
    }

    @Override
    public boolean isByte() {
        return this.clazz == Byte.class;
    }

    @Override
    public boolean isShort() {
        return this.clazz == Short.class;
    }

    @Override
    public boolean isInt() {
        return this.clazz == Integer.class;
    }

    @Override
    public boolean isLong() {
        return this.clazz == Long.class;
    }

    @Override
    public boolean isFloat() {
        return this.clazz == Float.class;
    }

    @Override
    public boolean isDouble() {
        return this.clazz == Double.class;
    }

    @Override
    public String name() {
        return String.format("Object[%s]", this.clazz.getName());
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Object;
    }

    public String toString() {
        return this.clazz.getSimpleName();
    }

    @Override
    public String toString(Object o) {
        return this.format.apply(o);
    }

    @Override
    public Object valueOf(String s) {
        return s;
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectType) {
            return this.clazz == ((ObjectType)o).getObjectClass();
        }
        return false;
    }
}

