/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.ColumnTransform;
import smile.data.transform.InvertibleTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVector;
import smile.math.Function;

public class InvertibleColumnTransform
extends ColumnTransform
implements InvertibleTransform {
    private final Map<String, Function> inverses;

    public InvertibleColumnTransform(String name, Map<String, Function> transforms, Map<String, Function> inverses) {
        super(name, transforms);
        this.inverses = inverses;
    }

    @Override
    public Tuple invert(final Tuple x) {
        final StructType schema = x.schema();
        return new AbstractTuple(){

            @Override
            public Object get(int i) {
                Function inverse = (Function)InvertibleColumnTransform.this.inverses.get(schema.field((int)i).name);
                if (inverse != null) {
                    return inverse.apply(x.getDouble(i));
                }
                return x.get(i);
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    @Override
    public DataFrame invert(DataFrame data) {
        StructType schema = data.schema();
        BaseVector[] vectors = new BaseVector[schema.length()];
        IntStream.range(0, schema.length()).forEach(i -> {
            StructField field = schema.field(i);
            Function inverse = this.inverses.get(field.name);
            if (inverse != null) {
                DoubleStream stream = ((Stream)data.stream().parallel()).mapToDouble(t2 -> inverse.apply(t2.getDouble(i)));
                vectors[i] = DoubleVector.of(field, stream);
            } else {
                vectors[i] = data.column(i);
            }
        });
        return DataFrame.of(vectors);
    }
}

