/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Abs
extends AbstractFunction {
    public Abs(Term x) {
        super("abs", x);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            DataType type = xfield.type;
            if (!(type.isInt() || type.isLong() || type.isDouble() || type.isFloat())) {
                throw new IllegalStateException(String.format("Invalid expression: abs(%s)", type));
            }
            features.add(new Feature(){
                final StructField field;
                {
                    this.field = new StructField(String.format("abs(%s)", xfield.name), xfield.type, xfield.measure);
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Object apply(Tuple o) {
                    Object y = feature.apply(o);
                    if (y == null) {
                        return null;
                    }
                    if (y instanceof Double) {
                        return Math.abs((Double)y);
                    }
                    if (y instanceof Integer) {
                        return Math.abs((Integer)y);
                    }
                    if (y instanceof Float) {
                        return Float.valueOf(Math.abs(((Float)y).floatValue()));
                    }
                    if (y instanceof Long) {
                        return Math.abs((Long)y);
                    }
                    throw new IllegalArgumentException("Invalid argument for abs(): " + y);
                }

                @Override
                public int applyAsInt(Tuple o) {
                    return Math.abs(feature.applyAsInt(o));
                }

                @Override
                public long applyAsLong(Tuple o) {
                    return Math.abs(feature.applyAsLong(o));
                }

                @Override
                public float applyAsFloat(Tuple o) {
                    return Math.abs(feature.applyAsFloat(o));
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return Math.abs(feature.applyAsDouble(o));
                }
            });
        }
        return features;
    }
}

