/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.osjava.StringsToTypes;
import org.osjava.sj.loader.convert.ConverterIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConverter
implements ConverterIF {
    private static Logger LOGGER = LoggerFactory.getLogger(BeanConverter.class);

    private static PropertyDescriptor findPropertyDescriptorWithSetter(Class<?> clazz, String propertyName) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz, Object.class);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method setter;
                if (!pd.getName().equalsIgnoreCase(propertyName) || (setter = pd.getWriteMethod()) == null) continue;
                return pd;
            }
        }
        catch (IntrospectionException ie) {
            throw new RuntimeException("Unable to find the properties of the bean of type, \"" + clazz + "\".", ie);
        }
        return null;
    }

    private static Object convert(String value, Class<?> toWhat) {
        Object obj;
        if (String.class.equals(toWhat)) {
            obj = value;
        } else if (CharSequence.class.equals(toWhat)) {
            obj = value;
        } else {
            String trimmedValue = value.trim();
            if (trimmedValue.isEmpty() && !toWhat.isPrimitive()) {
                obj = null;
            } else if (trimmedValue.length() == 0 && !toWhat.isPrimitive()) {
                obj = null;
            } else if (Boolean.TYPE.equals(toWhat) || Boolean.class.equals(toWhat)) {
                obj = StringsToTypes.toBoolean(trimmedValue);
            } else if (Byte.TYPE.equals(toWhat) || Byte.class.equals(toWhat)) {
                obj = NumberUtils.toByte((String)trimmedValue);
            } else if (Character.TYPE.equals(toWhat) || Character.class.equals(toWhat)) {
                obj = Character.valueOf(StringsToTypes.toCharacter(trimmedValue));
            } else if (Short.TYPE.equals(toWhat) || Short.class.equals(toWhat)) {
                obj = NumberUtils.toShort((String)trimmedValue);
            } else if (Integer.TYPE.equals(toWhat) || Integer.class.equals(toWhat)) {
                obj = NumberUtils.toInt((String)trimmedValue);
            } else if (Long.TYPE.equals(toWhat) || Long.class.equals(toWhat)) {
                obj = NumberUtils.toLong((String)trimmedValue);
            } else if (Float.TYPE.equals(toWhat) || Float.class.equals(toWhat)) {
                obj = Float.valueOf(NumberUtils.toFloat((String)trimmedValue));
            } else if (Double.TYPE.equals(toWhat) || Double.class.equals(toWhat)) {
                obj = NumberUtils.toDouble((String)trimmedValue);
            } else if (java.util.Date.class.equals(toWhat)) {
                obj = StringsToTypes.toDate(trimmedValue);
            } else if (Date.class.equals(toWhat)) {
                obj = StringsToTypes.toSqlDate(trimmedValue);
            } else if (Time.class.equals(toWhat)) {
                obj = StringsToTypes.toTime(trimmedValue);
            } else if (Timestamp.class.equals(toWhat)) {
                obj = StringsToTypes.toTimestamp(trimmedValue);
            } else if (toWhat.isEnum()) {
                obj = StringsToTypes.toEnum(toWhat, trimmedValue);
            } else {
                obj = StringsToTypes.getOldStyleEnumFieldValue(toWhat, trimmedValue);
                if (obj == ObjectUtils.NULL) {
                    obj = StringsToTypes.callConstructor(toWhat, value);
                }
            }
        }
        return obj;
    }

    @Override
    public Object convert(Properties properties, String type) {
        String value = properties.getProperty("");
        if (value != null) {
            throw new RuntimeException("Specify the value as a pseudo property as Beans have empty constructors");
        }
        String methodName = null;
        try {
            Class<?> c = Class.forName(type);
            Object bean = c.newInstance();
            for (Object o : properties.keySet()) {
                String key = (String)o;
                if ("converter".equals(key) || "type".equals(key)) continue;
                Object property = properties.get(key);
                if (property instanceof String) {
                    String strValue = (String)property;
                    PropertyDescriptor pd = BeanConverter.findPropertyDescriptorWithSetter(c, key);
                    if (pd == null) {
                        throw new RuntimeException("No property with the name of \"" + key + "\" could be found on object of type, \"" + c + "\".");
                    }
                    Class<?> propertyType = pd.getPropertyType();
                    Method setter = pd.getWriteMethod();
                    setter.invoke(bean, BeanConverter.convert(strValue, propertyType));
                    continue;
                }
                if (property instanceof List) {
                    List list = (List)property;
                    int sz = list.size();
                    key = "add" + Character.toTitleCase(key.charAt(0)) + key.substring(1);
                    Method m = c.getMethod(key, Integer.TYPE, String.class);
                    for (int i = 0; i < sz; ++i) {
                        Object item = list.get(i);
                        if (!(item instanceof String)) {
                            LOGGER.error("Processing List: properties={} type={} property={} key={} item={}", new Object[]{properties, type, property, key, item});
                            throw new RuntimeException("Only Strings and Lists of String are supported");
                        }
                        m.invoke(bean, i, item);
                    }
                    continue;
                }
                LOGGER.error("Processing List: properties={} type={} methodName={} property={} key={}", new Object[]{properties, type, methodName, property, key});
                throw new RuntimeException("Only Strings and Lists of Strings are supported");
            }
            return bean;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find class: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find method " + methodName + " on class: " + type, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class: " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class: " + type, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to pass argument to class: " + type, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke (String) constructor on class: " + type, e);
        }
    }
}

