/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.jndi;

import java.util.Enumeration;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jetbrains.annotations.NotNull;

public class JndiUtils {
    public static Properties toProperties(Reference ref) {
        Properties props = new Properties();
        Enumeration<RefAddr> allRefAddresses = ref.getAll();
        while (allRefAddresses.hasMoreElements()) {
            RefAddr refAddr = allRefAddresses.nextElement();
            props.setProperty(refAddr.getType(), (String)refAddr.getContent());
        }
        return props;
    }

    public static Reference toReference(Properties props, String className) {
        String factory = props.getProperty("javaxNamingSpiObjectFactory", null);
        Reference ref = new Reference(className, factory, null);
        for (Object key : props.keySet()) {
            ref.add(new StringRefAddr((String)key, props.getProperty((String)key)));
        }
        return ref;
    }

    static Name toCompoundName(Name objName, Properties env) throws InvalidNameException {
        if (objName instanceof CompositeName) {
            return JndiUtils.toCompoundName(objName.toString(), env);
        }
        return objName;
    }

    @NotNull
    public static CompoundName toCompoundName(String objName, Properties env) throws InvalidNameException {
        Properties envCopy = new Properties(env);
        envCopy.setProperty("jndi.syntax.separator", env.getProperty("org.osjava.sj.delimiter"));
        envCopy.setProperty("jndi.syntax.direction", (String)env.get("jndi.syntax.direction"));
        return new CompoundName(objName, envCopy);
    }
}

