/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.hibernate.dialect;

import java.sql.SQLException;
import java.util.Iterator;
import org.hibernate.JDBCException;
import org.hibernate.ScrollMode;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.AbstractAnsiTrimEmulationFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.sqlite.hibernate.dialect.identity.SQLiteDialectIdentityColumnSupport;

public class SQLiteDialect
extends Dialect {
    private final UniqueDelegate uniqueDelegate;
    private static final SQLiteDialectIdentityColumnSupport IDENTITY_COLUMN_SUPPORT = new SQLiteDialectIdentityColumnSupport();
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow((RowSelection)selection);
            return sql + (hasOffset ? " LIMIT ? OFFSET ?" : " LIMIT ?");
        }

        public boolean supportsLimit() {
            return true;
        }

        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }
    };
    private static final int SQLITE_BUSY = 5;
    private static final int SQLITE_LOCKED = 6;
    private static final int SQLITE_IOERR = 10;
    private static final int SQLITE_CORRUPT = 11;
    private static final int SQLITE_NOTFOUND = 12;
    private static final int SQLITE_FULL = 13;
    private static final int SQLITE_CANTOPEN = 14;
    private static final int SQLITE_PROTOCOL = 15;
    private static final int SQLITE_TOOBIG = 18;
    private static final int SQLITE_CONSTRAINT = 19;
    private static final int SQLITE_MISMATCH = 20;
    private static final int SQLITE_NOTADB = 26;
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        protected String doExtractConstraintName(SQLException sqle) throws NumberFormatException {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqle) & 0xFF;
            if (errorCode == 19) {
                return this.extractUsingTemplate("constraint failed: ", "$", sqle.getMessage());
            }
            return null;
        }
    };

    public SQLiteDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(1, "char");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(-4, "blob");
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("mod", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1 % ?2"));
        this.registerFunction("quote", (SQLFunction)new StandardSQLFunction("quote", (Type)StandardBasicTypes.STRING));
        this.registerFunction("random", (SQLFunction)new NoArgSQLFunction("random", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("trim", (SQLFunction)new AbstractAnsiTrimEmulationFunction(){

            protected SQLFunction resolveBothSpaceTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "trim(?1)");
            }

            protected SQLFunction resolveBothSpaceTrimFromFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "trim(?2)");
            }

            protected SQLFunction resolveLeadingSpaceTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "ltrim(?1)");
            }

            protected SQLFunction resolveTrailingSpaceTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "rtrim(?1)");
            }

            protected SQLFunction resolveBothTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "trim(?1, ?2)");
            }

            protected SQLFunction resolveLeadingTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "ltrim(?1, ?2)");
            }

            protected SQLFunction resolveTrailingTrimFunction() {
                return new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "rtrim(?1, ?2)");
            }
        });
        this.uniqueDelegate = new SQLiteUniqueDelegate(this);
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return IDENTITY_COLUMN_SUPPORT;
    }

    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    public MultiTableBulkIdStrategy getDefaultMultiTableBulkIdStrategy() {
        return new LocalTemporaryTableBulkIdStrategy((IdTableSupport)new IdTableSupportStandardImpl(){

            public String getCreateIdTableCommand() {
                return "CREATE TEMPORARY TABLE";
            }
        }, AfterUseAction.CLEAN, null);
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException) & 0xFF;
                if (errorCode == 18 || errorCode == 20) {
                    return new DataException(message, sqlException, sql);
                }
                if (errorCode == 5 || errorCode == 6) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (errorCode >= 10 && errorCode <= 15 || errorCode == 26) {
                    return new JDBCConnectionException(message, sqlException, sql);
                }
                return null;
            }
        };
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("No drop foreign key syntax supported by SQLiteDialect");
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("No add foreign key syntax supported by SQLiteDialect");
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("No add primary key syntax supported by SQLiteDialect");
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 1000;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String getSelectGUIDString() {
        return "SELECT hex(randomblob(16))";
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    private static class SQLiteUniqueDelegate
    extends DefaultUniqueDelegate {
        private SQLiteUniqueDelegate(Dialect dialect) {
            super(dialect);
        }

        public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
            return "";
        }

        public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
            StringBuilder builder = new StringBuilder();
            Iterator iter = table.getUniqueKeyIterator();
            while (iter.hasNext()) {
                UniqueKey key = (UniqueKey)iter.next();
                builder.append(", CONSTRAINT ").append(this.dialect.quote(key.getName())).append(" ").append(this.uniqueConstraintSql(key));
            }
            return builder.toString();
        }

        public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }

        public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }
    }
}

