/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.format;

import android.media.MediaFormat;
import android.util.Log;
import com.guoxiaoxing.phoenix.compress.video.format.MediaFormatStrategy;
import com.guoxiaoxing.phoenix.compress.video.format.OutputFormatUnavailableException;

class Android480pFormatStrategy
implements MediaFormatStrategy {
    public static final int AUDIO_BITRATE_AS_IS = -1;
    public static final int AUDIO_CHANNELS_AS_IS = -1;
    private static final String TAG = "720pFormatStrategy";
    private static final int LONGER_LENGTH = 640;
    private static final int SHORTER_LENGTH = 480;
    private static final int DEFAULT_VIDEO_BITRATE = 700000;
    private final int mVideoBitrate;
    private final int mAudioBitrate;
    private final int mAudioChannels;

    public Android480pFormatStrategy() {
        this(700000);
    }

    public Android480pFormatStrategy(int videoBitrate) {
        this(videoBitrate, -1, -1);
    }

    public Android480pFormatStrategy(int videoBitrate, int audioBitrate, int audioChannels) {
        this.mVideoBitrate = videoBitrate;
        this.mAudioBitrate = audioBitrate;
        this.mAudioChannels = audioChannels;
    }

    @Override
    public MediaFormat createVideoOutputFormat(MediaFormat inputFormat) {
        int outHeight;
        int outWidth;
        int shorter;
        int longer;
        int height;
        int width = inputFormat.getInteger("width");
        if (width >= (height = inputFormat.getInteger("height"))) {
            longer = width;
            shorter = height;
            outWidth = 640;
            outHeight = 480;
        } else {
            shorter = width;
            longer = height;
            outWidth = 480;
            outHeight = 640;
        }
        if (longer * 9 != shorter * 16) {
            throw new OutputFormatUnavailableException("This video is not 16:9, and is not able to transcode. (" + width + "x" + height + ")");
        }
        if (shorter <= 480) {
            Log.d((String)TAG, (String)("This video is less or equal to 720p, pass-through. (" + width + "x" + height + ")"));
            return null;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)outWidth, (int)outHeight);
        format.setInteger("bitrate", this.mVideoBitrate);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 3);
        format.setInteger("color-format", 2130708361);
        return format;
    }

    @Override
    public MediaFormat createAudioOutputFormat(MediaFormat inputFormat) {
        if (this.mAudioBitrate == -1 || this.mAudioChannels == -1) {
            return null;
        }
        MediaFormat format = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)inputFormat.getInteger("sample-rate"), (int)this.mAudioChannels);
        format.setInteger("aac-profile", 2);
        format.setInteger("bitrate", this.mAudioBitrate);
        return format;
    }
}

