/*
 * Decompiled with CFR 0.152.
 */
package com.gm.lifecycle.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.gm.lifecycle.ConfigLifecycle;
import java.util.ArrayList;
import java.util.List;

public final class ManifestLifecycleParser {
    private static final String MODULE_VALUE = "ConfigLifecycle";
    private final Context context;

    public ManifestLifecycleParser(Context context) {
        this.context = context;
    }

    private static ConfigLifecycle parseModule(String className) {
        Object lifecycle;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find ConfigLifecycle implementation", e);
        }
        try {
            lifecycle = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate ConfigLifecycle implementation for " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate ConfigLifecycle implementation for " + clazz, e);
        }
        if (!(lifecycle instanceof ConfigLifecycle)) {
            throw new RuntimeException("Expected instanceof ConfigLifecycle, but found: " + lifecycle);
        }
        return (ConfigLifecycle)lifecycle;
    }

    public List<ConfigLifecycle> parse() {
        ArrayList<ConfigLifecycle> configLifecycles = new ArrayList<ConfigLifecycle>();
        try {
            ApplicationInfo appInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                for (String key : appInfo.metaData.keySet()) {
                    if (!MODULE_VALUE.equals(appInfo.metaData.get(key))) continue;
                    Log.d((String)"Lifecycle ---> ", (String)String.format("Find ConfigLifecycle in [%s]", key));
                    configLifecycles.add(ManifestLifecycleParser.parseModule(key));
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find metadata to parse ConfigLifecycle", e);
        }
        return configLifecycles;
    }
}

