/*
 * Decompiled with CFR 0.152.
 */
package gs.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.support.v7.preference.R;
import android.util.AttributeSet;
import gs.preference.SeekBarPreference;

public class PercentSeekBarPreference
extends SeekBarPreference {
    public PercentSeekBarPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public PercentSeekBarPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public PercentSeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PercentSeekBarPreference(Context context) {
        super(context);
    }

    private int adaptValue(float value) {
        return Math.round(value * (float)this.getMax());
    }

    @Override
    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.setValue(restoreValue ? this.adaptValue(this.getPersistedFloat(this.getPercentValue())) : ((Integer)defaultValue).intValue());
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        this.setMax(a.getInt(R.styleable.SeekBarPreference_android_max, 100));
        return this.adaptValue(a.getFloat(index, 0.0f));
    }

    protected boolean persistInt(int value) {
        return this.persistFloat(this.getPercentValue());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPercentValue() {
        float min = this.getMin();
        return ((float)this.getValue() - min) / ((float)this.getMax() - min);
    }

    public void setPercentValue(@FloatRange(from=0.0, to=1.0) float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("value must be between 0 and 1");
        }
        this.setValue(this.adaptValue(value));
    }
}

