/*
 * Decompiled with CFR 0.152.
 */
package gs.utils.maps.nestedscroll;

import android.content.Context;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;

public class NestedScrollMapView
extends FrameLayout
implements OnMapReadyCallback,
NestedScrollingChild,
GoogleMap.OnCameraMoveStartedListener,
GoogleMap.OnCameraIdleListener {
    private static final int INVALID_POINTER = -1;
    private final NestedScrollingChildHelper helper = new NestedScrollingChildHelper((View)this);
    private final int[] scrollOffset = new int[]{0, 0};
    private GoogleMap googleMap;
    private VelocityTracker velocityTracker;
    private int activePointerId = -1;
    private int lastMotionX;
    private int lastMotionY;

    public NestedScrollMapView(Context context) {
        super(context);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    public NestedScrollMapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    public NestedScrollMapView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    private void requestParentDisallowInterceptTouchEvent() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 2: {
                int pointerIndex;
                if (this.hasNestedScrollingParent()) {
                    return true;
                }
                if (this.activePointerId == -1 || ev.findPointerIndex(this.activePointerId) == -1 || (pointerIndex = ev.findPointerIndex(this.activePointerId)) == -1) break;
                this.lastMotionX = (int)ev.getX(pointerIndex);
                this.lastMotionY = (int)ev.getY(pointerIndex);
                this.initVelocityTrackerIfNotExists();
                this.velocityTracker.addMovement(ev);
                this.requestParentDisallowInterceptTouchEvent();
                break;
            }
            case 0: {
                this.activePointerId = ev.getPointerId(0);
                this.lastMotionX = (int)ev.getX();
                this.lastMotionY = (int)ev.getY();
                this.initOrResetVelocityTracker();
                this.velocityTracker.addMovement(ev);
                this.requestParentDisallowInterceptTouchEvent();
                break;
            }
            case 1: 
            case 3: {
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.requestParentDisallowInterceptTouchEvent();
                this.activePointerId = ev.getPointerId(0);
                this.lastMotionX = (int)ev.getX();
                this.lastMotionY = (int)ev.getY();
                break;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.activePointerId);
                if (activePointerIndex == -1) break;
                int x = (int)ev.getX(activePointerIndex);
                int y = (int)ev.getY(activePointerIndex);
                if (this.hasNestedScrollingParent()) {
                    int deltaX = this.lastMotionX - y;
                    int deltaY = this.lastMotionY - y;
                    this.dispatchNestedPreScroll(deltaX, deltaY, null, this.scrollOffset);
                    this.dispatchNestedScroll(deltaX, deltaY, 0, 0, null);
                }
                this.lastMotionX = x - this.scrollOffset[0];
                this.lastMotionY = y - this.scrollOffset[1];
                break;
            }
            case 1: {
                if (this.hasNestedScrollingParent()) {
                    ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
                    this.velocityTracker.computeCurrentVelocity(1000, (float)configuration.getScaledMaximumFlingVelocity());
                    float velocityX = -this.velocityTracker.getXVelocity();
                    float velocityY = -this.velocityTracker.getYVelocity();
                    this.recycleVelocityTracker();
                    if (!this.dispatchNestedPreFling(velocityX, velocityY)) {
                        this.dispatchNestedFling(velocityX, velocityY, false);
                    }
                }
                this.stopNestedScroll();
                break;
            }
            case 3: {
                this.stopNestedScroll();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.activePointerId = ev.getPointerId(index);
                this.lastMotionX = (int)ev.getX(index);
                this.lastMotionY = (int)ev.getY(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int index = ev.findPointerIndex(this.activePointerId);
                this.lastMotionX = (int)ev.getX(index);
                this.lastMotionY = (int)ev.getY(index);
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return this.getChildAt(0).dispatchTouchEvent(ev);
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int index = (ev.getAction() & 0xFF00) >> 8;
        if (ev.getPointerId(index) == this.activePointerId) {
            int newIndex = index == 0 ? 1 : 0;
            this.activePointerId = ev.getPointerId(newIndex);
            this.lastMotionX = (int)ev.getX(newIndex);
            this.lastMotionY = (int)ev.getY(newIndex);
            if (this.velocityTracker != null) {
                this.velocityTracker.clear();
            }
        }
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.helper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.helper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.helper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.helper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.helper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.helper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.googleMap != null && this.helper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.helper.stopNestedScroll();
        this.activePointerId = -1;
        this.recycleVelocityTracker();
    }

    public boolean hasNestedScrollingParent() {
        return this.helper.hasNestedScrollingParent();
    }

    public void onMapReady(GoogleMap googleMap) {
        this.googleMap = googleMap;
        this.googleMap.setOnCameraMoveStartedListener((GoogleMap.OnCameraMoveStartedListener)this);
        this.googleMap.setOnCameraIdleListener((GoogleMap.OnCameraIdleListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.googleMap != null) {
            this.googleMap.setOnCameraMoveStartedListener(null);
            this.googleMap.setOnCameraIdleListener(null);
            this.googleMap = null;
        }
    }

    public void onCameraMoveStarted(int reason) {
        if (reason == 1) {
            this.startNestedScroll(3);
        }
    }

    public void onCameraIdle() {
        this.stopNestedScroll();
    }

    private void initOrResetVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        } else {
            this.velocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }
}

