/*
 * Decompiled with CFR 0.152.
 */
package gs.utils.maps.nestedscroll;

import android.content.Context;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;

public class NestedScrollMapView
extends FrameLayout
implements OnMapReadyCallback,
NestedScrollingChild,
GoogleMap.OnCameraMoveStartedListener,
GoogleMap.OnCameraIdleListener {
    private final NestedScrollingChildHelper helper = new NestedScrollingChildHelper((View)this);
    private final int[] scrollOffset = new int[]{0, 0};
    private GoogleMap googleMap;
    private VelocityTracker velocityTracker;
    private float lastX;
    private float lastY;

    public NestedScrollMapView(Context context) {
        super(context);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    public NestedScrollMapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    public NestedScrollMapView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(true);
        this.helper.setNestedScrollingEnabled(true);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                ViewParent parent = this.getParent();
                if (parent != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                this.initOrResetVelocityTracker();
                this.velocityTracker.addMovement(ev);
                break;
            }
            case 2: {
                this.initVelocityTrackerIfNotExists();
                this.velocityTracker.addMovement(ev);
                break;
            }
            case 1: 
            case 3: {
                this.stopNestedScroll();
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.hasNestedScrollingParent()) {
            switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
                case 2: {
                    int deltaY;
                    if (Float.isNaN(this.lastX) && ev.getHistorySize() > 1) {
                        this.lastX = ev.getHistoricalX(0);
                        this.lastY = ev.getHistoricalY(0);
                    }
                    if (Float.isNaN(this.lastX)) break;
                    int deltaX = (int)(this.lastX - ev.getX());
                    if (this.dispatchNestedPreScroll(deltaX, deltaY = (int)(this.lastY - ev.getY()), null, this.scrollOffset)) {
                        ev.offsetLocation((float)(-this.scrollOffset[0]), (float)(-this.scrollOffset[1]));
                    }
                    this.dispatchNestedScroll(deltaX, deltaY, 0, 0, null);
                    break;
                }
                case 1: {
                    ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
                    this.velocityTracker.computeCurrentVelocity(1000, (float)configuration.getScaledMaximumFlingVelocity());
                    float velocityX = -this.velocityTracker.getXVelocity();
                    float velocityY = -this.velocityTracker.getYVelocity();
                    this.recycleVelocityTracker();
                    if (this.dispatchNestedPreFling(velocityX, velocityY)) break;
                    this.dispatchNestedFling(velocityX, velocityY, false);
                }
            }
            if (this.velocityTracker != null) {
                this.velocityTracker.addMovement(ev);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.helper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.helper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.helper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.helper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.helper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.helper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.googleMap != null && this.helper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.helper.stopNestedScroll();
        this.recycleVelocityTracker();
        this.lastY = Float.NaN;
        this.lastX = Float.NaN;
    }

    public boolean hasNestedScrollingParent() {
        return this.helper.hasNestedScrollingParent();
    }

    public void onMapReady(GoogleMap googleMap) {
        this.googleMap = googleMap;
        this.googleMap.setOnCameraMoveStartedListener((GoogleMap.OnCameraMoveStartedListener)this);
        this.googleMap.setOnCameraIdleListener((GoogleMap.OnCameraIdleListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.googleMap != null) {
            this.googleMap.setOnCameraMoveStartedListener(null);
            this.googleMap.setOnCameraIdleListener(null);
            this.googleMap = null;
        }
    }

    public void onCameraMoveStarted(int reason) {
        if (reason == 1) {
            this.startNestedScroll(3);
        }
    }

    public void onCameraIdle() {
        this.stopNestedScroll();
    }

    private void initOrResetVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        } else {
            this.velocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }
}

