/*
 * Decompiled with CFR 0.152.
 */
package com.github.gmazzo.buildconfig.generators;

import com.github.gmazzo.buildconfig.BuildConfigField;
import com.github.gmazzo.buildconfig.BuildConfigType;
import com.github.gmazzo.buildconfig.BuildConfigTypeUtilsKt;
import com.github.gmazzo.buildconfig.BuildConfigValue;
import com.github.gmazzo.buildconfig.generators.BuildConfigGenerator;
import com.github.gmazzo.buildconfig.generators.BuildConfigGeneratorSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0019*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u001a*\u00020\u001dH\u0002R\u001c\u0010\u0002\u001a\u00020\u00038\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/gmazzo/buildconfig/generators/BuildConfigJavaGenerator;", "Lcom/github/gmazzo/buildconfig/generators/BuildConfigGenerator;", "defaultVisibility", "", "(Z)V", "getDefaultVisibility", "()Z", "setDefaultVisibility", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "component1", "copy", "equals", "other", "", "execute", "", "spec", "Lcom/github/gmazzo/buildconfig/generators/BuildConfigGeneratorSpec;", "hashCode", "", "toString", "", "format", "Lkotlin/Pair;", "Lcom/squareup/javapoet/TypeName;", "forValue", "toTypeName", "Lcom/github/gmazzo/buildconfig/BuildConfigType;", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nBuildConfigJavaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildConfigJavaGenerator.kt\ncom/github/gmazzo/buildconfig/generators/BuildConfigJavaGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1549#2:197\n1620#2,3:198\n1855#2,2:203\n37#3,2:201\n1#4:205\n*S KotlinDebug\n*F\n+ 1 BuildConfigJavaGenerator.kt\ncom/github/gmazzo/buildconfig/generators/BuildConfigJavaGenerator\n*L\n46#1:197\n46#1:198,3\n66#1:203,2\n46#1:201,2\n*E\n"})
public final class BuildConfigJavaGenerator
implements BuildConfigGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean defaultVisibility;
    private final Logger logger;
    private static final ClassName STRING = ClassName.get(String.class);
    private static final ClassName LIST = ClassName.get(List.class);
    private static final ClassName SET = ClassName.get(Set.class);
    private static final ClassName MAP = ClassName.get(Map.class);
    private static final ClassName FILE = ClassName.get(File.class);
    private static final ClassName URI = ClassName.get(URI.class);
    private static final ClassName GENERIC_LIST = ClassName.get((String)"", (String)"List", (String[])new String[0]);
    private static final ClassName GENERIC_SET = ClassName.get((String)"", (String)"Set", (String[])new String[0]);
    private static final ClassName GENERIC_MAP = ClassName.get((String)"", (String)"Map", (String[])new String[0]);

    public BuildConfigJavaGenerator(boolean defaultVisibility) {
        this.defaultVisibility = defaultVisibility;
        this.logger = Logging.getLogger(this.getClass());
    }

    public /* synthetic */ BuildConfigJavaGenerator(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Input
    public final boolean getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public final void setDefaultVisibility(boolean bl) {
        this.defaultVisibility = bl;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeName toTypeName(BuildConfigType $this$toTypeName) {
        TypeName[] typeNameArray;
        TypeName type;
        TypeName[] typeNameArray2 = $this$toTypeName.getClassName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)typeNameArray2, (String)"toLowerCase(...)");
        switch (typeNameArray2) {
            case "boolean": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.BOOLEAN.box();
                    break;
                }
                typeName = TypeName.BOOLEAN;
                break;
            }
            case "byte": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.BYTE.box();
                    break;
                }
                typeName = TypeName.BYTE;
                break;
            }
            case "short": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.SHORT.box();
                    break;
                }
                typeName = TypeName.SHORT;
                break;
            }
            case "character": 
            case "char": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.CHAR.box();
                    break;
                }
                typeName = TypeName.CHAR;
                break;
            }
            case "integer": 
            case "int": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.INT.box();
                    break;
                }
                typeName = TypeName.INT;
                break;
            }
            case "long": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.LONG.box();
                    break;
                }
                typeName = TypeName.LONG;
                break;
            }
            case "float": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.FLOAT.box();
                    break;
                }
                typeName = TypeName.FLOAT;
                break;
            }
            case "double": {
                TypeName typeName;
                if ($this$toTypeName.getNullable()) {
                    typeName = TypeName.DOUBLE.box();
                    break;
                }
                typeName = TypeName.DOUBLE;
                break;
            }
            case "string": {
                TypeName typeName = (TypeName)STRING;
                break;
            }
            case "list": {
                TypeName typeName = (TypeName)LIST;
                break;
            }
            case "set": {
                TypeName typeName = (TypeName)SET;
                break;
            }
            case "*": 
            case "?": {
                TypeName typeName = WildcardTypeName.get((Type)((Type)((Object)Object.class)));
                break;
            }
            default: {
                TypeName typeName = type = (TypeName)ClassName.bestGuess((String)$this$toTypeName.getClassName());
            }
        }
        if (!((Collection)$this$toTypeName.getTypeArguments()).isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            TypeName typeName = type;
            Intrinsics.checkNotNull((Object)typeName, (String)"null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            Iterable iterable = $this$toTypeName.getTypeArguments();
            ClassName className = (ClassName)typeName;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BuildConfigType buildConfigType = (BuildConfigType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toTypeName(BuildConfigType.copy$default((BuildConfigType)it, null, null, true, false, 11, null)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            typeNameArray = thisCollection$iv.toArray(new TypeName[0]);
            type = (TypeName)ParameterizedTypeName.get((ClassName)className, (TypeName[])Arrays.copyOf(typeNameArray, typeNameArray.length));
        }
        if ($this$toTypeName.getArray()) {
            type = (TypeName)ArrayTypeName.of((TypeName)type);
        }
        typeNameArray = type;
        Intrinsics.checkNotNull((Object)typeNameArray);
        return typeNameArray;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull BuildConfigGeneratorSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.logger.debug("Generating {} for fields {}", (Object)spec.getClassName(), spec.getFields());
        Object[] objectArray = new Modifier[]{Modifier.FINAL};
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)spec.getClassName()).addModifiers(objectArray);
        if (!this.defaultVisibility) {
            objectArray = new Modifier[]{Modifier.PUBLIC};
            typeSpec.addModifiers(objectArray);
        }
        if (spec.getDocumentation() != null) {
            objectArray = new Object[]{spec.getDocumentation()};
            typeSpec.addJavadoc("$L", objectArray);
        }
        Iterable $this$forEach$iv = spec.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildConfigField field = (BuildConfigField)element$iv;
            boolean bl = false;
            try {
                void $this$execute_u24lambda_u243_u24lambda_u242;
                Object[] objectArray2;
                Object object = field.getType().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                TypeName typeName = this.toTypeName((BuildConfigType)object);
                BuildConfigValue value2 = (BuildConfigValue)field.getValue().get();
                TypeName nullableAwareType = value2.getValue() == null && typeName.isPrimitive() ? typeName.box() : typeName;
                Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
                Modifier[] modifierArray2 = modifierArray = FieldSpec.builder((TypeName)nullableAwareType, (String)field.getName(), (Modifier[])modifierArray);
                TypeSpec.Builder builder = typeSpec;
                boolean bl2 = false;
                BuildConfigValue buildConfigValue = value2;
                if (buildConfigValue instanceof BuildConfigValue.Literal) {
                    Intrinsics.checkNotNull((Object)nullableAwareType);
                    objectArray2 = this.format(nullableAwareType, value2.getValue());
                    String format2 = (String)objectArray2.component1();
                    int count = ((Number)objectArray2.component2()).intValue();
                    Object[] args = BuildConfigTypeUtilsKt.asVarArg(value2.getValue());
                    if (!(count == args.length)) {
                        boolean bl3 = false;
                        String string = "Invalid number of arguments for " + field.getName() + " of type " + nullableAwareType + ": expected " + count + ", got " + args.length + ": " + ArraysKt.joinToString$default((Object[])args, null, null, null, (int)0, null, null, (int)63, null);
                        throw new IllegalStateException(string.toString());
                    }
                    $this$execute_u24lambda_u243_u24lambda_u242.initializer(format2, Arrays.copyOf(args, args.length));
                } else if (buildConfigValue instanceof BuildConfigValue.Expression) {
                    objectArray2 = new Object[]{((BuildConfigValue.Expression)value2).getValue()};
                    $this$execute_u24lambda_u243_u24lambda_u242.initializer("$L", objectArray2);
                }
                builder.addField(modifierArray.build());
            }
            catch (Exception e) {
                Serializable serializable = ((BuildConfigValue)field.getValue().get()).getValue();
                throw new IllegalArgumentException("Failed to generate field '" + field.getName() + "' of type '" + field.getType().get() + "', with value: " + ((BuildConfigValue)field.getValue().get()).getValue() + " (of type '" + (serializable != null ? serializable.getClass() : null) + "')", e);
            }
        }
        objectArray = new Modifier[]{Modifier.PRIVATE};
        JavaFile.builder((String)spec.getPackageName(), (TypeSpec)typeSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(objectArray).build()).build()).build().writeTo(spec.getOutputDir());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, Integer> format(TypeName $this$format, Object forValue) {
        Pair<String, Integer> pair;
        List<Object> elements = BuildConfigTypeUtilsKt.getElements(forValue);
        TypeName typeName = $this$format;
        if (Intrinsics.areEqual((Object)typeName, (Object)TypeName.LONG) ? true : Intrinsics.areEqual((Object)typeName, (Object)ClassName.get(String.class))) {
            pair = BuildConfigJavaGenerator.format$singleFormat(elements);
        } else if (typeName instanceof ArrayTypeName) {
            pair = BuildConfigJavaGenerator.format$format$4(elements, "{", "}", ((ArrayTypeName)$this$format).componentType);
        } else if (Intrinsics.areEqual((Object)typeName, (Object)LIST) ? true : Intrinsics.areEqual((Object)typeName, (Object)GENERIC_LIST)) {
            pair = BuildConfigJavaGenerator.format$listFormat(elements, null);
        } else if (Intrinsics.areEqual((Object)typeName, (Object)SET) ? true : Intrinsics.areEqual((Object)typeName, (Object)GENERIC_SET)) {
            pair = BuildConfigJavaGenerator.format$setFormat(elements, null);
        } else if (Intrinsics.areEqual((Object)typeName, (Object)MAP) ? true : Intrinsics.areEqual((Object)typeName, (Object)GENERIC_MAP)) {
            pair = BuildConfigJavaGenerator.format$mapFormat(elements, null, null);
        } else if (typeName instanceof ParameterizedTypeName) {
            ClassName className = ((ParameterizedTypeName)$this$format).rawType;
            if (Intrinsics.areEqual((Object)className, (Object)LIST) ? true : Intrinsics.areEqual((Object)className, (Object)GENERIC_LIST)) {
                void it;
                Object e = ((ParameterizedTypeName)$this$format).typeArguments.get(0);
                TypeName typeName2 = (TypeName)e;
                List<Object> list = elements;
                boolean bl = false;
                boolean bl2 = it.isBoxedPrimitive();
                pair = BuildConfigJavaGenerator.format$listFormat(list, (TypeName)(bl2 ? e : null));
            } else if (Intrinsics.areEqual((Object)className, (Object)SET) ? true : Intrinsics.areEqual((Object)className, (Object)GENERIC_SET)) {
                Object e = ((ParameterizedTypeName)$this$format).typeArguments.get(0);
                TypeName it = (TypeName)e;
                List<Object> list = elements;
                boolean bl = false;
                boolean bl3 = it.isBoxedPrimitive();
                pair = BuildConfigJavaGenerator.format$setFormat(list, (TypeName)(bl3 ? e : null));
            } else if (Intrinsics.areEqual((Object)className, (Object)MAP) ? true : Intrinsics.areEqual((Object)className, (Object)GENERIC_MAP)) {
                Object e = ((ParameterizedTypeName)$this$format).typeArguments.get(0);
                TypeName it = (TypeName)e;
                List<Object> list = elements;
                boolean bl = false;
                boolean bl4 = it.isBoxedPrimitive();
                Object object = bl4 ? e : null;
                e = ((ParameterizedTypeName)$this$format).typeArguments.get(1);
                it = (TypeName)e;
                TypeName typeName3 = (TypeName)object;
                boolean bl5 = false;
                boolean bl6 = it.isBoxedPrimitive();
                pair = BuildConfigJavaGenerator.format$mapFormat(list, typeName3, (TypeName)(bl6 ? e : null));
            } else {
                pair = BuildConfigJavaGenerator.format$singleFormat(elements);
            }
        } else {
            pair = BuildConfigJavaGenerator.format$singleFormat(elements);
        }
        return pair;
    }

    public final boolean component1() {
        return this.defaultVisibility;
    }

    @NotNull
    public final BuildConfigJavaGenerator copy(boolean defaultVisibility) {
        return new BuildConfigJavaGenerator(defaultVisibility);
    }

    public static /* synthetic */ BuildConfigJavaGenerator copy$default(BuildConfigJavaGenerator buildConfigJavaGenerator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = buildConfigJavaGenerator.defaultVisibility;
        }
        return buildConfigJavaGenerator.copy(bl);
    }

    @NotNull
    public String toString() {
        return "BuildConfigJavaGenerator(defaultVisibility=" + this.defaultVisibility + ')';
    }

    public int hashCode() {
        return Boolean.hashCode(this.defaultVisibility);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildConfigJavaGenerator)) {
            return false;
        }
        BuildConfigJavaGenerator buildConfigJavaGenerator = (BuildConfigJavaGenerator)other;
        return this.defaultVisibility == buildConfigJavaGenerator.defaultVisibility;
    }

    private static final String format$format(TypeName $this$format_u24format) {
        TypeName typeName;
        TypeName typeName2 = $this$format_u24format;
        TypeName typeName3 = typeName = (typeName2 != null ? typeName2.isBoxedPrimitive() : false) ? $this$format_u24format.unbox() : $this$format_u24format;
        return Intrinsics.areEqual((Object)typeName, (Object)TypeName.BYTE) ? "(byte) $L" : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.CHAR) ? "'$L'" : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.SHORT) ? "(short) $L" : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.LONG) ? "$LL" : (Intrinsics.areEqual((Object)typeName, (Object)TypeName.FLOAT) ? "$Lf" : (Intrinsics.areEqual((Object)typeName, (Object)STRING) ? "$S" : (Intrinsics.areEqual((Object)typeName, (Object)FILE) ? "new java.io.File($S)" : (Intrinsics.areEqual((Object)typeName, (Object)URI) ? "java.net.URI.create($S)" : "$L")))))));
    }

    private static final Pair<String, Integer> format$format$4(List<? extends Object> $this$format_u24format_u244, String prefix, String postfix, TypeName elementType) {
        return TuplesKt.to((Object)CollectionsKt.joinToString$default((Iterable)$this$format_u24format_u244, (CharSequence)", ", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(elementType){
            final /* synthetic */ TypeName $elementType;
            {
                this.$elementType = $elementType;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@Nullable Object it) {
                TypeName typeName;
                Object object = it;
                if (object != null) {
                    Object object2 = object;
                    TypeName typeName2 = this.$elementType;
                    Object it2 = object2;
                    boolean bl = false;
                    typeName = typeName2;
                    if (typeName == null) {
                        typeName = TypeName.get((Type)it2.getClass());
                    }
                } else {
                    typeName = null;
                }
                return BuildConfigJavaGenerator.access$format$format(typeName);
            }
        }), (int)24, null), (Object)$this$format_u24format_u244.size());
    }

    private static final Pair<String, Integer> format$singleFormat(List<? extends Object> elements) {
        TypeName typeName;
        Object object = CollectionsKt.single(elements);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            typeName = TypeName.get((Type)it.getClass());
        } else {
            typeName = null;
        }
        return TuplesKt.to((Object)BuildConfigJavaGenerator.format$format(typeName), (Object)1);
    }

    private static final Pair<String, Integer> format$listFormat(List<? extends Object> elements, TypeName elementType) {
        return BuildConfigJavaGenerator.format$format$4(elements, "java.util.Arrays.asList(", ")", elementType);
    }

    private static final Pair<String, Integer> format$setFormat(List<? extends Object> elements, TypeName elementType) {
        return BuildConfigJavaGenerator.format$format$4(elements, "new java.util.LinkedHashSet<>(java.util.Arrays.asList(", "))", elementType);
    }

    private static final Pair<String, Integer> format$mapFormat(List<? extends Object> elements, TypeName keyType, TypeName valueType) {
        return TuplesKt.to((Object)CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)", ", (CharSequence)"java.util.Map.of(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(keyType, valueType){
            final /* synthetic */ TypeName $keyType;
            final /* synthetic */ TypeName $valueType;
            {
                this.$keyType = $keyType;
                this.$valueType = $valueType;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@Nullable Object it) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>");
                Map.Entry entry = (Map.Entry)it;
                K key = entry.getKey();
                V value2 = entry.getValue();
                TypeName typeName = this.$keyType;
                if (typeName == null) {
                    K k = key;
                    if (k != null) {
                        K it2 = k;
                        boolean bl = false;
                        typeName = TypeName.get((Type)key.getClass());
                    } else {
                        typeName = null;
                    }
                }
                String keyFormat = BuildConfigJavaGenerator.access$format$format(typeName);
                TypeName typeName2 = this.$valueType;
                if (typeName2 == null) {
                    V v = value2;
                    if (v != null) {
                        V it3 = v;
                        boolean bl = false;
                        typeName2 = TypeName.get((Type)value2.getClass());
                    } else {
                        typeName2 = null;
                    }
                }
                String valueFormat = BuildConfigJavaGenerator.access$format$format(typeName2);
                return keyFormat + ", " + valueFormat;
            }
        }), (int)24, null), (Object)(elements.size() * 2));
    }

    public BuildConfigJavaGenerator() {
        this(false, 1, null);
    }

    public static final /* synthetic */ String access$format$format(TypeName $receiver) {
        return BuildConfigJavaGenerator.format$format($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/gmazzo/buildconfig/generators/BuildConfigJavaGenerator$Companion;", "", "()V", "FILE", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "GENERIC_LIST", "GENERIC_MAP", "GENERIC_SET", "LIST", "MAP", "SET", "STRING", "URI", "plugin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

