/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Map;
import parser.Function;
import util.Utils;

public class FunctionsBackup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMapItemsToFileLineByLine(Map<String, Function> map, File file) {
        if (map == null || map.isEmpty()) {
            return;
        }
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            String newLine = System.getProperty("line.separator");
            fw = new FileWriter(file.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            for (Map.Entry<String, Function> entry : map.entrySet()) {
                Function f = entry.getValue();
                if (f == null || f.isAnonymous()) continue;
                String s = f.serialize();
                bw.write(s + newLine);
            }
            bw.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileLinesToMap(Map<String, Function> map, File fileToRead) {
        BufferedReader in;
        if (map == null) {
            return;
        }
        try {
            FileReader stream = new FileReader(fileToRead);
            in = new BufferedReader(stream);
        }
        catch (Exception e) {
            Utils.logError("Sorry, but an error occurred \nwhile trying to open the file:/n" + e);
            return;
        }
        try {
            String lineFromFile;
            while ((lineFromFile = in.readLine()) != null) {
                if (lineFromFile == null || lineFromFile.equals("null")) continue;
                Function function = Function.parse(lineFromFile);
                map.put(function.getName(), function);
            }
        }
        catch (Exception e) {
            Utils.logError("Sorry, but an error occurred \nwhile trying to read the data:/n" + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

