/*
 * Decompiled with CFR 0.152.
 */
package parser.methods.ext;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public final class Utils {
    public static List<BigDecimal> stringsToBigDecimals(List<String> tokens) {
        return Utils.stringsToBigDecimals(tokens, 0);
    }

    public static List<BigDecimal> stringsToBigDecimals(List<String> tokens, int headCut) {
        ArrayList<BigDecimal> l = new ArrayList<BigDecimal>(Math.max(0, tokens.size() - headCut));
        for (int x = headCut; x < tokens.size(); ++x) {
            l.add(new BigDecimal(tokens.get(x)));
        }
        return l;
    }

    public static List<?> trimList(List<?> tokens, int toRemove, int minLength) {
        for (int x = 0; x < toRemove && !(minLength == 0 ? tokens.isEmpty() : tokens.size() - 2 < minLength); ++x) {
            tokens.remove(0);
            if (tokens.size() <= 0) continue;
            tokens.remove(tokens.size() - 1);
        }
        return tokens;
    }

    public static BigDecimal sum(List<BigDecimal> l) {
        BigDecimal summ = new BigDecimal(0);
        for (BigDecimal token : l) {
            summ = summ.add(token);
        }
        return summ;
    }

    public static BigDecimal gsum(List<BigDecimal> l) {
        BigDecimal gsumm = new BigDecimal(1);
        for (BigDecimal token : l) {
            gsumm = gsumm.multiply(token);
        }
        return gsumm;
    }

    public static int getFirstTokenAsInt(List<String> tokens) {
        BigDecimal toRemoveOrig = new BigDecimal(tokens.get(0), new MathContext(10, RoundingMode.HALF_DOWN));
        BigDecimal toRemoveD = toRemoveOrig.setScale(0, RoundingMode.HALF_DOWN);
        int toRemove = toRemoveD.intValue();
        return toRemove;
    }
}

