/*
 * Decompiled with CFR 0.152.
 */
package parser.methods.ext;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import math.BigDecimalNthRootCalculation;
import parser.TYPE;
import parser.methods.BasicNumericalMethod;
import parser.methods.Help;
import parser.methods.ext.Utils;

public class GeomN
implements BasicNumericalMethod {
    @Override
    public String solve(List<String> tokens) {
        int toRemove = Utils.getFirstTokenAsInt(tokens);
        List<BigDecimal> l = Utils.stringsToBigDecimals(tokens, 1);
        Collections.sort(l);
        Utils.trimList(l, toRemove, 2);
        BigDecimal gsumm = Utils.gsum(l);
        return BigDecimalNthRootCalculation.nthRoot(l.size(), gsumm).toString();
    }

    @Override
    public String getHelp() {
        return Help.toLine(this.getName(), " this is counting limited geom-avg value. First argument is not part of the sum, but is pointing, how much tokens have to be remove from sorted arguments list from both ends, before geom-avg is calculated from the rest. geomN(1,2,4,2) is actually not 16^1/4 but 2, as first 2 and last 4 from  2,2,4 (as 1 is argument) were removed.");
    }

    @Override
    public String getName() {
        return "geomN";
    }

    @Override
    public String getType() {
        return TYPE.NUMBER.toString();
    }
}

