/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import math.differentialcalculus.Parser;
import math.numericalmethods.NumericalIntegral;
import math.numericalmethods.RootFinder;
import parser.Bracket;
import parser.CustomScanner;
import parser.DataSetFormatter;
import parser.Function;
import parser.LISTS;
import parser.MathExpression;
import parser.Number;
import parser.Operator;
import parser.Parser_Result;
import parser.STRING;
import parser.Variable;
import parser.methods.Method;
import util.FunctionManager;
import util.VariableManager;

public class MathScanner {
    public Parser_Result parser_Result = Parser_Result.VALID;
    private ArrayList<String> errorList = new ArrayList();
    private boolean runnable = true;
    private String scannerInput;
    private ArrayList<String> scanner = new ArrayList();

    public MathScanner(String scannerInput) {
        int i;
        for (i = 0; i < scannerInput.length(); ++i) {
            try {
                if (scannerInput.substring(i, i + 1).equals("\u03c0")) {
                    scannerInput = STRING.replace(scannerInput, "pi", i, i + 1);
                    continue;
                }
                if (scannerInput.substring(i, i + 1).equals("\u00d7")) {
                    scannerInput = STRING.replace(scannerInput, "*", i, i + 1);
                    continue;
                }
                if (scannerInput.substring(i, i + 1).equals("\u00f7")) {
                    scannerInput = STRING.replace(scannerInput, "/", i, i + 1);
                    continue;
                }
                if (!scannerInput.substring(i, i + 1).equalsIgnoreCase("E") || !STRING.isDigit(scannerInput.substring(i + 2, i + 3))) continue;
                if (scannerInput.substring(i + 1, i + 2).equals("+")) {
                    scannerInput = STRING.replace(scannerInput, "\u00b1", i + 1, i + 2);
                    continue;
                }
                if (!scannerInput.substring(i + 1, i + 2).equals("-")) continue;
                scannerInput = STRING.replace(scannerInput, "\u2013", i + 1, i + 2);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < scannerInput.length(); ++i) {
            if (!scannerInput.substring(i, i + 1).equals(",") || !scannerInput.substring(i + 1, i + 2).equals("-") || !scannerInput.substring(i + 2, i + 3).equals(".") && !STRING.isDigit(scannerInput.substring(i + 2, i + 3))) continue;
            scannerInput = STRING.replace(scannerInput, "~", i + 1, i + 2);
        }
        DataSetFormatter dsf = new DataSetFormatter(scannerInput);
        this.scannerInput = dsf.getFormattedDataSet();
    }

    public void setScannerInput(String scannerInput) {
        this.scannerInput = scannerInput;
    }

    public String getScannerInput() {
        return this.scannerInput;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public void setRunnable(boolean runnable) {
        this.runnable = runnable;
        if (!this.runnable) {
            this.scanner.clear();
        }
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public void setErrorList(ArrayList<String> errorList) {
        this.errorList = errorList;
    }

    public ArrayList<String> getErrorList() {
        return this.errorList;
    }

    public static String getFirstNumberSubstring(String val) throws StringIndexOutOfBoundsException {
        String num1 = "";
        String num2 = "";
        String point = "";
        String exp = "";
        String sign = "";
        String num3 = "";
        int plusCount = 0;
        int minusCount = 0;
        int expCount = 0;
        int pointCount = 0;
        int ind = STRING.getFirstIndexOfDigit(val);
        try {
            if (val.substring(ind - 1, ind).equals(".")) {
                num2 = ".";
                ++pointCount;
            }
        }
        catch (IndexOutOfBoundsException in) {
            num2 = "";
            num1 = "";
        }
        if (num2.equals(".")) {
            try {
                for (int i = ind; i < val.length() && STRING.isNumberComponent(val.substring(i, i + 1)) && !val.substring(i, i + 1).equals("."); ++i) {
                    if (val.substring(i, i + 1).equals("+")) {
                        if (expCount == 0 || plusCount == 1 || minusCount == 1) break;
                        ++plusCount;
                    }
                    if (val.substring(i, i + 1).equals("-")) {
                        if (expCount == 0 || minusCount == 1 || plusCount == 1) break;
                        ++minusCount;
                    }
                    if (val.substring(i, i + 1).equals("E")) {
                        if (expCount == 1) break;
                        exp = "E";
                        ++expCount;
                    }
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 1 && expCount == 0) {
                        point = point + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("+") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("-") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (!STRING.isDigit(val.substring(i, i + 1)) || (pointCount != 0 || expCount != 1) && (pointCount != 1 || expCount != 1)) continue;
                    num3 = num3 + val.substring(i, i + 1);
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (num2.equals("")) {
            try {
                for (int i = ind; i < val.length() && STRING.isNumberComponent(val.substring(i, i + 1)); ++i) {
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 0 && expCount == 0) {
                        num1 = num1 + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals(".")) {
                        if (expCount == 1 || pointCount == 1) break;
                        num2 = ".";
                        ++pointCount;
                    }
                    if (val.substring(i, i + 1).equals("+")) {
                        if (expCount == 0 || plusCount == 1 || minusCount == 1) break;
                        ++plusCount;
                    }
                    if (val.substring(i, i + 1).equals("-")) {
                        if (expCount == 0 || minusCount == 1 || plusCount == 1) break;
                        ++minusCount;
                    }
                    if (val.substring(i, i + 1).equals("E")) {
                        if (expCount == 1) break;
                        exp = "E";
                        ++expCount;
                    }
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 1 && expCount == 0) {
                        point = point + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("+") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("-") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (!STRING.isDigit(val.substring(i, i + 1)) || (pointCount != 0 || expCount != 1) && (pointCount != 1 || expCount != 1)) continue;
                    num3 = num3 + val.substring(i, i + 1);
                }
            }
            catch (IndexOutOfBoundsException i) {
                // empty catch block
            }
        }
        String result = num1 + num2 + point + exp + sign + num3;
        try {
            if (STRING.lastElement(result).equals("+") || STRING.lastElement(result).equals("-")) {
                result = result.substring(0, result.length() - 1);
            }
            if (STRING.lastElement(result).equals("+") || STRING.lastElement(result).equals("-")) {
                result = result.substring(0, result.length() - 1);
            }
            if (STRING.lastElement(result).equals("E")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public ArrayList<String> splitStringAtFirstNumber(String val) {
        int firstOccDigit = STRING.getFirstIndexOfDigitOrPoint(val);
        if (firstOccDigit > -1) {
            if (firstOccDigit == 0) {
                String getFirstNumber = MathScanner.getFirstNumberSubstring(val);
                int firstNumberLen = getFirstNumber.length();
                this.scanner.add(getFirstNumber);
                this.scanner.add(val.substring(firstNumberLen));
            } else if (firstOccDigit > 0) {
                String getFirstNumber = MathScanner.getFirstNumberSubstring(val);
                int firstNumberLen = getFirstNumber.length();
                this.scanner.add(val.substring(0, firstOccDigit));
                this.scanner.add(getFirstNumber);
                this.scanner.add(val.substring(firstOccDigit + firstNumberLen));
            }
        }
        return this.scanner;
    }

    public ArrayList<String> splitStringOnNumbers(String val) {
        boolean canSplit;
        ArrayList<String> scan = new ArrayList<String>();
        ArrayList<Object> split = new ArrayList();
        boolean bl = canSplit = STRING.getFirstIndexOfDigitOrPoint(val) > -1;
        if (canSplit) {
            int passes = 0;
            while (canSplit) {
                split.clear();
                split = this.splitStringAtFirstNumber(val);
                int sizeAfterSplit = split.size();
                val = (String)split.get(sizeAfterSplit - 1);
                scan.addAll(split.subList(0, sizeAfterSplit - 1));
                boolean bl2 = canSplit = STRING.getFirstIndexOfDigitOrPoint(val) > -1;
                if (!canSplit) {
                    scan.add(val);
                    break;
                }
                ++passes;
            }
        } else {
            scan.add(val);
        }
        return scan;
    }

    public ArrayList<String> getNumberStrings(String val) {
        ArrayList<String> split = new ArrayList<String>();
        int firstOcc = -1;
        int extent = 0;
        int size = 0;
        val = " " + val;
        while (firstOcc != 0) {
            firstOcc = STRING.getFirstIndexOfDigit(val);
            if (firstOcc > 0 && val.substring(firstOcc - 1, firstOcc).equals(".")) {
                --firstOcc;
            }
            split.add(MathScanner.getFirstNumberSubstring(val));
            size = split.get(split.size() - 1).length();
            extent = firstOcc + size;
            val = val.substring(extent);
        }
        ArrayList<String> clearEmptyString = new ArrayList<String>();
        clearEmptyString.add("");
        split.removeAll(clearEmptyString);
        return split;
    }

    public void splitStringOnMethods_Variables_And_Operators() {
        int i;
        CustomScanner cs = new CustomScanner(this.scannerInput, true, VariableManager.VARIABLES.keySet().toArray(new String[0]), Method.getAllFunctions(), Operator.operators);
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("");
        filter.add(",");
        this.scanner.addAll(cs.scan());
        for (i = 0; i < this.scanner.size(); ++i) {
            String token = this.scanner.get(i);
            if (Number.isNumber(token) && !Number.validNumber(token)) {
                for (int j = 0; j < token.length(); ++j) {
                    if (STRING.isNumberComponent(token.substring(j, j + 1)) || !Variable.isVariableString(token.substring(j))) continue;
                    this.scanner.set(i, token.substring(0, j));
                    this.scanner.add(i + 1, "*");
                    this.scanner.add(i + 2, token.substring(j));
                    ++i;
                    break;
                }
            }
            if (i + 1 < this.scanner.size() && (Number.validNumber(token) || Variable.isVariableString(token)) && Variable.isVariableString(this.scanner.get(i + 1))) {
                this.scanner.add(i + 1, "*");
                continue;
            }
            if (i + 1 < this.scanner.size() && Operator.isClosingBracket(token) && Variable.isVariableString(this.scanner.get(i + 1)) && !Method.isListReturningStatsMethod(this.scanner.get(i + 1))) {
                int open = Bracket.getComplementIndex(false, i, this.scanner);
                if (open <= 0 || Operator.isAtOperator(this.scanner.get(open - 1)) || Method.isListReturningStatsMethod(this.scanner.get(open - 1))) continue;
                this.scanner.add(i + 1, "*");
                continue;
            }
            if (i + 1 >= this.scanner.size() || !Number.isNumber(token) || !Operator.isOpeningBracket(this.scanner.get(i + 1))) continue;
            this.scanner.add(i + 1, "*");
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Method.isMethodName(this.scanner.get(i)) || !Number.isNumber(this.scanner.get(i + 1)) && !Method.isMethodName(this.scanner.get(i + 1))) continue;
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1));
                this.scanner.remove(i + 1);
                --i;
                continue;
            }
            catch (IndexOutOfBoundsException token) {
                // empty catch block
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            int index;
            if (this.scanner.get(i).contains("\u00b1")) {
                index = this.scanner.get(i).indexOf("\u00b1");
                this.scanner.set(i, STRING.replace(this.scanner.get(i), "+", index, index + 1));
            } else if (this.scanner.get(i).contains("\u2013")) {
                index = this.scanner.get(i).indexOf("\u2013");
                this.scanner.set(i, STRING.replace(this.scanner.get(i), "-", index, index + 1));
            }
            if (Operator.isOpeningBracket(this.scanner.get(i)) && this.scanner.get(i + 1).equals("-") && Number.isNumber(this.scanner.get(i + 2))) {
                index = this.scanner.get(i + 2).indexOf("\u2013");
                if (index != -1) {
                    this.scanner.set(i + 2, STRING.replace(this.scanner.get(i + 2), "-", index, index + 1));
                }
                this.scanner.set(i + 1, String.valueOf(-1.0 * Double.parseDouble(this.scanner.get(i + 2))));
                this.scanner.remove(i + 2);
            }
            if (!this.scanner.get(i).substring(0, 1).equals("~")) continue;
            this.scanner.set(i, "-" + this.scanner.get(i).substring(1));
        }
        MathScanner.removeExcessBrackets(this.scanner);
        MathScanner.recognizeAnonymousFunctions(this.scanner);
        for (i = 0; i < this.scanner.size(); ++i) {
            List<String> list;
            int close;
            String token = this.scanner.get(i);
            if (i + 1 >= this.scanner.size()) break;
            String nextToken = this.scanner.get(i + 1);
            if (token.equals("diff") && nextToken.equals("(")) {
                close = Bracket.getComplementIndex(true, i + 1, this.scanner);
                list = this.scanner.subList(i, close + 1);
                Parser.parseDerivativeCommand(list);
                if (!list.isEmpty()) continue;
                this.parser_Result = Parser_Result.INCOMPLETE_PARAMS;
                this.setRunnable(false);
                continue;
            }
            if (token.equals("intg") && nextToken.equals("(")) {
                close = Bracket.getComplementIndex(true, i + 1, this.scanner);
                list = this.scanner.subList(i, close + 1);
                NumericalIntegral.extractFunctionStringFromExpression(list);
                if (!list.isEmpty()) continue;
                this.parser_Result = Parser_Result.INCOMPLETE_PARAMS;
                this.setRunnable(false);
                continue;
            }
            if (Method.isMatrixMethod(token) && nextToken.equals("(")) {
                close = Bracket.getComplementIndex(true, i + 1, this.scanner);
                list = this.scanner.subList(i, close + 1);
                MathScanner.extractFunctionStringFromExpressionForMatrixMethods(list);
                if (!list.isEmpty()) continue;
                this.parser_Result = Parser_Result.INCOMPLETE_PARAMS;
                this.setRunnable(false);
                continue;
            }
            if (!token.equals("root") || !nextToken.equals("(")) continue;
            close = Bracket.getComplementIndex(true, i + 1, this.scanner);
            list = this.scanner.subList(i, close + 1);
            RootFinder.extractFunctionStringFromExpression(list);
            if (!list.isEmpty()) continue;
            this.parser_Result = Parser_Result.INCOMPLETE_PARAMS;
            this.setRunnable(false);
        }
        this.scanner.removeAll(filter);
    }

    public void validateInputAfterSplitOnMethodsAndOps() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if ((Method.isFunctionOperatingMethod(this.scanner.get(i)) || Method.isStatsMethod(this.scanner.get(i))) && Operator.isOpeningBracket(this.scanner.get(i + 1))) {
                    i = Bracket.getComplementIndex(true, i + 1, this.scanner);
                    continue;
                }
                if ((Number.isNumber(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) && !Method.isDefinedMethod(this.scanner.get(i))) && this.scanner.get(i + 1).equals("(")) {
                    this.scanner.add(i + 1, "*");
                    ++i;
                    continue;
                }
                if (Number.isNumber(this.scanner.get(i)) && Method.isDefinedMethod(this.scanner.get(i + 1))) {
                    this.scanner.add(i + 1, "*");
                    ++i;
                    continue;
                }
                if (Operator.isClosingBracket(this.scanner.get(i)) && (Variable.isVariableString(this.scanner.get(i + 1)) || Number.isNumber(this.scanner.get(i + 1)))) {
                    this.scanner.add(i + 1, "*");
                    ++i;
                    continue;
                }
                if (!Operator.isClosingBracket(this.scanner.get(i)) || !Operator.isOpeningBracket(this.scanner.get(i + 1))) continue;
                this.scanner.add(i + 1, "*");
                ++i;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateTokens() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (Operator.isOperatorString(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i)) || Method.isMethodName(this.scanner.get(i))) continue;
                this.parser_Result = Parser_Result.STRANGE_INPUT;
                this.setRunnable(false);
                this.errorList.add(this.scanner.get(i) + " is a strange math object!");
                return;
            }
            catch (IndexOutOfBoundsException boundsException) {
                return;
            }
        }
    }

    public void plusAndMinusStringHandler() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (this.scanner.get(i).equals("-") && this.scanner.get(i + 1).equals("-")) {
                this.scanner.set(i, "+");
                this.scanner.subList(i + 1, i + 2).clear();
                --i;
            }
            if (this.scanner.get(i).equals("-") && this.scanner.get(i + 1).equals("+")) {
                this.scanner.set(i, "-");
                this.scanner.subList(i + 1, i + 2).clear();
                --i;
            }
            if (this.scanner.get(i).equals("+") && this.scanner.get(i + 1).equals("-")) {
                this.scanner.set(i, "-");
                this.scanner.subList(i + 1, i + 2).clear();
                --i;
            }
            if (!this.scanner.get(i).equals("+") || !this.scanner.get(i + 1).equals("+")) continue;
            this.scanner.set(i, "+");
            this.scanner.subList(i + 1, i + 2).clear();
            --i;
        }
    }

    public ArrayList<String> scanner() {
        int i;
        this.splitStringOnMethods_Variables_And_Operators();
        if (this.parser_Result != Parser_Result.VALID) {
            this.scanner.clear();
            return this.scanner;
        }
        this.validateInputAfterSplitOnMethodsAndOps();
        if (this.parser_Result != Parser_Result.VALID) {
            this.scanner.clear();
            return this.scanner;
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            if (!Number.isNegative(this.scanner.get(i)) || !this.scanner.get(i + 1).equals("E") || !Number.isNumber(this.scanner.get(i + 2))) continue;
            try {
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1) + this.scanner.get(i + 2));
                this.scanner.remove(i + 1);
                this.scanner.remove(i + 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Operator.isPower(this.scanner.get(i))) continue;
                if (this.scanner.get(i + 1).equals("-") && Number.validNumber(this.scanner.get(i + 2))) {
                    this.scanner.set(i + 1, String.valueOf(-1.0 * Double.parseDouble(this.scanner.get(i + 2))));
                    this.scanner.remove(i + 2);
                    continue;
                }
                if (!this.scanner.get(i + 1).equals("+") || !Number.validNumber(this.scanner.get(i + 2))) continue;
                this.scanner.set(i + 1, String.valueOf(Double.parseDouble(this.scanner.get(i + 2))));
                this.scanner.remove(i + 2);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                continue;
            }
            catch (NumberFormatException indexErr) {
                // empty catch block
            }
        }
        this.validateTokens();
        for (i = 0; i < this.scanner.size(); ++i) {
            int sz = this.scanner.size();
            if (i + 1 < sz && Method.isFunctionOperatingMethod(this.scanner.get(i)) && Operator.isOpeningBracket(this.scanner.get(i + 1))) {
                int close;
                i = close = Bracket.getComplementIndex(true, i + 1, this.scanner);
                continue;
            }
            if (Variable.isVariableString(this.scanner.get(i)) || Operator.isOperatorString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i)) || Method.isMethodName(this.scanner.get(i))) continue;
            this.errorList.add("Syntax Error! Strange Object Found: " + this.scanner.get(i));
            this.setRunnable(false);
            this.parser_Result = Parser_Result.STRANGE_INPUT;
            System.err.println(this.errorList.get(this.errorList.size() - 1));
        }
        if (!this.runnable) {
            this.errorList.add("\nSorry, Errors Were Found In Your Expression.Please Consult The Help File For Valid Mathematical Syntax.");
            this.scanner.clear();
        } else {
            this.errorList.add("Scan SuccessFul.No Illegal Object Found.\nPutting Scanner On StandBy");
        }
        this.plusAndMinusStringHandler();
        return this.scanner;
    }

    public ArrayList<String> scanner(VariableManager varMan) {
        int i;
        this.splitStringOnMethods_Variables_And_Operators();
        this.validateInputAfterSplitOnMethodsAndOps();
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Number.isNegative(this.scanner.get(i)) || !this.scanner.get(i + 1).equals("E") || !Number.isNumber(this.scanner.get(i + 2))) continue;
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1) + this.scanner.get(i + 2));
                this.scanner.remove(i + 1);
                this.scanner.remove(i + 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Operator.isPower(this.scanner.get(i))) continue;
                if (this.scanner.get(i + 1).equals("-") && Number.validNumber(this.scanner.get(i + 2))) {
                    this.scanner.set(i + 1, String.valueOf(-1.0 * Double.parseDouble(this.scanner.get(i + 2))));
                    this.scanner.remove(i + 2);
                    continue;
                }
                if (!this.scanner.get(i + 1).equals("+") || !Number.validNumber(this.scanner.get(i + 2))) continue;
                this.scanner.set(i + 1, String.valueOf(Double.parseDouble(this.scanner.get(i + 2))));
                this.scanner.remove(i + 2);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                continue;
            }
            catch (NumberFormatException indexErr) {
                // empty catch block
            }
        }
        this.validateTokens();
        for (i = 0; i < this.scanner.size(); ++i) {
            int sz = this.scanner.size();
            if (i + 1 < sz && Method.isFunctionOperatingMethod(this.scanner.get(i)) && Operator.isOpeningBracket(this.scanner.get(i + 1))) {
                int close;
                i = close = Bracket.getComplementIndex(true, i + 1, this.scanner);
                continue;
            }
            if (!(Variable.isVariableString(this.scanner.get(i)) || Operator.isOperatorString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i)) || Method.isMethodName(this.scanner.get(i)))) {
                this.errorList.add("Syntax Error! Strange Object Found: " + this.scanner.get(i));
                this.parser_Result = Parser_Result.STRANGE_INPUT;
                this.setRunnable(false);
                System.err.println(this.errorList.get(this.errorList.size() - 1));
            }
            if (MathExpression.isAutoInitOn()) {
                if (i + 1 >= sz || !Variable.isVariableString(this.scanner.get(i)) || Operator.isOpeningBracket(this.scanner.get(i + 1)) || varMan.contains(this.scanner.get(i)) || FunctionManager.contains(this.scanner.get(i))) continue;
                varMan.parseCommand(this.scanner.get(i) + "=0.0;");
                continue;
            }
            if (i + 1 >= sz || !Variable.isVariableString(this.scanner.get(i)) || Operator.isOpeningBracket(this.scanner.get(i + 1)) || varMan.contains(this.scanner.get(i)) || FunctionManager.contains(this.scanner.get(i))) continue;
            this.errorList.add(" Unknown Variable: " + this.scanner.get(i) + "\n Please Declare And Initialize This Variable Before Using It.\nUse The Command, 'variableName=value' To Accomplish This.");
            System.err.println("DETECTED ERROR! IN " + this.scanner);
            this.parser_Result = Parser_Result.STRANGE_INPUT;
            this.setRunnable(false);
        }
        if (!this.runnable) {
            this.errorList.add("\nSorry, Errors Were Found In Your Expression.Please Consult The Help File For Valid Mathematical Syntax.");
            this.scanner.clear();
        } else {
            this.errorList.add("Scan SuccessFul.No Illegal Object Found.\nPutting Scanner On StandBy");
        }
        this.plusAndMinusStringHandler();
        return this.scanner;
    }

    public static void recognizeAnonymousFunctions(List<String> scanner) {
        int indexOfAt = -1;
        block0: while ((indexOfAt = scanner.indexOf("@")) != -1) {
            if (Operator.isOpeningBracket(scanner.get(indexOfAt + 1))) {
                for (int i = indexOfAt; i < scanner.size(); ++i) {
                    int open;
                    String token = scanner.get(i);
                    if (Operator.isOpeningBracket(token)) {
                        i = Bracket.getComplementIndex(true, i, scanner);
                        continue;
                    }
                    if (Operator.isComma(token)) {
                        Function f = new Function(LISTS.createStringFrom(scanner, indexOfAt, i));
                        FunctionManager.add(f);
                        List<String> sub = scanner.subList(indexOfAt, i);
                        sub.clear();
                        sub.add(f.getName());
                        continue block0;
                    }
                    if (!Operator.isClosingBracket(token) || (open = Bracket.getComplementIndex(false, i, scanner)) >= indexOfAt) continue;
                    Function f = new Function(LISTS.createStringFrom(scanner, indexOfAt, i));
                    FunctionManager.add(f);
                    List<String> sub = scanner.subList(indexOfAt, i);
                    sub.clear();
                    sub.add(f.getName());
                    continue block0;
                }
                continue;
            }
            throw new InputMismatchException("Syntax Error occurred while scanning math expression.\nReason: The @ symbol is used exclusively to create functions. Expected: `(`, found: `" + scanner.get(indexOfAt + 1) + "`");
        }
    }

    public static void $removeExcessBrackets(List<String> scanner) {
        for (int i = 0; i < scanner.size(); ++i) {
            if (i + 1 >= scanner.size() || !Operator.isClosingBracket(scanner.get(i))) continue;
            if (Operator.isClosingBracket(scanner.get(i + 1))) {
                int inner_open = Bracket.getComplementIndex(false, i, scanner);
                int outer_open = Bracket.getComplementIndex(false, i + 1, scanner);
                if (inner_open == -1 || outer_open == -1 || inner_open - 1 != outer_open) continue;
                scanner.remove(i);
                scanner.remove(inner_open);
                i -= 2;
                continue;
            }
            int open = Bracket.getComplementIndex(false, i, scanner);
            if (i - open != 2) continue;
            if (open > 0) {
                String token = scanner.get(open - 1);
                if (Variable.isVariableString(token) || Operator.isAtOperator(token) || Method.isMethodName(token) || Operator.isUnaryPreOperator(token)) continue;
                scanner.remove(i);
                scanner.remove(open);
                i -= 2;
                continue;
            }
            if (open != 0) continue;
            scanner.remove(i);
            scanner.remove(open);
            i -= 2;
        }
    }

    public static void removeExcessBrackets(List<String> scanner) {
        for (int i = 0; i < scanner.size(); ++i) {
            if (!Operator.isClosingBracket(scanner.get(i)) || i + 1 < scanner.size() && Operator.isOpeningBracket(scanner.get(i + 1))) continue;
            int open = Bracket.getComplementIndex(false, i, scanner);
            if (i - open == 2) {
                if (open > 0) {
                    String token = scanner.get(open - 1);
                    if (!(Variable.isVariableString(token) || Operator.isAtOperator(token) || Method.isMethodName(token) || Operator.isUnaryPreOperator(token))) {
                        scanner.remove(i);
                        scanner.remove(open);
                        i -= 2;
                        continue;
                    }
                } else if (open == 0) {
                    scanner.remove(i);
                    scanner.remove(open);
                    i -= 2;
                    continue;
                }
            }
            if (i + 1 >= scanner.size() || !Operator.isClosingBracket(scanner.get(i + 1))) continue;
            int inner_open = Bracket.getComplementIndex(false, i, scanner);
            int outer_open = Bracket.getComplementIndex(false, i + 1, scanner);
            if (inner_open == -1 || outer_open == -1 || inner_open - 1 != outer_open || outer_open > 1 && Method.isLogToAnyBase(scanner.get(outer_open - 1))) continue;
            scanner.remove(i);
            scanner.remove(inner_open);
            i -= 2;
        }
    }

    public static void extractFunctionStringFromExpressionForMatrixMethods(List<String> list) {
        block19: {
            block18: {
                int sz;
                block20: {
                    list.removeAll(Arrays.asList(","));
                    sz = list.size();
                    if (list.indexOf("(") != list.lastIndexOf("(") || list.indexOf(")") != list.lastIndexOf(")")) break block18;
                    if (sz != 4 && sz != 5 || !Method.isMatrixMethod(list.get(0)) || !Operator.isOpeningBracket(list.get(1)) || !Method.isUserDefinedFunction(list.get(2))) break block19;
                    if (sz != 4 || !Operator.isClosingBracket(list.get(3))) break block20;
                    Method.run(list, 1);
                    break block19;
                }
                if (sz != 5 || !Method.isUserDefinedFunction(list.get(3)) && !Number.isNumber(list.get(3)) && !Variable.isVariableString(list.get(3)) || !Operator.isClosingBracket(list.get(4))) break block19;
                System.out.println("Debug--4");
                Method.run(list, 1);
                break block19;
            }
            for (int i = 0; i < list.size(); ++i) {
                String input;
                int siz;
                List<String> l;
                int open;
                if (!Operator.isClosingBracket(list.get(i)) || (open = Bracket.getComplementIndex(false, i, list)) <= 0) continue;
                String token = list.get(open - 1);
                if (Method.isMatrixMethod(token)) {
                    l = list.subList(open - 1, i + 1);
                    siz = l.size();
                    System.err.println("list: " + list);
                    MathScanner.extractFunctionStringFromExpressionForMatrixMethods(l);
                    i -= siz - l.size();
                    continue;
                }
                if (FunctionManager.contains(token)) {
                    l = list.subList(open, i + 1);
                    siz = l.size();
                    MathExpression me = new MathExpression(LISTS.createStringFrom(list, open, i + 1));
                    String val = me.solve();
                    l.clear();
                    switch (me.getReturnType()) {
                        case MATRIX: {
                            l.add(me.getReturnObjectName());
                            break;
                        }
                        case ALGEBRAIC_EXPRESSION: {
                            l.add(me.getReturnObjectName());
                            break;
                        }
                        case LIST: {
                            l.add(me.getReturnObjectName());
                            break;
                        }
                        case NUMBER: {
                            l.add(val);
                            break;
                        }
                    }
                    i -= siz - l.size();
                    continue;
                }
                if (!Method.isMethodName(token) && !Operator.isUnaryPreOperator(token) && !Number.isNumber(token)) continue;
                l = list.subList(open - 1, i + 1);
                siz = l.size();
                if (Method.isStatsMethod(token)) {
                    StringBuilder builder = new StringBuilder(token);
                    builder.append("(");
                    for (int j = 2; j < l.size() - 1; ++j) {
                        builder.append(l.get(j)).append(",");
                    }
                    input = builder.substring(0, builder.length() - 1);
                    input = input.concat(")");
                } else {
                    input = LISTS.createStringFrom(list, open - 1, i + 1);
                }
                MathExpression me = new MathExpression(input);
                String val = me.solve();
                l.clear();
                switch (me.getReturnType()) {
                    case MATRIX: {
                        l.add(me.getReturnObjectName());
                        break;
                    }
                    case ALGEBRAIC_EXPRESSION: {
                        l.add(me.getReturnObjectName());
                        break;
                    }
                    case LIST: {
                        l.add(me.getReturnObjectName());
                        break;
                    }
                    case NUMBER: {
                        l.add(val);
                        break;
                    }
                }
                i -= siz - l.size();
            }
        }
    }

    public static void main(String[] args) {
        String expr = "matrix_mul(M,3,((det(M))))";
        CustomScanner cs = new CustomScanner(expr, true, "matrix_mul", "sum", ",", "(", ")", "^", "a", "b", "x");
        List<String> scan = cs.scan();
        System.err.println("----" + scan);
        MathScanner.removeExcessBrackets(scan);
        System.err.println("----" + scan);
    }
}

