/*
 * Decompiled with CFR 0.152.
 */
package parser;

import interfaces.Savable;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import math.matrix.expressParser.Matrix;
import parser.Bracket;
import parser.CustomScanner;
import parser.MathExpression;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Variable;
import parser.methods.Method;
import util.FunctionManager;
import util.Serializer;
import util.VariableManager;

public class Function
implements Savable {
    private Variable dependentVariable;
    private ArrayList<Variable> independentVariables = new ArrayList();
    private int type = 1;
    public static final int ALGEBRAIC = 1;
    public static final int MATRIX = 2;
    public static final int LIST = 3;
    private MathExpression mathExpression;
    private Matrix matrix;

    public Function(Matrix matrix) {
        this.matrix = matrix;
        this.type = 2;
        FunctionManager.add(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function(String input) throws InputMismatchException {
        try {
            input = STRING.purifier(input);
            int openIndex = input.indexOf("(");
            int equalsIndex = input.indexOf("=");
            int atIndex = input.indexOf("@");
            if (equalsIndex == -1) {
                boolean anonymous = input.startsWith("@");
                if (!anonymous) throw new InputMismatchException("Bad function syntax!");
                this.parseInput(input);
                return;
            }
            String tokenAfterEquals = input.substring(equalsIndex + 1, equalsIndex + 2);
            if (atIndex != -1 && atIndex < openIndex) {
                if (atIndex != openIndex - 1) {
                    throw new InputMismatchException("Error in function format... anonymous function assignment format must have the `@` preceding the `(`");
                }
                if (!tokenAfterEquals.equals("@")) {
                    throw new InputMismatchException("Error in function format... anonymous function assignment format must have the `=` preceding the `@`");
                }
            }
            if (openIndex == -1 || equalsIndex == -1) {
                throw new InputMismatchException("Bad function format!");
            }
            int close = Bracket.getComplementIndex(true, openIndex, input);
            String name = null;
            if (openIndex < equalsIndex) {
                name = input.substring(0, openIndex);
                input = name + "=@" + input.substring(openIndex, close + 1) + input.substring(equalsIndex + 1);
            }
            openIndex = input.indexOf("(");
            equalsIndex = input.indexOf("=");
            close = Bracket.getComplementIndex(true, openIndex, input);
            if (name == null) {
                name = input.substring(0, equalsIndex);
            }
            if (!Variable.isVariableString(name)) {
                throw new InputMismatchException("Bad name for Function.");
            }
            String paramsList = input.substring(openIndex + 1, close);
            List<String> params = new CustomScanner(paramsList, false, ",").scan();
            int size = params.size();
            boolean notAlgebraic = true;
            for (String p : params) {
                try {
                    Double.parseDouble(p);
                }
                catch (Exception e) {
                    notAlgebraic = false;
                    break;
                }
            }
            if (notAlgebraic) {
                if (size == 1) {
                    int listSize = Integer.parseInt(params.get(0));
                    this.type = 3;
                    return;
                } else {
                    if (size != 2) return;
                    int rows = Integer.parseInt(params.get(0));
                    int cols = Integer.parseInt(params.get(1));
                    int indexOfLastCloseBrac = input.lastIndexOf(")");
                    int compIndexOfLastCloseBrac = Bracket.getComplementIndex(false, indexOfLastCloseBrac, input);
                    String list = input.substring(compIndexOfLastCloseBrac, indexOfLastCloseBrac + 1);
                    if (!list.startsWith("(") || !list.endsWith(")")) {
                        throw new InputMismatchException("Invalid Matrix Format...Circular Parentheses missing");
                    }
                    List<String> matrixData = new CustomScanner(list = list.substring(1, list.length() - 1), false, ",").scan();
                    if (rows * cols != matrixData.size()) throw new InputMismatchException("Invalid number of entries found in Matrix Data---for input: " + input);
                    matrixData.add(0, cols + "");
                    matrixData.add(0, rows + "");
                    for (int i = 0; i < matrixData.size(); ++i) {
                        try {
                            Double.parseDouble(matrixData.get(i));
                            continue;
                        }
                        catch (Exception e) {
                            throw new InputMismatchException("Invalid Matrix Data..." + matrixData.get(i) + " found.");
                        }
                    }
                    this.matrix = Function.listToMatrix(matrixData);
                    this.type = 2;
                    this.matrix.setName(name);
                }
                return;
            } else {
                this.parseInput(input);
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InputMismatchException("Bad Function Syntax--" + input);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public double calc(double ... x) {
        int i = 0;
        if (x.length == this.independentVariables.size()) {
            for (Variable var : this.independentVariables) {
                this.mathExpression.setValue(var.getName(), String.valueOf(x[i++]));
            }
            return Double.parseDouble(this.mathExpression.solve());
        }
        return Double.NaN;
    }

    public static boolean assignObject(String input) {
        input = STRING.purifier(input);
        int equalsIndex = input.indexOf("=");
        int semiColonIndex = input.indexOf(";");
        int indexOfOpenBrac = input.indexOf("(");
        if (equalsIndex == -1 && semiColonIndex == -1 && indexOfOpenBrac == -1) {
            throw new InputMismatchException("Wrong Input!");
        }
        if (indexOfOpenBrac != -1 && indexOfOpenBrac < equalsIndex) {
            input = input.substring(0, indexOfOpenBrac) + "=@" + input.substring(indexOfOpenBrac, Bracket.getComplementIndex(true, indexOfOpenBrac, input) + 1) + input.substring(equalsIndex + 1);
            equalsIndex = input.indexOf("=");
            semiColonIndex = input.indexOf(";");
        }
        boolean success = false;
        if (equalsIndex != -1 && semiColonIndex != -1) {
            String newFuncName = input.substring(0, equalsIndex);
            boolean isVarNamesList = Function.isParameterList("(" + newFuncName + ")");
            boolean hasCommas = newFuncName.contains(",");
            String rhs = input.substring(equalsIndex + 1, semiColonIndex);
            if (Number.validNumber(rhs)) {
                if (Variable.isVariableString(newFuncName)) {
                    VariableManager.VARIABLES.put(newFuncName, new Variable(newFuncName, rhs, false));
                } else if (isVarNamesList) {
                    List<String> vars = new CustomScanner(newFuncName, false, ",").scan();
                    for (String var : vars) {
                        VariableManager.VARIABLES.put(var, new Variable(var, rhs, false));
                    }
                }
                success = true;
            } else {
                MathExpression expr = new MathExpression(rhs);
                String val = expr.solve();
                String referenceName = expr.getReturnObjectName();
                if (Variable.isVariableString(newFuncName) || isVarNamesList) {
                    switch (expr.getReturnType()) {
                        case MATRIX: {
                            if (isVarNamesList && hasCommas) {
                                throw new InputMismatchException("Initialize a function at a time!");
                            }
                            Function f = FunctionManager.lookUp(referenceName);
                            FunctionManager.FUNCTIONS.put(newFuncName, new Function(newFuncName + "=" + f.expressionForm()));
                            success = true;
                            break;
                        }
                        case ALGEBRAIC_EXPRESSION: {
                            if (isVarNamesList && hasCommas) {
                                throw new InputMismatchException("Initialize a function at a time!");
                            }
                            Function f = FunctionManager.lookUp(referenceName);
                            FunctionManager.FUNCTIONS.put(newFuncName, new Function(newFuncName + "=" + f.expressionForm()));
                            success = true;
                            break;
                        }
                        case LIST: {
                            if (isVarNamesList && hasCommas) {
                                throw new InputMismatchException("Initialize a function at a time!");
                            }
                            Function f = FunctionManager.lookUp(referenceName);
                            FunctionManager.FUNCTIONS.put(newFuncName, new Function(newFuncName + "=" + f.expressionForm()));
                            success = true;
                            break;
                        }
                        case STRING: {
                            break;
                        }
                        case NUMBER: {
                            if (isVarNamesList && hasCommas) {
                                List<String> vars = new CustomScanner(newFuncName, false, ",").scan();
                                for (String var : vars) {
                                    VariableManager.VARIABLES.put(var, new Variable(var, val, false));
                                }
                                success = true;
                                break;
                            }
                            VariableManager.VARIABLES.put(newFuncName, new Variable(newFuncName, val, false));
                            success = true;
                            break;
                        }
                        case VOID: {
                            break;
                        }
                    }
                } else {
                    throw new InputMismatchException("Syntax Error---" + newFuncName);
                }
            }
        }
        if (success) {
            FunctionManager.update();
            VariableManager.update();
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseInput(String input) {
        if (!(input = input.trim()).contains("@")) throw new InputMismatchException("Syntax Error: Format Is: F=@(x,y,z,...)mathexpr");
        boolean anonymous = input.startsWith("@");
        if (anonymous) {
            input = "anon" + (FunctionManager.countAnonymousFunctions() + 1) + "=".concat(input);
        }
        String[] cutUpInput = new String[]{input.substring(0, input.indexOf("=")).trim(), input.substring(input.indexOf("@") + 1, input.indexOf(")") + 1).trim(), input.substring(input.indexOf(")") + 1)};
        CustomScanner cs = new CustomScanner(cutUpInput[1], false, ",", "(", ")");
        List<String> scan = cs.scan();
        if (Variable.isVariableString(cutUpInput[0]) && Function.isParameterList(cutUpInput[1])) {
            if (cutUpInput[0].startsWith("anon") && !anonymous) {
                throw new InputMismatchException("Function Name Cannot Start With 'anon'.\n 'anon' is a reserved name for anonymous functions.");
            }
            if (Method.isInBuiltMethod(cutUpInput[0])) {
                throw new InputMismatchException(cutUpInput[0] + " is a reserved name for inbuilt methods.");
            }
            this.setDependentVariable(new Variable(cutUpInput[0]));
            String vars = "";
            for (int i = 0; i < scan.size(); ++i) {
                try {
                    if (!Variable.isVariableString(scan.get(i))) continue;
                    this.independentVariables.add(new Variable(scan.get(i), "0.0", false));
                    vars = vars.concat(scan.get(i) + "=0.0;");
                    continue;
                }
                catch (IndexOutOfBoundsException boundsException) {
                    break;
                }
            }
            while (cutUpInput[2].startsWith("(") && cutUpInput[2].endsWith(")") && Bracket.getComplementIndex(true, 0, cutUpInput[2]) == cutUpInput[2].length() - 1) {
                cutUpInput[2] = cutUpInput[2].substring(1, cutUpInput[2].length() - 1).trim();
            }
            this.setMathExpression(new MathExpression(vars.concat(cutUpInput[2].trim())));
            if (this.mathExpression.isCorrectFunction()) return;
            throw new InputMismatchException("SYNTAX ERROR IN FUNCTION");
        }
        if (!Function.isDimensionsList(cutUpInput[1])) throw new InputMismatchException("Syntax Error: Format Is: F=@(x,y,z,...)mathexpr");
        Function f = new Function(input);
        this.matrix = f.matrix;
        this.type = f.type;
    }

    public void setDependentVariable(Variable dependentVariable) {
        this.dependentVariable = dependentVariable;
    }

    public Variable getDependentVariable() {
        return this.dependentVariable;
    }

    public void setMathExpression(MathExpression mathExpression) {
        this.mathExpression = mathExpression;
    }

    public MathExpression getMathExpression() {
        return this.mathExpression;
    }

    public void setIndependentVariables(ArrayList<Variable> independentVariables) {
        this.independentVariables = independentVariables;
    }

    public ArrayList<Variable> getIndependentVariables() {
        return this.independentVariables;
    }

    public int numberOfParameters() {
        if (this.type == 3) {
            return 1;
        }
        if (this.type == 2) {
            return 2;
        }
        return this.independentVariables.size();
    }

    private static boolean isDimensionsList(String list) {
        CustomScanner cs = new CustomScanner(list = STRING.purifier(list), true, "(", ",", ")");
        List<String> scan = cs.scan();
        if (!scan.get(0).equals("(") || !scan.get(scan.size() - 1).equals(")")) {
            return false;
        }
        scan.remove(0);
        scan.remove(scan.size() - 1);
        int sz = scan.size();
        for (int i = 0; i < sz; ++i) {
            try {
                if (!Number.validNumber(scan.get(i)) && !Operator.isComma(scan.get(i))) {
                    return false;
                }
                if (i == 0 || i == scan.size() - 1) {
                    if (Number.validNumber(scan.get(i))) continue;
                    return false;
                }
                if (Number.validNumber(scan.get(i)) && !Operator.isComma(scan.get(i + 1))) {
                    return false;
                }
                if (!Operator.isComma(scan.get(i)) || Number.validNumber(scan.get(i + 1))) continue;
                return false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean isParameterList(String list) {
        CustomScanner cs = new CustomScanner(list = STRING.purifier(list), true, "(", ",", ")");
        List<String> scan = cs.scan();
        if (!scan.get(0).equals("(") || !scan.get(scan.size() - 1).equals(")")) {
            return false;
        }
        scan.remove(0);
        scan.remove(scan.size() - 1);
        int sz = scan.size();
        if (sz == 0) {
            return false;
        }
        if (sz == 1 && Variable.isVariableString(scan.get(0))) {
            return true;
        }
        for (int i = 0; i < sz; ++i) {
            try {
                if (!Variable.isVariableString(scan.get(i)) && !Operator.isComma(scan.get(i))) {
                    return false;
                }
                if (i == 0 || i == sz - 1) {
                    if (Variable.isVariableString(scan.get(i))) continue;
                    return false;
                }
                if (Variable.isVariableString(scan.get(i)) && !Operator.isComma(scan.get(i + 1))) {
                    return false;
                }
                if (!Operator.isComma(scan.get(i)) || Variable.isVariableString(scan.get(i + 1))) continue;
                return false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Variable getIndependentVariable(String name) {
        if (this.type != 1) {
            return null;
        }
        int sz = this.independentVariables.size();
        for (int i = 0; i < sz; ++i) {
            if (!this.independentVariables.get(i).getName().equalsIgnoreCase(name)) continue;
            return this.independentVariables.get(i);
        }
        return null;
    }

    public boolean hasIndependentVariable(String var) {
        if (this.type != 1) {
            return false;
        }
        Variable v = new Variable(var);
        return this.independentVariables.contains(v);
    }

    public static String[] getParameters(String paramList) {
        paramList = STRING.purifier(paramList);
        CustomScanner cs = new CustomScanner(paramList, false, "(", ",", ")");
        List<String> scan = cs.scan();
        String[] str = new String[scan.size()];
        if (Function.isParameterList(paramList)) {
            return scan.toArray(str);
        }
        throw new InputMismatchException("Syntax Error In Parameter List " + paramList);
    }

    public boolean isParam(String name) {
        return this.getIndependentVariable(name) != null;
    }

    public static synchronized String storeAnonymousMatrixFunction(Matrix matrix) {
        int num = FunctionManager.countAnonymousFunctions();
        String name = "anon" + (num + 1);
        matrix.setName(name);
        FunctionManager.add(new Function(matrix));
        return name;
    }

    public static synchronized String storeAnonymousFunction(String expression) {
        int num = FunctionManager.countAnonymousFunctions();
        String name = "anon" + (num + 1);
        String tempName = "temp" + System.nanoTime();
        Function f = new Function(tempName + "=" + expression);
        f.dependentVariable.setName(name);
        FunctionManager.add(f);
        return name;
    }

    public String evalArgs(String args) {
        if (this.type != 1) {
            return null;
        }
        String str = this.getFullName();
        CustomScanner cs = new CustomScanner(args, false, "(", ")", ",");
        List<String> l = cs.scan();
        if (l.get(0).equals(this.dependentVariable.getName())) {
            l.remove(0);
            int sz = l.size();
            int sz1 = this.independentVariables.size();
            if (sz == sz1) {
                String vars = "";
                for (int i = 0; i < sz; ++i) {
                    String token = l.get(i);
                    if (!Number.validNumber(token) && !Variable.isVariableString(token)) {
                        throw new NumberFormatException("Unrecognized Value or Variable: " + l.get(i));
                    }
                    vars = vars.concat(this.independentVariables.get(i).getName() + "=" + l.get(i) + ";");
                }
                this.mathExpression.getVariableManager().parseCommand(vars);
                return this.mathExpression.solve();
            }
            throw new InputMismatchException("Invalid Argument List! " + sz1 + " arguments expected!");
        }
        throw new InputMismatchException("Pass Arguments To The Format: " + str);
    }

    public String[][] evalRange(String rangeDescr) {
        String variableName = rangeDescr.substring(0, rangeDescr.indexOf(":"));
        rangeDescr = rangeDescr.substring(rangeDescr.indexOf(":") + 1);
        if (this.isParam(variableName)) {
            String xStart = rangeDescr.substring(0, rangeDescr.indexOf(":"));
            rangeDescr = rangeDescr.substring(rangeDescr.indexOf(":") + 1);
            String xEnd = rangeDescr.substring(0, rangeDescr.indexOf(":"));
            rangeDescr = rangeDescr.substring(rangeDescr.indexOf(":") + 1);
            double xStep = Double.valueOf(rangeDescr);
            double x1 = Double.valueOf(xStart);
            double x2 = Double.valueOf(xEnd);
            int sz = (int)((x2 - x1) / xStep);
            String[][] results = new String[2][sz + 1];
            if (x1 > x2) {
                double p = x1;
                x1 = x2;
                x2 = p;
            }
            int i = 0;
            int len = sz + 1;
            for (double x = x1; i < len && x <= x2; x += xStep, ++i) {
                String xStr = String.valueOf(x);
                this.mathExpression.setValue(variableName, xStr);
                results[0][i] = this.mathExpression.solve();
                results[1][i] = xStr;
            }
            return results;
        }
        return new String[][]{null, null};
    }

    public double[][] evalRange(double xLower, double xUpper, double xStep, String variableName, int DRG) {
        if (xLower > xUpper) {
            double p = xLower;
            xLower = xUpper;
            xUpper = p;
        }
        int sz = (int)((xUpper - xLower) / xStep);
        double[][] results = new double[2][sz + 1];
        int len = sz + 1;
        int i = 0;
        for (double x = xLower; i < len && x <= xUpper; x += xStep, ++i) {
            this.mathExpression.setValue(variableName, String.valueOf(x));
            this.mathExpression.setDRG(DRG);
            results[0][i] = Double.parseDouble(this.mathExpression.solve());
            results[1][i] = x;
        }
        return results;
    }

    public static void print2DArray(Object[][] obj) {
        for (Object[] values : obj) {
            for (int i = 0; i < values.length; ++i) {
                System.out.println(values[i]);
            }
        }
    }

    public String eval() {
        this.mathExpression.setDRG(1);
        return this.mathExpression.solve();
    }

    public static boolean isFunctionFullName(String str) {
        if (str.contains("(") && str.contains(")")) {
            CustomScanner cs = new CustomScanner(str = STRING.purifier(str), false, "(", ")", ",");
            List<String> l = cs.scan();
            if (Variable.isVariableString(l.get(0))) {
                int sz = l.size();
                for (int i = 1; i < sz; ++i) {
                    if (Variable.isVariableString(l.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        String fullname = this.getFullName();
        String paramList = fullname.substring(fullname.indexOf("("));
        switch (this.type) {
            case 1: {
                return this.getName() + "=@" + paramList + this.mathExpression.getExpression();
            }
            case 2: {
                return this.getName() + "=@" + paramList + "(" + Function.matrixToCommaList(this.matrix) + ")";
            }
            case 3: {
                return this.getName() + "=@" + paramList + "(" + Function.matrixToCommaList(this.matrix) + ")";
            }
        }
        return "";
    }

    public boolean isAnonymous() {
        return Function.isAnonymous(this);
    }

    public static boolean isAnonymous(Function f) {
        switch (f.type) {
            case 1: {
                return f.dependentVariable.getName().startsWith("anon");
            }
            case 2: {
                return f.matrix.getName().startsWith("anon");
            }
            case 3: {
                return f.matrix.getName().startsWith("anon");
            }
        }
        return false;
    }

    public static boolean isAnonymous(String name) {
        return name.startsWith("anon");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Function) {
            Function f = (Function)obj;
            return this.toString().equals(f.toString());
        }
        return false;
    }

    public String getFullName() {
        switch (this.type) {
            case 1: {
                String str = this.dependentVariable.getName() + "(";
                int sz = this.independentVariables.size();
                for (int i = 0; i < sz; ++i) {
                    str = str + this.independentVariables.get(i).getName() + ",";
                }
                str = str.substring(0, str.length() - 1);
                return str + ")";
            }
            case 2: {
                return this.getName() + "(" + this.matrix.getRows() + "," + this.matrix.getCols() + ")";
            }
            case 3: {
                return this.getName() + "(" + this.matrix.getRows() + "," + this.matrix.getCols() + ")";
            }
        }
        return "";
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return this.dependentVariable.getName();
            }
            case 2: {
                return this.matrix.getName();
            }
            case 3: {
                return this.matrix.getName();
            }
        }
        return "";
    }

    public double calcDet() {
        if (this.type == 2) {
            return this.matrix.determinant();
        }
        return Double.NaN;
    }

    public Matrix calcInverse() {
        if (this.type == 2) {
            return this.matrix.inverse();
        }
        return null;
    }

    public Matrix triangularMatrix() {
        if (this.type == 2) {
            return this.matrix.reduceToTriangularMatrix();
        }
        return null;
    }

    public Matrix reduceToEchelon() {
        if (this.type == 2) {
            return this.matrix.reduceToRowEchelonMatrix();
        }
        return null;
    }

    public String expressionForm() {
        String toString = this.toString();
        return toString.substring(toString.indexOf("=") + 1);
    }

    public static Matrix listToMatrix(List<String> data) {
        int numRows = Integer.parseInt(data.get(0));
        int numCols = Integer.parseInt(data.get(1));
        data.subList(0, 2).clear();
        int size = data.size();
        if (numRows * numCols == size) {
            double[][] arr = new double[numRows][numCols];
            int row = 0;
            int col = 0;
            for (int i = 0; i < size; ++i) {
                arr[row][col] = Double.parseDouble(data.get(i));
                if (col == numCols - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr);
        }
        return null;
    }

    public static List<String> matrixToList(Matrix mat) {
        int numRows = mat.getRows();
        int numCols = mat.getCols();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                data.add(mat.getElem(i, j) + "");
            }
        }
        return data;
    }

    public static String matrixToCommaList(Matrix mat) {
        int numRows = mat.getRows();
        int numCols = mat.getCols();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                str.append(mat.getElem(i, j)).append(",");
            }
        }
        return str.substring(0, str.length() - 1);
    }

    public static Function parse(String enc) {
        return (Function)Serializer.deserialize(enc);
    }

    public static void main(String[] args) {
        MathExpression addMat = new MathExpression("w=6*5;K=@(2,3)(2,3,4,9,8,1);M=@(3,3)(1,4,1,2,4,7,9,1,-2);N=@(3,3)(4,1,8,2,1,3,5,1,9);v=eigpoly(@(3,3)(2,1,5,6,9,2,4,3,8));c=v(30);3*M+N;");
        System.out.println("soln: " + addMat.solve());
        System.out.println(FunctionManager.FUNCTIONS);
        Function func = new Function("p=@(x)sin(x)+x+x^2");
        FunctionManager.add(func);
        System.out.println(func.calc(4.0));
        int count = 10000;
        double start = System.nanoTime();
        for (int i = 1; i <= count; ++i) {
            String string = func.evalArgs("p(" + i + ")");
        }
        double duration = (double)System.nanoTime() - start;
        System.out.println("Eval took: " + duration / ((double)count * 1000000.0) + "ms");
        for (int i = 1; i <= count; ++i) {
            String string = func.evalArgs("p(" + i + ")");
        }
        duration = (double)System.nanoTime() - start;
        System.out.println("Eval took: " + duration / ((double)count * 1000000.0) + "ms");
    }

    @Override
    public String serialize() {
        return Serializer.serialize(this);
    }
}

