/*
 * Decompiled with CFR 0.152.
 */
package math.numericalmethods;

import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import math.differentialcalculus.Derivative;
import parser.Bracket;
import parser.Function;
import parser.LISTS;
import parser.MathExpression;
import parser.Number;
import parser.Operator;
import parser.Variable;
import util.FunctionManager;
import util.VariableManager;

public class RootFinder {
    private Function function;
    private double x1;
    private double x2;

    public RootFinder(String expression) {
        this.setFunction(this.parseFunction(expression));
    }

    public RootFinder(String function, double x1) {
        try {
            this.function = new Function(function);
            this.x1 = x1;
            this.x2 = x1 + 2.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RootFinder(Function function, double x1) {
        try {
            this.function = function;
            this.x1 = x1;
            this.x2 = x1 + 2.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getX1() {
        return this.x1;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getX2() {
        return this.x2;
    }

    public Function parseFunction(String expression) {
        if ((expression = expression.trim()).startsWith("root(") && expression.endsWith(")")) {
            expression = expression.substring(expression.indexOf("(") + 1);
            expression = expression.substring(0, expression.length() - 1);
            double[] args = new double[2];
            int lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[1] = Double.parseDouble(new MathExpression(expression.substring(lastCommaIndex + 1).trim()).solve());
                expression = expression.substring(0, lastCommaIndex).trim();
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("SYNTAX ERROR!");
            }
            lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[0] = Double.parseDouble(new MathExpression(expression.substring(lastCommaIndex + 1).trim()).solve());
                expression = expression.substring(0, lastCommaIndex).trim();
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("SYNTAX ERROR!");
            }
            lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[0] = Double.parseDouble(new MathExpression(expression.substring(lastCommaIndex + 1).trim()).solve());
                expression = expression.substring(0, lastCommaIndex).trim();
                throw new InputMismatchException(" Max of 2 args allowed! ");
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.setX1(args[0]);
            this.setX2(args[1]);
            try {
                if (expression.startsWith("@")) {
                    return new Function(expression);
                }
                if (Variable.isVariableString(expression)) {
                    return FunctionManager.lookUp(expression);
                }
                throw new InputMismatchException("ALGEBRAIC_EXPRESSION SYNTAX ERROR");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            if (!expression.startsWith("root(")) {
                throw new InputMismatchException("Invalid Function Root Expression!");
            }
            if (!expression.endsWith(")")) {
                throw new InputMismatchException("Missing Closing Parenthesis");
            }
        }
        throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
    }

    public static void extractFunctionStringFromExpression(List<String> list) {
        list.removeAll(Arrays.asList(","));
        if (list.get(0).equals("root") && list.get(1).equals("(") && list.get(list.size() - 1).equals(")")) {
            String args1;
            boolean exists;
            String functionName = list.get(2);
            if (Variable.isVariableString(functionName) && (exists = FunctionManager.contains(functionName))) {
                for (int i = 3; i < list.size(); ++i) {
                    if (Operator.isOpeningBracket(list.get(i))) {
                        int closeBracket = Bracket.getComplementIndex(true, i, list);
                        args1 = new MathExpression(LISTS.createStringFrom(list, i, closeBracket + 1)).solve();
                        List<String> l = list.subList(i, closeBracket + 1);
                        l.clear();
                        l.add(args1);
                        continue;
                    }
                    if (!Variable.isVariableString(list.get(i))) continue;
                    String val = VariableManager.getVariable(list.get(i)).getValue();
                    list.set(i, val);
                }
            }
            if (!Number.validNumber(args1 = list.get(3))) {
                list.clear();
            }
        }
    }

    public boolean isValid() {
        return this.function.getMathExpression().getExpression().length() > 0;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getVariable() {
        return this.function.getIndependentVariables().get(0).getName();
    }

    public String findRoots() {
        String ans = new Newtonian().findRoot();
        double val = Double.valueOf(this.function.evalArgs(this.function.getDependentVariable().getName() + "(" + ans + ")"));
        System.err.println("Using Newton's Method: f(" + ans + ") = " + val);
        if (this.approxEqualsZero(val) || this.lenientApproxEqualsZero(val)) {
            return ans;
        }
        return "Range Error!";
    }

    public boolean approxEqualsZero(double number) {
        return Math.abs(number) <= 5.0E-16;
    }

    public boolean lenientApproxEqualsZero(double number) {
        return Math.abs(number) <= 5.0E-11;
    }

    public static void main(String[] args) {
        FunctionManager.add("f=@(p)3*p^3+2*p^2-8*p+1");
        RootFinder finder = new RootFinder("root(f,-0.4,0.11)");
        System.out.println(finder.findRoots());
    }

    private class Newtonian {
        private Newtonian() {
        }

        public String findRoot() {
            double xOne = RootFinder.this.x1;
            String variable = RootFinder.this.getVariable();
            String gradFunxn = Derivative.eval("diff(" + RootFinder.this.function.expressionForm() + ",1)");
            Function gradFunc = new Function("@(" + variable + ")" + gradFunxn);
            RootFinder.this.function.getMathExpression().setDRG(1);
            gradFunc.getMathExpression().setDRG(1);
            RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xOne));
            double f_x = Double.parseDouble(RootFinder.this.function.eval());
            gradFunc.getMathExpression().setValue(variable, String.valueOf(xOne));
            double df_x = Double.parseDouble(gradFunc.eval());
            double x = xOne;
            int count = 0;
            boolean iterationfailed = false;
            double ratio = 0.0;
            while (!RootFinder.this.approxEqualsZero(Math.abs(ratio = f_x / df_x)) && count < 2000) {
                try {
                    RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(x -= ratio));
                    f_x = Double.parseDouble(RootFinder.this.function.eval());
                    gradFunc.getMathExpression().setValue(variable, String.valueOf(x));
                    df_x = Double.parseDouble(gradFunc.eval());
                    System.err.println(variable + " = " + x + " at count = " + ++count);
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    iterationfailed = true;
                    break;
                }
            }
            if (count >= 2000 || iterationfailed) {
                return new Secant().findRoot();
            }
            return String.valueOf(x);
        }
    }

    private class SelfEvaluator {
        private SelfEvaluator() {
        }

        public String findRoot() {
            int count;
            double x1backup = RootFinder.this.x1;
            String variable = RootFinder.this.getVariable();
            RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(RootFinder.this.x1));
            double f1 = Double.parseDouble(RootFinder.this.function.getMathExpression().solve());
            for (count = 0; Math.abs(f1) >= 5.0E-16 && count < 2000; ++count) {
                RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(RootFinder.this.x1));
                f1 = Double.parseDouble(RootFinder.this.function.getMathExpression().solve());
                RootFinder.this.x1 = RootFinder.this.x1 - f1 / (f1 - 8.0);
            }
            if (count >= 2000 && Math.abs(f1) >= 5.0E-16) {
                RootFinder.this.x1 = x1backup;
                RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(RootFinder.this.x1));
                for (count = 0; Math.abs(f1) >= 5.0E-16 && count < 2000; ++count) {
                    RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(RootFinder.this.x1));
                    f1 = Double.parseDouble(RootFinder.this.function.getMathExpression().solve());
                    RootFinder.this.x1 = RootFinder.this.x1 - f1 / (f1 + 8.0);
                }
                if (count >= 2000 && Math.abs(f1) >= 5.0E-16) {
                    return "NO SOLUTION FOUND\n TRY SPECIFYING BOUNDS\nBETWEEN WHICH A ROOT IS KNOWN TO EXIST.";
                }
            }
            return String.valueOf(RootFinder.this.x1);
        }
    }

    private class Secant {
        private Secant() {
        }

        public String findRoot() {
            int count;
            double xOne = RootFinder.this.x1;
            double xTwo = RootFinder.this.x2;
            String variable = RootFinder.this.getVariable();
            RootFinder.this.function.getMathExpression().setDRG(1);
            RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xOne));
            System.err.println("xOne = " + xOne + ", expression: " + RootFinder.this.function.getMathExpression().getExpression());
            double f1 = Double.parseDouble(RootFinder.this.function.eval());
            RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xTwo));
            double f2 = Double.parseDouble(RootFinder.this.function.eval());
            double x = 0.5 * (xOne + xTwo);
            boolean iterationfailed = false;
            for (count = 0; !RootFinder.this.approxEqualsZero(Math.abs(f2)) && !RootFinder.this.approxEqualsZero(Math.abs(f1)) && count < 2000; ++count) {
                try {
                    x = xTwo - f2 * ((xTwo - xOne) / (f2 - f1));
                    xOne = xTwo;
                    xTwo = x;
                    RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xOne));
                    f1 = Double.parseDouble(RootFinder.this.function.getMathExpression().solve());
                    RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xTwo));
                    f2 = Double.parseDouble(RootFinder.this.function.getMathExpression().solve());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    iterationfailed = true;
                    break;
                }
            }
            if (count >= 2000 || iterationfailed) {
                return new Bisection().findRoot();
            }
            return String.valueOf(x);
        }
    }

    private class Bisection {
        private Bisection() {
        }

        private String findRoot() {
            String variable = RootFinder.this.getVariable();
            double f1 = 0.0;
            double f2 = 0.001;
            double f_middle = 0.0;
            double xOne = RootFinder.this.x1;
            double xTwo = RootFinder.this.x2;
            double x_middle = 0.0;
            boolean switchToOtherMethod = false;
            for (int count = 0; Math.abs(f2) >= 0.0 && Math.abs(f1) != Math.abs(f2) && count < 2000; ++count) {
                boolean sign_x2;
                x_middle = 0.5 * (xOne + xTwo);
                RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xOne));
                f1 = Double.valueOf(RootFinder.this.function.getMathExpression().solve());
                RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(xTwo));
                f2 = Double.valueOf(RootFinder.this.function.getMathExpression().solve());
                RootFinder.this.function.getMathExpression().setValue(variable, String.valueOf(x_middle));
                f_middle = Double.valueOf(RootFinder.this.function.getMathExpression().solve());
                boolean sign_middle = f_middle < 0.0;
                boolean sign_x1 = f1 < 0.0;
                boolean bl = sign_x2 = f2 < 0.0;
                if (sign_x1 != sign_x2) {
                    if (sign_middle == sign_x1) {
                        xOne = x_middle;
                        continue;
                    }
                    if (sign_middle != sign_x2) continue;
                    xTwo = x_middle;
                    continue;
                }
                if (sign_x1 != sign_x2) continue;
                switchToOtherMethod = true;
                break;
            }
            if (switchToOtherMethod) {
                SelfEvaluator selfEvaluator = new SelfEvaluator();
                try {
                    return selfEvaluator.findRoot();
                }
                catch (NumberFormatException numErr) {
                    throw new NullPointerException("NO SOLUTION FOUND!");
                }
            }
            return String.valueOf(x_middle);
        }
    }
}

