/*
 * Decompiled with CFR 0.152.
 */
package math.numericalmethods;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.InputMismatchException;
import math.matrix.expressParser.Matrix;
import math.matrix.expressParser.PrecisionMatrix;
import parser.Function;
import parser.MathExpression;
import parser.MathScanner;
import parser.Operator;

public class FunctionExpander {
    private int degree;
    private double xUpper;
    private double xLower;
    private Function function;
    private String polynomial;
    public static final int DOUBLE_PRECISION = 1;
    public static final int BIGDECIMAL_PRECISION = 2;

    public FunctionExpander(double xLower, double xUpper, int degree, int precision, Function function) {
        this.xLower = xLower;
        this.xUpper = xUpper;
        this.degree = degree;
        this.function = function;
        this.buildPolynomial(precision);
    }

    public FunctionExpander(String expression, int precision) {
        this.setFunction(expression, precision);
    }

    public void setFunction(String expression, int precision) {
        this.parsePolynomialCommand(expression);
        this.buildPolynomial(precision);
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public void setxLower(double xLower) {
        this.xLower = xLower;
    }

    public double getxLower() {
        return this.xLower;
    }

    public void setxUpper(double xUpper) {
        this.xUpper = xUpper;
    }

    public double getxUpper() {
        return this.xUpper;
    }

    private double getXStep() {
        double val = this.degree;
        return (this.xUpper - this.xLower) / val;
    }

    public void setPolynomial(String polynomial) {
        this.polynomial = polynomial;
    }

    public String getPolynomial() {
        return this.polynomial;
    }

    public Matrix getMatrix() {
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        double dx = this.getXStep();
        double[][] arr = new double[this.degree + 1][this.degree + 2];
        for (int rows = 0; rows < this.degree + 1; ++rows) {
            for (int cols = 0; cols < this.degree + 2; ++cols) {
                if (cols < this.degree + 1) {
                    arr[rows][cols] = Math.pow(this.xLower + (double)rows * dx, cols);
                    continue;
                }
                if (cols != this.degree + 1) continue;
                fun.setValue(this.function.getIndependentVariables().get(0).getName(), String.valueOf(this.xLower + (double)rows * dx));
                try {
                    arr[rows][cols] = Double.valueOf(fun.solve());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new Matrix(arr);
    }

    public PrecisionMatrix getPrecisionMatrix() {
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        double dx = this.getXStep();
        BigDecimal[][] arr = new BigDecimal[this.degree + 1][this.degree + 2];
        for (int rows = 0; rows < this.degree + 1; ++rows) {
            for (int cols = 0; cols < this.degree + 2; ++cols) {
                if (cols < this.degree + 1) {
                    arr[rows][cols] = BigDecimal.valueOf(Math.pow(this.xLower + (double)rows * dx, cols));
                    continue;
                }
                if (cols != this.degree + 1) continue;
                fun.setValue(this.function.getIndependentVariables().get(0).getName(), String.valueOf(this.xLower + (double)rows * dx));
                try {
                    arr[rows][cols] = new BigDecimal(fun.solve());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new PrecisionMatrix(arr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parsePolynomialCommand(String expression) {
        if ((expression = expression.trim()).startsWith("poly(") && expression.endsWith(")")) {
            expression = expression.substring(expression.indexOf("(") + 1);
            expression = expression.substring(0, expression.length() - 1);
            double[] args = new double[3];
            args[0] = Double.NaN;
            int lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[2] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                expression = expression.substring(0, lastCommaIndex).trim();
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("SYNTAX ERROR!");
            }
            lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[1] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                expression = expression.substring(0, lastCommaIndex).trim();
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("SYNTAX ERROR!");
            }
            lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[0] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                expression = expression.substring(0, lastCommaIndex).trim();
            }
            catch (NumberFormatException numErr) {
            }
            catch (IndexOutOfBoundsException indErr) {
                throw new InputMismatchException("SYNTAX ERROR!");
            }
            lastCommaIndex = expression.lastIndexOf(",");
            try {
                args[0] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                expression = expression.substring(0, lastCommaIndex).trim();
                throw new InputMismatchException(" Max of 3 args allowed! ");
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (new Double(args[0]).isNaN()) {
                this.setxLower(args[1]);
                this.setxUpper(args[2]);
                this.setFunction(new Function(expression));
                return;
            } else {
                if (new Double(args[0]).isNaN()) throw new InputMismatchException("Invalid Integral Expression!");
                this.setxLower(args[0]);
                this.setxUpper(args[1]);
                this.setDegree((int)args[2]);
                this.setFunction(new Function(expression));
            }
            return;
        }
        if (!expression.startsWith("poly(")) {
            throw new InputMismatchException("Invalid Integral Expression!");
        }
        if (expression.endsWith(")")) return;
        throw new InputMismatchException("Missing Closing Parenthesis");
    }

    public void buildPolynomial(int precisionMode) {
        if (precisionMode == 1) {
            Matrix mat = this.getMatrix();
            mat = mat.solveEquation();
            String var = this.function.getIndependentVariables().get(0).getName();
            String poly = "";
            int power = 0;
            double[][] arr = mat.getArray();
            int rows = 0;
            while (rows < mat.getRows()) {
                for (int cols = 0; cols < mat.getCols(); ++cols) {
                    poly = poly.concat(arr[rows][cols] + "*" + var + "^" + power + "+");
                }
                ++rows;
                ++power;
            }
            poly = poly.replace("+-", "-");
            poly = poly.replace("-+", "-");
            poly = poly.replace("--", "+");
            poly = poly.replace("++", "+");
            this.setPolynomial(poly.substring(0, poly.length() - 1));
        } else if (precisionMode == 2) {
            PrecisionMatrix mat = this.getPrecisionMatrix();
            mat = mat.solveEquation();
            String var = this.function.getIndependentVariables().get(0).getName();
            String poly = "";
            int power = 0;
            BigDecimal[][] arr = mat.getArray();
            int rows = 0;
            while (rows < mat.getRows()) {
                for (int cols = 0; cols < mat.getCols(); ++cols) {
                    poly = poly.concat(arr[rows][cols] + var + "^" + power + "+");
                }
                ++rows;
                ++power;
            }
            poly = poly.replace("+-", "-");
            poly = poly.replace("-+", "-");
            poly = poly.replace("--", "+");
            poly = poly.replace("++", "+");
            this.setPolynomial(poly.substring(0, poly.length() - 1));
        } else {
            throw new InputMismatchException("Choose A Relevant Precision Mode.");
        }
    }

    public String getPolynomialDerivative() {
        return new PolynomialCalculus().differentiate();
    }

    public String getPolynomialIntegral() {
        return new PolynomialCalculus().integrate();
    }

    public static void main(String[] args) {
        FunctionExpander polynomial = new FunctionExpander("poly(@(x)(x-1)(x+2)(3+x),1,20,4)", 1);
        System.out.println(polynomial.getPolynomial());
        FunctionExpander expand = new FunctionExpander("poly(@(x)asin(x),0.8,1.0,25)", 1);
        String poly = expand.getPolynomial();
        System.out.println("polynomial function = " + poly + "\n\n\n");
        MathExpression me = new MathExpression(poly);
        me.setDRG(1);
        me.setValue("x", "0.9999");
        System.out.println("evaluating polynomial function with normal parser = " + me.solve());
        expand.getFunction().getIndependentVariable("x").setValue("0.9999");
        System.out.println("evaluating function = " + expand.getFunction().eval());
    }

    private class PolynomialCalculus {
        private ArrayList<String> scanner = new ArrayList();

        public PolynomialCalculus() {
            this.scan();
        }

        public String getPolynomial() {
            return FunctionExpander.this.polynomial;
        }

        public void scan() {
            this.scanner = new MathScanner(FunctionExpander.this.polynomial).scanner();
        }

        public String differentiate() {
            ArrayList<String> myScan = new ArrayList<String>(this.scanner);
            for (int i = 0; i < myScan.size(); ++i) {
                if (!Operator.isPower(myScan.get(i))) continue;
                try {
                    myScan.set(i - 3, String.valueOf(Double.valueOf(myScan.get(i + 1)) * Double.valueOf(myScan.get(i - 3))));
                    myScan.set(i + 1, String.valueOf(Double.valueOf(myScan.get(i + 1)) - 1.0));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            String derivative = myScan.toString().replaceAll("[,| ]", "");
            derivative = derivative.substring(1);
            derivative = derivative.substring(0, derivative.length() - 1);
            derivative = derivative.replace("--", "+");
            derivative = derivative.replace("-+", "-");
            derivative = derivative.replace("+-", "-");
            derivative = derivative.replace("++", "+");
            return derivative;
        }

        public String integrate() {
            ArrayList<String> myScan = new ArrayList<String>(this.scanner);
            for (int i = 0; i < myScan.size(); ++i) {
                if (!Operator.isPower(myScan.get(i))) continue;
                try {
                    myScan.set(i - 3, String.valueOf(Double.valueOf(myScan.get(i - 3)) / (Double.valueOf(myScan.get(i + 1)) + 1.0)));
                    myScan.set(i + 1, String.valueOf(Double.valueOf(myScan.get(i + 1)) + 1.0));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            String integral = myScan.toString().replaceAll("[,| ]", "");
            integral = integral.substring(1);
            integral = integral.substring(0, integral.length() - 1);
            return integral;
        }
    }
}

