/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.util;

import java.util.ArrayList;
import java.util.Random;
import parser.STRING;

public class LinearSystemGenerator {
    private int maximumPossibleNumberInSystem;
    private int size;
    private String startingLetterOfUnknownName;

    public LinearSystemGenerator(int size, int maximumPossibleNumberInSystem, String startingLetterOfUnknownName) {
        this.size = size;
        this.maximumPossibleNumberInSystem = maximumPossibleNumberInSystem;
        this.startingLetterOfUnknownName = STRING.isWord(startingLetterOfUnknownName) ? startingLetterOfUnknownName : "x";
    }

    public void setStartingLetterOfUnknownName(String startingLetterOfUnknownName) {
        this.startingLetterOfUnknownName = startingLetterOfUnknownName;
    }

    public String getStartingLetterOfUnknownName() {
        return this.startingLetterOfUnknownName;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setMaximumPossibleNumberInSystem(int maximumPossibleNumberInSystem) {
        this.maximumPossibleNumberInSystem = maximumPossibleNumberInSystem;
    }

    public int getMaximumPossibleNumberInSystem() {
        return this.maximumPossibleNumberInSystem;
    }

    private ArrayList<String> generateUnknowns() {
        ArrayList<String> vars = new ArrayList<String>();
        for (int i = 1; i <= this.size; ++i) {
            vars.add(this.startingLetterOfUnknownName + i);
        }
        return vars;
    }

    private double generateCoefficient() {
        Random ran = new Random();
        double number = 1.0;
        int choiceOfSign = ran.nextInt(2);
        if (choiceOfSign == 0) {
            number = 1 + ran.nextInt(this.maximumPossibleNumberInSystem);
            int val = (int)number;
            double divisor = 1 + ran.nextInt(val);
            number /= divisor;
        } else if (choiceOfSign == 1) {
            number = 1 + ran.nextInt(this.maximumPossibleNumberInSystem);
            int val = (int)number;
            double divisor = 1 + ran.nextInt(val);
            number /= -1.0 * divisor;
        }
        return number;
    }

    private String buildSystem() {
        String myLinearSystem = "";
        ArrayList<String> unknowns = this.generateUnknowns();
        for (int rows = 0; rows < this.size; ++rows) {
            for (int cols = 0; cols <= this.size; ++cols) {
                if (cols < this.size - 1) {
                    myLinearSystem = myLinearSystem + this.generateCoefficient() + unknowns.get(cols) + "+";
                    continue;
                }
                if (cols == this.size - 1) {
                    myLinearSystem = myLinearSystem + this.generateCoefficient() + unknowns.get(cols);
                    continue;
                }
                if (cols != this.size) continue;
                myLinearSystem = myLinearSystem + " = " + this.generateCoefficient() + ":\n";
            }
        }
        myLinearSystem = myLinearSystem.replace("+-", "-");
        myLinearSystem = myLinearSystem.replace("-+", "-");
        myLinearSystem = myLinearSystem.replace("--", "+");
        myLinearSystem = myLinearSystem.replace("++", "+");
        return myLinearSystem;
    }

    public static void main(String[] args) {
        LinearSystemGenerator gen = new LinearSystemGenerator(70, 100, "x");
        System.out.println(gen.buildSystem());
    }
}

