/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.DerivativeScanner;
import parser.Bracket;
import parser.Number;
import parser.Variable;
import parser.methods.Method;

public class Utilities {
    public static final ArrayList<String> whitespaceremover = new ArrayList();

    public static void freeSpaces(List<String> scan) {
        scan.removeAll(whitespaceremover);
    }

    public static void print(Object obj) {
    }

    public static boolean isAutoGenNameFormat(String name) {
        int indexOfnumber = name.indexOf("_") + 1;
        if (indexOfnumber != -1) {
            String numberpart = name.substring(indexOfnumber);
            return name.startsWith("myDiff_") && Number.isNumber(numberpart);
        }
        return false;
    }

    public static String getText(ArrayList<String> data) {
        StringBuilder sb = new StringBuilder("");
        for (String token : data) {
            sb.append(token);
        }
        return sb.substring(0, sb.length());
    }

    public static boolean isDifferentiable(String value) {
        return Number.isNumber(value) || Variable.isVariableString(value);
    }

    public static boolean isFormula(String name) {
        int indexOfnumber = name.indexOf("_") + 1;
        if (indexOfnumber != -1) {
            String numberpart = name.substring(indexOfnumber);
            return name.startsWith("myForm_") && Number.isNumber(numberpart);
        }
        return false;
    }

    public static void simplifyNegOneProducts(ArrayList<String> list) {
        block2: for (int i = 0; i < list.size(); ++i) {
            try {
                int j;
                block20: {
                    if (!list.get(i).equals("-1") && !list.get(i).equals("-1.0")) continue;
                    if (Bracket.isMulOrDiv(list.get(i - 1))) {
                        j = i - 1;
                        while (true) {
                            if (Bracket.isMulOrDiv(list.get(j))) {
                                --j;
                                continue;
                            }
                            if (Bracket.isClosingBracket(list.get(j))) {
                                j = Bracket.getComplementIndex(false, j, list);
                                --j;
                                continue;
                            }
                            if (Number.isNumber(list.get(j))) {
                                list.set(j, "" + -1.0 * Double.parseDouble(list.get(j)));
                                list.remove(i - 1);
                                --i;
                                break block20;
                            }
                            if (Variable.isVariableString(list.get(j))) {
                                --j;
                                continue;
                            }
                            if (Bracket.isPlusOrMinus(list.get(j))) {
                                if (list.get(j).equals("+")) {
                                    list.set(j, "-");
                                } else {
                                    list.set(j, "+");
                                }
                                list.remove(i - 1);
                                --i;
                                break block20;
                            }
                            if (Bracket.isOpeningBracket(list.get(j))) break;
                        }
                        list.add(j + 1, "-");
                        list.remove(i);
                        --i;
                    }
                }
                if (!Bracket.isMulOrDiv(list.get(i + 1))) continue;
                j = i + 1;
                while (true) {
                    if (Bracket.isMulOrDiv(list.get(j))) {
                        ++j;
                        continue;
                    }
                    if (Bracket.isOpeningBracket(list.get(j))) {
                        j = Bracket.getComplementIndex(true, j, list);
                        ++j;
                        continue;
                    }
                    if (Number.isNumber(list.get(j))) {
                        list.set(j, "" + -1.0 * Double.parseDouble(list.get(j)));
                        list.remove(i + 1);
                        continue block2;
                    }
                    if (Variable.isVariableString(list.get(j))) {
                        ++j;
                        continue;
                    }
                    if (Bracket.isPlusOrMinus(list.get(j))) {
                        if (list.get(j).equals("+")) {
                            list.set(j, "-");
                        } else {
                            list.set(j, "+");
                        }
                        list.remove(i + 1);
                        continue block2;
                    }
                    if (Bracket.isClosingBracket(list.get(j))) break;
                }
                list.add(j + 1, "-");
                list.remove(i);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public static void simplifyZeroes(ArrayList<String> array) {
        for (int i = 0; i < array.size(); ++i) {
            try {
                if (!array.get(i).equals("0") && !array.get(i).equals("0.0")) continue;
                Utilities.simplifyZeroesAt(i, array);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public static void simplifyZeroesAt(int index, ArrayList<String> list) {
        if (list.get(index).equals("0") || list.get(index).equals("0.0")) {
            if (Bracket.isOpeningBracket(list.get(index - 1)) && Bracket.isPlusOrMinus(list.get(index + 1))) {
                if (list.get(index + 1).equals("+")) {
                    list.remove(index + 1);
                    list.remove(index);
                } else if (list.get(index + 1).equals("-")) {
                    list.remove(index);
                }
            } else if (Bracket.isPlusOrMinus(list.get(index - 1))) {
                list.subList(index - 1, index + 1).clear();
            } else if (Bracket.isOpeningBracket(list.get(index - 1)) && Bracket.isClosingBracket(list.get(index + 1)) && !Method.isMethodName(list.get(index - 2))) {
                list.remove(index + 1);
                list.remove(index - 1);
                Utilities.simplifyZeroesAt(--index, list);
            } else if (Bracket.isMulOrDiv(list.get(index + 1))) {
                if (Number.isNumber(list.get(index + 2)) || Variable.isVariableString(list.get(index + 2)) && !Bracket.isOpeningBracket(list.get(index + 3))) {
                    list.subList(index + 1, index + 3).clear();
                } else if (Variable.isVariableString(list.get(index + 2)) && Bracket.isOpeningBracket(list.get(index + 3))) {
                    int close = Bracket.getComplementIndex(true, index + 3, list);
                    list.subList(index + 1, close + 1).clear();
                } else if (Bracket.isOpeningBracket(list.get(index + 2))) {
                    int close = Bracket.getComplementIndex(true, index + 2, list);
                    list.subList(index + 1, close + 1).clear();
                }
                Utilities.simplifyZeroesAt(index, list);
            } else if (list.get(index - 1).equals("*")) {
                if (Number.isNumber(list.get(index - 2)) || Variable.isVariableString(list.get(index - 2))) {
                    if (Bracket.isMulOrDiv(list.get(index - 3))) {
                        list.subList(index - 3, index - 1).clear();
                        index -= 2;
                    } else if (Bracket.isPlusOrMinus(list.get(index - 3))) {
                        list.subList(index - 2, index).clear();
                        index -= 2;
                    } else if (Bracket.isOpeningBracket(list.get(index - 3))) {
                        list.subList(index - 2, index).clear();
                        index -= 2;
                    }
                } else if (Bracket.isClosingBracket(list.get(index - 2))) {
                    int open = Bracket.getComplementIndex(false, index - 2, list);
                    if (Method.isMethodName(list.get(open - 1))) {
                        if (Bracket.isMulOrDiv(list.get(open - 2))) {
                            List<String> temp = list.subList(open - 2, index - 1);
                            int sz = temp.size();
                            temp.clear();
                            index -= sz;
                        } else if (Bracket.isPlusOrMinus(list.get(open - 2))) {
                            List<String> temp = list.subList(open - 2, index);
                            int sz = temp.size();
                            temp.clear();
                            index -= sz;
                        } else if (Bracket.isOpeningBracket(list.get(open - 2))) {
                            List<String> temp = list.subList(open - 1, index);
                            int sz = temp.size();
                            temp.clear();
                            index -= sz;
                        }
                    } else if (Bracket.isMulOrDiv(list.get(open - 1))) {
                        List<String> temp = list.subList(open - 1, index - 1);
                        int sz = temp.size();
                        temp.clear();
                        index -= sz;
                    } else if (Bracket.isPlusOrMinus(list.get(open - 1))) {
                        List<String> temp = list.subList(open - 1, index);
                        int sz = temp.size();
                        temp.clear();
                        index -= sz;
                    } else if (Bracket.isOpeningBracket(list.get(open - 1))) {
                        List<String> temp = list.subList(open - 1, index);
                        int sz = temp.size();
                        temp.clear();
                        index -= sz;
                    }
                }
                Utilities.simplifyZeroesAt(index, list);
            }
        }
    }

    private static void simplifyOneProducts(int index, ArrayList<String> list) {
        if (list.get(index).equals("1") || list.get(index).equals("1.0")) {
            if (list.get(index - 1).equals("(") && list.get(index + 1).equals(")") && !Method.isMethodName(list.get(index - 2))) {
                list.remove(index + 1);
                list.remove(index - 1);
                Utilities.simplifyOneProducts(--index, list);
            } else if (Bracket.isMulOrDiv(list.get(index - 1))) {
                list.subList(index - 1, index + 1).clear();
                Utilities.simplifyOneProducts(index, list);
            } else if (list.get(index + 1).equals("*")) {
                list.subList(index, index + 2).clear();
                Utilities.simplifyOneProducts(index, list);
            }
        }
    }

    public static void simplifyOneProducts(ArrayList<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            try {
                if (!list.get(i).equals("1") && !list.get(i).equals("1.0")) continue;
                Utilities.simplifyOneProducts(i, list);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void openBrackets(ArrayList<String> scan) {
    }

    public static void evaluateTokens(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                if (!Bracket.isClosingBracket(scan.get(i))) continue;
                int close = i;
                int open = Bracket.getComplementIndex(false, close, scan);
                double value = 0.0;
                for (int j = open + 1; j < close; ++j) {
                    if (Bracket.isPlusOrMinus(scan.get(j))) {
                        // empty if block
                    }
                    if (Bracket.isOpeningBracket(scan.get(j))) {
                        int closeIndex;
                        j = closeIndex = Bracket.getComplementIndex(true, j, scan);
                        continue;
                    }
                    if (Variable.isVariableString(scan.get(j))) continue;
                    if (Number.isNumber(scan.get(j)) && Bracket.isOpeningBracket(scan.get(j - 1)) && Bracket.isMulOrDiv(scan.get(j + 1))) {
                        value *= Double.parseDouble(scan.get(j));
                        scan.set(j, "");
                        continue;
                    }
                    if (Number.isNumber(scan.get(j)) && Bracket.isMulOrDiv(scan.get(j - 1))) {
                        value = scan.get(j - 1).equals("*") ? (value *= Double.parseDouble(scan.get(j))) : (value /= Double.parseDouble(scan.get(j)));
                        scan.set(j - 1, "");
                        scan.set(j, "");
                        continue;
                    }
                    if (!Number.isNumber(scan.get(j)) || !Bracket.isMulOrDiv(scan.get(j - 1)) || !Bracket.isClosingBracket(scan.get(j + 1))) continue;
                    value = scan.get(j - 1).equals("*") ? (value *= Double.parseDouble(scan.get(j))) : (value /= Double.parseDouble(scan.get(j)));
                    scan.set(j - 1, "");
                    scan.set(j, "");
                }
                if (value != 0.0) {
                    String val = "" + value;
                    val = val.endsWith(".0") ? val.substring(0, val.indexOf(".")) : val;
                    scan.add(close, val);
                    scan.add(close, "+");
                }
                Utilities.freeSpaces(scan.subList(open, Bracket.getComplementIndex(true, open, scan)));
                if (!scan.get(open + 1).equals("+")) continue;
                scan.remove(open + 1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void tokenRearranger(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                if (!Bracket.isClosingBracket(scan.get(i))) continue;
                int close = i;
                int open = Bracket.getComplementIndex(false, close, scan);
                double value = 0.0;
                for (int j = open + 1; j < close; ++j) {
                    if (Bracket.isOpeningBracket(scan.get(j))) {
                        int closeIndex;
                        j = closeIndex = Bracket.getComplementIndex(true, j, scan);
                        continue;
                    }
                    if (Number.isNumber(scan.get(j)) && Bracket.isPlusOrMinus(scan.get(j - 1)) && Bracket.isPlusOrMinus(scan.get(j + 1))) {
                        value = scan.get(j - 1).equals("-") ? (value += -1.0 * Double.parseDouble(scan.get(j))) : (value += Double.parseDouble(scan.get(j)));
                        scan.set(j - 1, "");
                        scan.set(j, "");
                        continue;
                    }
                    if (Number.isNumber(scan.get(j)) && Bracket.isOpeningBracket(scan.get(j - 1)) && Bracket.isPlusOrMinus(scan.get(j + 1))) {
                        value += Double.parseDouble(scan.get(j));
                        scan.set(j, "");
                        continue;
                    }
                    if (!Number.isNumber(scan.get(j)) || !Bracket.isPlusOrMinus(scan.get(j - 1)) || !Bracket.isClosingBracket(scan.get(j + 1))) continue;
                    value = scan.get(j - 1).equals("-") ? (value += -1.0 * Double.parseDouble(scan.get(j))) : (value += Double.parseDouble(scan.get(j)));
                    scan.set(j - 1, "");
                    scan.set(j, "");
                }
                if (value != 0.0) {
                    String val = "" + value;
                    val = val.endsWith(".0") ? val.substring(0, val.indexOf(".")) : val;
                    scan.add(close, val);
                    scan.add(close, "+");
                }
                Utilities.freeSpaces(scan.subList(open, Bracket.getComplementIndex(true, open, scan)));
                if (!scan.get(open + 1).equals("+")) continue;
                scan.remove(open + 1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void multipleBracketRemover(ArrayList<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!Bracket.isCloseBracket(list.get(i))) continue;
            int n = i;
        }
    }

    public static void multipleBracketRemover_(ArrayList<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            List<String> sub;
            int close;
            int open;
            if (!Bracket.isOpenBracket(list.get(i)) || i <= 0) continue;
            if (Method.isMethodName(list.get(i - 1))) {
                open = i;
                close = Bracket.getComplementIndex(true, i, list);
                try {
                    while (Bracket.isOpenBracket(list.get(open + 1)) && Bracket.isCloseBracket(list.get(close - 1)) && close - 1 == Bracket.getComplementIndex(true, open + 1, list)) {
                        list.remove(close);
                        list.remove(open);
                        close -= 2;
                    }
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (Bracket.isPower(list.get(i - 1))) {
                open = i;
                close = Bracket.getComplementIndex(true, i, list);
                sub = list.subList(open, close + 1);
                if (sub.size() == 3) {
                    list.remove(close);
                    list.remove(open);
                    continue;
                }
                if (sub.contains("+") || sub.contains("-")) {
                    try {
                        while (Bracket.isOpenBracket(list.get(open + 1)) && Bracket.isCloseBracket(list.get(close - 1)) && close - 1 == Bracket.getComplementIndex(true, open + 1, list)) {
                            list.remove(close);
                            list.remove(open);
                            close -= 2;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (sub.contains("+") || sub.contains("-")) continue;
                try {
                    while (Bracket.isOpenBracket(list.get(open + 1)) && Bracket.isCloseBracket(list.get(close - 1)) && close - 1 == Bracket.getComplementIndex(true, open + 1, list)) {
                        list.remove(close);
                        list.remove(open);
                        close -= 2;
                    }
                    list.remove(close);
                    list.remove(open);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (Method.isMethodName(list.get(i - 1)) || Bracket.isPower(list.get(i - 1))) continue;
            open = i;
            close = Bracket.getComplementIndex(true, i, list);
            sub = list.subList(open, close + 1);
            if (sub.size() == 3) {
                list.remove(close);
                list.remove(open);
                continue;
            }
            if (sub.contains("+") || sub.contains("-")) {
                try {
                    while (Bracket.isOpenBracket(list.get(open + 1)) && Bracket.isCloseBracket(list.get(close - 1)) && close - 1 == Bracket.getComplementIndex(true, open + 1, list)) {
                        list.remove(close - 1);
                        list.remove(open + 1);
                        close -= 2;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (sub.contains("+") || sub.contains("-")) continue;
            try {
                while (Bracket.isOpenBracket(list.get(open + 1)) && Bracket.isCloseBracket(list.get(close - 1)) && close - 1 == Bracket.getComplementIndex(true, open + 1, list)) {
                    list.remove(close);
                    list.remove(open);
                    close -= 2;
                }
                list.remove(close);
                list.remove(open);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    public static void main(String[] s) {
        try {
            ArrayList<String> scan = new ArrayList();
            scan = new DerivativeScanner("(1/((x-x^2))*5^sin(((((((((x)))+7))))))-7+((2^(x)))+5*cos(((x-2)))+2*((((((x-1))))))-1)").getScanner();
            Utilities.multipleBracketRemover(scan);
            Utilities.print("scan = " + scan);
        }
        catch (Exception ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        whitespaceremover.add("");
        whitespaceremover.add(" ");
    }
}

