/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.InputMismatchException;
import parser.STRING;

public class Time {
    private long days;
    private int hours;
    private int minutes;
    private int seconds;

    public Time() {
        this("00:00:00:00");
    }

    public Time(String time) {
        this.format$ValidateTime(time);
        long secs = 86400L * this.days + (long)(3600 * this.hours) + (long)(60 * this.minutes) + (long)this.seconds;
        this.format$ValidateTime(Time.convertSecondsToTime(secs));
    }

    public Time(long days, int hours, int minutes, int seconds) {
        long secs = 86400L * days + (long)(3600 * hours) + (long)(60 * minutes) + (long)seconds;
        this.format$ValidateTime(Time.convertSecondsToTime(secs));
    }

    public Time(int hours, int minutes, int seconds) {
        long secs = 3600 * hours + 60 * minutes + seconds;
        this.format$ValidateTime(Time.convertSecondsToTime(secs));
    }

    public Time(int minutes, int seconds) {
        long secs = 60 * minutes + seconds;
        this.format$ValidateTime(Time.convertSecondsToTime(secs));
    }

    public Time(int seconds) {
        this.format$ValidateTime(Time.convertSecondsToTime(seconds));
    }

    public void format$ValidateTime(String time) {
        ArrayList<String> scanned = STRING.split(time, ":");
        for (int i = 0; i < scanned.size(); ++i) {
            scanned.set(i, scanned.get(i).trim());
        }
        if (scanned.size() == 4) {
            try {
                this.days = Integer.valueOf(scanned.get(0)).intValue();
                this.hours = Integer.valueOf(scanned.get(1));
                this.minutes = Integer.valueOf(scanned.get(2));
                this.seconds = Integer.valueOf(scanned.get(3));
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("BAD TIME FORMAT!");
            }
        }
        if (scanned.size() == 3) {
            try {
                this.hours = Integer.valueOf(scanned.get(0));
                this.minutes = Integer.valueOf(scanned.get(1));
                this.seconds = Integer.valueOf(scanned.get(2));
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("BAD TIME FORMAT!");
            }
        }
        if (scanned.size() == 2) {
            try {
                this.days = 0L;
                this.hours = Integer.valueOf(scanned.get(0));
                this.minutes = Integer.valueOf(scanned.get(1));
            }
            catch (NumberFormatException numErr) {
                throw new InputMismatchException("BAD TIME FORMAT!");
            }
        }
        String day = String.valueOf(this.days);
        String hour = String.valueOf(this.hours);
        String minute = String.valueOf(this.minutes);
        String second = String.valueOf(this.seconds);
        if (day.length() < 2) {
            day = "0" + day;
        }
        if (hour.length() < 2) {
            hour = "0" + hour;
        }
        if (minute.length() < 2) {
            minute = "0" + minute;
        }
        if (second.length() < 2) {
            second = "0" + second;
        }
        Long l = this.timeToSeconds();
    }

    public Time timeDiff(Time t1) {
        Long t_diff = Math.abs(this.timeToSeconds() - t1.timeToSeconds());
        return new Time(Time.convertSecondsToTime(t_diff));
    }

    public Time timeAddition(Time t1) {
        Long t_Add = Math.abs(this.timeToSeconds() + t1.timeToSeconds());
        return new Time(Time.convertSecondsToTime(t_Add));
    }

    public String getTime() {
        return this.days + ":" + this.hours + ":" + this.minutes + ":" + this.seconds;
    }

    public void setTime(String time) {
        this.format$ValidateTime(time);
    }

    public long getDays() {
        return this.days;
    }

    public void setDays(long days) {
        this.days = days;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public boolean isAhead(Time t2) {
        return this.timeToSeconds() > t2.timeToSeconds();
    }

    public boolean isBehind(Time t2) {
        return this.timeToSeconds() < t2.timeToSeconds();
    }

    public boolean isSimilarTo(Time t2) {
        return this.timeToSeconds() == t2.timeToSeconds();
    }

    public long timeToSeconds() {
        return 86400L * this.days + (long)(3600 * this.hours) + (long)(60 * this.minutes) + (long)this.seconds;
    }

    public String timeString() {
        return Time.convertSecondsToTime(this.timeToSeconds());
    }

    public static String timeGetter() {
        Calendar myCal = Calendar.getInstance();
        return STRING.purifier(String.format("%1$tH:%1$tM:%1$tS\n", myCal));
    }

    public static String convertSecondsToTime(long seconds) {
        long d = seconds / 86400L;
        long h = seconds % 86400L / 3600L;
        long m = (seconds - (86400L * d + 3600L * h)) / 60L;
        long s = seconds - (86400L * d + 3600L * h + 60L * m);
        String dd = String.valueOf(d);
        String hh = String.valueOf(h);
        String mm = String.valueOf(m);
        String ss = String.valueOf(s);
        if (dd.length() == 1) {
            dd = "0" + dd;
        }
        if (hh.length() == 1) {
            hh = "0" + hh;
        }
        if (mm.length() == 1) {
            mm = "0" + mm;
        }
        if (ss.length() == 1) {
            ss = "0" + ss;
        }
        return dd + ":" + hh + ":" + mm + ":" + ss;
    }

    public boolean isBehindSystemTime() {
        return this.isBehind(new Time(Time.timeGetter()));
    }

    public boolean isSimilarToSystemTime() {
        return this.isSimilarTo(new Time(Time.timeGetter()));
    }

    public boolean isAheadOfSystemTime() {
        return this.isAhead(new Time(Time.timeGetter()));
    }

    public String toString() {
        return this.timeString();
    }

    public static void main(String[] args) {
        Time t1 = new Time("03:10:45:22");
        Time t2 = new Time("00:00:10:42");
        System.out.println(t1.isSimilarTo(t2));
    }
}

