/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import parser.CustomScannerOld;

public class CustomScanner {
    private String input;
    private String[] tokens;
    private boolean includeTokensInOutput;

    public CustomScanner(String input, boolean includeTokensInOutput, String ... splitterTokens) {
        this.input = input;
        this.tokens = splitterTokens;
        this.includeTokensInOutput = includeTokensInOutput;
    }

    public CustomScanner(String input, boolean includeTokensInOutput, String[] moreTokens, String ... tokens) {
        this.input = input;
        this.includeTokensInOutput = includeTokensInOutput;
        ArrayList<String> copier = new ArrayList<String>();
        copier.addAll(Arrays.asList(tokens));
        copier.addAll(Arrays.asList(moreTokens));
        this.tokens = copier.toArray(new String[0]);
    }

    public CustomScanner(String input, boolean includeTokensInOutput, String[] splitterTokens, String[] splitterTokens1, String ... splitterTokens2) {
        this.input = input;
        ArrayList<String> copier = new ArrayList<String>();
        copier.addAll(Arrays.asList(splitterTokens));
        copier.addAll(Arrays.asList(splitterTokens1));
        copier.addAll(Arrays.asList(splitterTokens2));
        this.tokens = copier.toArray(new String[0]);
        this.includeTokensInOutput = includeTokensInOutput;
    }

    public List<String> scan() {
        String in = this.input;
        ArrayList<String> parse = new ArrayList<String>();
        Arrays.sort(this.tokens, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        block0: for (int i = 0; i < in.length(); ++i) {
            for (String token : this.tokens) {
                String portion;
                int len = token.length();
                if (len <= 0 || i + len > in.length() || !(portion = in.substring(i, i + len)).equals(token)) continue;
                if (i != 0) {
                    parse.add(in.substring(0, i));
                }
                if (this.includeTokensInOutput) {
                    parse.add(token);
                }
                in = in.substring(i + len);
                i = -1;
                continue block0;
            }
        }
        if (!in.isEmpty()) {
            parse.add(in);
        }
        return parse;
    }

    public static void main(String[] args) {
        String in = "(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+(28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)+sinh(8)+zopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekm-zopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekm";
        CustomScannerOld scanner = new CustomScannerOld(in, true, "sinh", "+", "-", ")", "(", "sin", "cos", "/", "zopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekm");
        long start = System.nanoTime();
        List<String> scan = scanner.scan();
        long duration = System.nanoTime() - start;
        System.out.println("Old Scanner parse in>>> " + duration + " ns");
        System.out.println("Output>>>\n " + scan);
        CustomScanner scanner1 = new CustomScanner(in, true, "sinh", "+", "-", ")", "(", "sin", "cos", "/", "zopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekm-zopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekmzopmkdmekdekekdmekdmekdmekdmekdmekdmekdmekdmekdmekdmekm");
        start = System.nanoTime();
        List<String> scan1 = scanner1.scan();
        duration = System.nanoTime() - start;
        System.out.println("New Scanner parse in>>> " + duration + " ns");
        System.out.println("Output>>>\n " + scan1);
    }

    public static void main1(String[] args) {
        String code = "28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)";
        CustomScanner customScanner = new CustomScanner(code, true, "sinh", "+", "-", ")", "(", "sin", "cos", "/");
        System.out.println(customScanner.scan());
        System.out.println(customScanner.scan());
    }
}

