/*
 * Decompiled with CFR 0.152.
 */
package math.tartaglia;

import math.quadratic.QuadraticSolver;
import util.Utils;

public class TartagliaSolver {
    private double a;
    private double b;
    private double c;

    public TartagliaSolver(double c, double a, double b) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.normalizeCofficients();
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public void normalizeCofficients() {
        try {
            this.setA(this.a / this.c);
            this.setB(this.b / this.c);
            this.setC(1.0);
        }
        catch (ArithmeticException arit) {
            Utils.logError("THE COEFFICIENT OF x^3 MUST NOT BE ZERO".toUpperCase());
        }
    }

    public String solve() {
        String x1 = "0.0";
        if (this.a > 0.0) {
            try {
                double lhs = this.b / 2.0;
                double rhs = Math.sqrt(Math.pow(this.a, 3.0) / 27.0 + Math.pow(this.b, 2.0) / 4.0);
                x1 = String.valueOf(Math.cbrt(-lhs + rhs) + Math.cbrt(-lhs - rhs));
                QuadraticSolver solver = new QuadraticSolver(1.0, Double.valueOf(x1), this.a + Math.pow(Double.valueOf(x1), 2.0));
                String allSolutions = x1 + ",\n" + solver.solve();
                return allSolutions;
            }
            catch (NumberFormatException numErr) {
                return "SYNTAX ERROR";
            }
        }
        return "THE COEFFICIENT OF X CANNOT BE LESS THAN OR EQUAL TO ZERO.";
    }
}

