/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.InputMismatchException;
import java.util.Random;
import java.util.Scanner;
import math.matrix.expressParser.MatrixValueParser;

public class Matrix {
    private String name;
    private double[][] array;
    private static double det = 0.0;

    public Matrix(int rows, int cols) {
        this("NEW");
        this.array = new double[rows][cols];
    }

    public Matrix(String name) {
        this.name = name;
        this.array = new double[][]{{0.0}};
    }

    public Matrix(double[][] array) {
        this("NEW");
        this.setArray(array);
    }

    public Matrix(Matrix matrix) {
        this("NEW");
        double[][] arr = new double[matrix.getRows()][matrix.getCols()];
        for (int row = 0; row < matrix.getRows(); ++row) {
            for (int col = 0; col < matrix.getCols(); ++col) {
                double val;
                arr[row][col] = val = matrix.array[row][col];
            }
        }
        this.array = arr;
    }

    public int getRows() {
        return this.array.length;
    }

    public int getCols() {
        return this.array[0].length;
    }

    public void setArray(double[][] array) {
        if (array.length > 0) {
            this.array = new double[array.length][array[0].length];
            for (int row = 0; row < array.length; ++row) {
                for (int col = 0; col < array[0].length; ++col) {
                    this.array[row][col] = array[row][col];
                }
            }
        } else {
            this.array = new double[][]{{0.0}, {0.0}};
        }
    }

    public double[][] getArray() {
        return this.array;
    }

    public double getElem(int row, int col) {
        return this.array[row][col];
    }

    private static void setDet(double det) {
        Matrix.det = det;
    }

    private static double getDet() {
        return det;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private double[] getRow(int row) {
        if (row < this.getRows()) {
            return this.array[row];
        }
        throw new IndexOutOfBoundsException("Bad Index, " + row);
    }

    public void swapRow(int row1, int row2) {
        for (int column = 0; column < this.getCols(); ++column) {
            double v1 = this.array[row1][column];
            double v2 = this.array[row2][column];
            double v3 = v1;
            this.array[row1][column] = v2;
            this.array[row2][column] = v3;
        }
    }

    public void swapColumn(int col1, int col2) {
        for (int row = 0; row < this.getRows(); ++row) {
            double v1 = this.array[row][col1];
            double v2 = this.array[row][col2];
            double v3 = v1;
            this.array[row][col1] = v2;
            this.array[row][col2] = v3;
        }
    }

    public void fill() {
        Scanner scanner = new Scanner(System.in);
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                this.array[row][column] = scanner.nextDouble();
            }
        }
    }

    public Matrix add(Matrix matrice) {
        double[][] array1 = matrice.array;
        double[][] matrix = new double[this.getRows()][this.getCols()];
        if (this.getRows() == matrice.getCols() && this.getCols() == matrice.getRows()) {
            for (int row = 0; row < this.getRows(); ++row) {
                for (int column = 0; column < this.getCols(); ++column) {
                    matrix[row][column] = this.array[row][column] + array1[row][column];
                }
            }
        } else {
            System.out.println("ERROR IN MATRIX INPUT!!");
        }
        return new Matrix(matrix);
    }

    public Matrix subtract(Matrix matrice) {
        double[][] array1 = matrice.array;
        double[][] matrix = new double[this.getRows()][this.getCols()];
        if (this.getRows() == matrice.getCols() && this.getCols() == matrice.getRows()) {
            for (int row = 0; row < this.getRows(); ++row) {
                for (int column = 0; column < this.getCols(); ++column) {
                    matrix[row][column] = this.array[row][column] - array1[row][column];
                }
            }
        } else {
            System.out.println("ERROR IN MATRIX INPUT!!");
        }
        return new Matrix(matrix);
    }

    public Matrix scalarMultiply(double scalar) {
        double[][] matrix = new double[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = scalar * this.array[row][column];
            }
        }
        return new Matrix(matrix);
    }

    public Matrix scalarDivide(double scalar) {
        double[][] matrix = new double[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = this.array[row][column] / scalar;
            }
        }
        return new Matrix(matrix);
    }

    public static Matrix multiply(Matrix matrice1, Matrix matrice2) {
        Matrix m = new Matrix(matrice1.getRows(), matrice2.getCols());
        if (matrice1.getCols() == matrice2.getRows()) {
            for (int i = 0; i < matrice1.getRows(); ++i) {
                for (int row = 0; row < matrice2.getCols(); ++row) {
                    double sum = 0.0;
                    for (int column = 0; column < matrice1.getCols(); ++column) {
                        sum += matrice1.array[i][column] * matrice2.array[column][row];
                    }
                    m.array[i][row] = sum;
                }
            }
        } else {
            System.out.println("ERROR IN MATRIX INPUT!!");
        }
        return m;
    }

    public void multiply(Matrix matrice) {
        this.setArray(Matrix.multiply((Matrix)this, (Matrix)matrice).array);
    }

    public static Matrix pow(Matrix mat, int pow) {
        Matrix m = new Matrix(mat.array);
        for (int i = 0; i < pow - 1; ++i) {
            m = Matrix.multiply(m, mat);
        }
        return m;
    }

    public static Matrix power(Matrix mat, int pow) {
        assert (pow >= 0);
        switch (pow) {
            case 0: {
                return Matrix.unitMatrix(mat.getRows(), mat.getCols());
            }
            case 1: {
                return mat;
            }
        }
        return Matrix.multiply(Matrix.power(mat, pow - 1), mat);
    }

    public Matrix unitMatrix() {
        double[][] matrix = new double[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = column == row ? 1.0 : 0.0;
            }
        }
        return new Matrix(matrix);
    }

    public static Matrix unitMatrix(int rowSize, int colSize) {
        double[][] matrix = new double[rowSize][colSize];
        for (int row = 0; row < rowSize; ++row) {
            for (int column = 0; column < colSize; ++column) {
                matrix[row][column] = column == row ? 1.0 : 0.0;
            }
        }
        return new Matrix(matrix);
    }

    public static Matrix unitMatrix(Matrix mat) {
        int rowSize = mat.getRows();
        int colSize = mat.getCols();
        double[][] matrix = new double[rowSize][colSize];
        for (int row = 0; row < rowSize; ++row) {
            for (int column = 0; column < colSize; ++column) {
                matrix[row][column] = column == row ? 1.0 : 0.0;
            }
        }
        return new Matrix(matrix);
    }

    public static Matrix columnJoin(Matrix mat1, Matrix mat2) {
        Matrix join = new Matrix(mat1.getRows(), mat1.getCols() + mat2.getCols());
        if (mat1.getRows() == mat2.getRows()) {
            int columnextender = 0;
            for (int row = 0; row < mat1.getRows(); ++row) {
                for (int col = 0; col < join.getCols(); ++col) {
                    if (col < mat1.getCols()) {
                        columnextender = 0;
                        join.array[row][col] = mat1.array[row][col];
                        continue;
                    }
                    if (col < mat1.getCols()) continue;
                    join.array[row][col] = mat2.array[row][columnextender];
                    ++columnextender;
                }
            }
        }
        return join;
    }

    public void update(double value, int row, int column) {
        if (row < this.getRows() && column < this.getCols()) {
            this.array[row][column] = value;
        }
    }

    public static Matrix rowJoin(Matrix mat1, Matrix mat2) {
        Matrix join = new Matrix(mat1.getRows() + mat2.getRows(), mat1.getCols());
        if (mat1.getCols() == mat2.getCols()) {
            int rowextender = 0;
            for (int row = 0; row < join.getRows(); ++row) {
                for (int col = 0; col < join.getCols(); ++col) {
                    if (row < mat1.getRows()) {
                        join.array[row][col] = mat1.array[row][col];
                        continue;
                    }
                    if (row < mat1.getRows()) continue;
                    join.array[row][col] = mat2.array[rowextender][col];
                }
                if (row < mat1.getRows()) continue;
                ++rowextender;
            }
        }
        return join;
    }

    public void columnDeleteFromEnd(int column) {
        if (column >= 0 && column <= this.getCols()) {
            Matrix matrix = new Matrix(this.getRows(), this.getCols() - column);
            for (int row = 0; row < this.getRows(); ++row) {
                for (int col = 0; col < matrix.getCols(); ++col) {
                    matrix.array[row][col] = this.array[row][col];
                }
            }
            this.setArray(matrix.array);
        } else {
            System.out.println("COLUMN VALUE SHOULD RANGE FROM ZERO TO THE NUMBER OF COLUMNS IN THIS MATRIX.");
        }
    }

    public void columnDeleteFromStart(int column) {
        if (column >= 0 && column <= this.getCols()) {
            Matrix matrix = new Matrix(this.getRows(), this.getCols() - column);
            for (int row = 0; row < this.getRows(); ++row) {
                int counter = 0;
                int col = column;
                while (col < this.getCols()) {
                    matrix.array[row][counter] = this.array[row][col];
                    ++col;
                    ++counter;
                }
            }
            this.setArray(matrix.array);
        } else {
            System.out.println("COLUMN VALUE SHOULD RANGE FROM ZERO TO THE NUMBER OF COLUMNS IN THIS MATRIX.");
        }
    }

    public void rowDeleteFromEnd(int numOfRows) {
        if (numOfRows >= 0 && numOfRows <= this.getRows()) {
            Matrix matrix = new Matrix(this.getRows() - numOfRows, this.getCols());
            for (int row = 0; row < matrix.getRows(); ++row) {
                for (int col = 0; col < this.getCols(); ++col) {
                    matrix.array[row][col] = this.array[row][col];
                }
            }
            this.setArray(matrix.array);
        } else {
            System.out.println("NUMBER OF ROWS TO BE DELETED SHOULD RANGE FROM ZERO TO (AND INCLUDING) THE NUMBER OF ROWS IN THIS MATRIX.");
        }
    }

    public void rowDeleteFromStart(int numOfRows) {
        if (numOfRows >= 0 && numOfRows <= this.getRows()) {
            Matrix matrix = new Matrix(this.getRows() - numOfRows, this.getCols());
            int counter = 0;
            int row = numOfRows;
            while (row < this.getRows()) {
                for (int col = 0; col < this.getCols(); ++col) {
                    matrix.array[counter][col] = this.array[row][col];
                }
                ++row;
                ++counter;
            }
            this.setArray(matrix.array);
        } else {
            System.out.println("NUMBER OF ROWS TO BE DELETED SHOULD RANGE FROM ZERO TO (AND INCLUDING) THE NUMBER OF ROWS IN THIS MATRIX.");
        }
    }

    public Matrix reduceToTriangularMatrix() {
        Matrix mat = new Matrix(this);
        for (int row = 0; row < mat.getRows() && row < this.getCols(); ++row) {
            double val = mat.array[row][row];
            if (val == 0.0) {
                for (int rw = row; rw < mat.getRows(); ++rw) {
                    val = mat.array[rw][row];
                    if (val == 0.0) continue;
                    mat.swapRow(row, rw);
                    break;
                }
                if (val == 0.0) {
                    throw new InputMismatchException("EQUATION CANNOT BE SOLVED");
                }
            }
            int col = row;
            while (col < mat.getCols()) {
                double[] dArray = mat.array[row];
                int n = col++;
                dArray[n] = dArray[n] / val;
            }
            for (int rowed = row + 1; rowed < mat.getRows(); ++rowed) {
                double mul = mat.array[rowed][row];
                for (int coled = row; coled < mat.getCols(); ++coled) {
                    mat.array[rowed][coled] = mat.array[rowed][coled] - mul * mat.array[row][coled];
                }
            }
        }
        return mat;
    }

    public Matrix reduceToRowEchelonMatrix() {
        Matrix mat = new Matrix(this);
        for (int row = 0; row < mat.getRows() && row < this.getCols(); ++row) {
            double val = mat.array[row][row];
            if (val == 0.0) {
                for (int rw = row; rw < mat.getRows(); ++rw) {
                    val = mat.array[rw][row];
                    if (val == 0.0) continue;
                    mat.swapRow(row, rw);
                    break;
                }
                if (val == 0.0) {
                    throw new InputMismatchException("EQUATION CANNOT BE SOLVED");
                }
            }
            for (int rowed = row + 1; rowed < mat.getRows(); ++rowed) {
                double mul = mat.array[rowed][row];
                for (int coled = row; coled < mat.getCols(); ++coled) {
                    mat.array[rowed][coled] = val * mat.array[rowed][coled] - mul * mat.array[row][coled];
                }
            }
        }
        return mat;
    }

    public Matrix solveEquation() {
        return Matrix.solveEquation(this);
    }

    public static Matrix solveEquation(Matrix matrix) {
        Matrix solnMatrix = new Matrix(matrix.getRows(), 1);
        Matrix matrixLoader = matrix.reduceToTriangularMatrix();
        if (matrix.getRows() == matrix.getCols() - 1) {
            double sum = 0.0;
            int counter = 1;
            for (int row = matrixLoader.getRows() - 1; row >= 0; --row) {
                for (int col = row + 1; col < matrixLoader.getCols(); ++col) {
                    if (col < matrixLoader.getCols() - 1) {
                        sum += matrixLoader.array[row][col] * solnMatrix.array[col][0];
                        continue;
                    }
                    if (col != matrixLoader.getCols() - 1) continue;
                    sum = matrixLoader.array[row][col] - sum;
                }
                solnMatrix.array[matrixLoader.getRows() - counter][0] = sum / matrixLoader.array[row][row];
                ++counter;
                sum = 0.0;
            }
        } else {
            throw new IndexOutOfBoundsException("Invalid System Of Linear Equations");
        }
        return solnMatrix;
    }

    public Matrix transpose() {
        double[][] matrix = new double[this.getCols()][this.getRows()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                matrix[col][row] = this.array[row][col];
            }
        }
        return new Matrix(matrix);
    }

    public Matrix minor(int i, int j) {
        double[][] matrix = new double[this.getRows() - 1][this.getCols() - 1];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                if (row < i && column < j) {
                    matrix[row][column] = this.array[row][column];
                    continue;
                }
                if (row < i && column > j) {
                    matrix[row][column - 1] = this.array[row][column];
                    continue;
                }
                if (row > i && column < j) {
                    matrix[row - 1][column] = this.array[row][column];
                    continue;
                }
                if (row <= i || column <= j) continue;
                matrix[row - 1][column - 1] = this.array[row][column];
            }
        }
        return new Matrix(matrix);
    }

    public boolean isSquareMatrix() {
        return this.getRows() == this.getCols();
    }

    public boolean isSystemOfEquations() {
        return this.getRows() == this.getCols() - 1;
    }

    private static double $2X2determinant(Matrix m) {
        return m.array[0][0] * m.array[1][1] - m.array[1][0] * m.array[0][1];
    }

    private static Matrix topRowScalarMultiply(Matrix m, double scalar) {
        int col = 0;
        while (col < m.getCols()) {
            double[] dArray = m.array[0];
            int n = col++;
            dArray[n] = dArray[n] * scalar;
        }
        return new Matrix(m.array);
    }

    private static double det(Matrix m) {
        if (m.getRows() == m.getCols()) {
            if (m.getRows() == 2) {
                return Matrix.$2X2determinant(m);
            }
            for (int col = 0; col < m.getCols(); ++col) {
                double topRow = m.array[0][col] * Math.pow(-1.0, col);
                Matrix mat = Matrix.topRowScalarMultiply(m.minor(0, col), topRow);
                if (mat.getRows() > 2) {
                    Matrix.det(mat);
                    continue;
                }
                det += Matrix.$2X2determinant(mat);
            }
            return det;
        }
        return Double.POSITIVE_INFINITY;
    }

    public double determinant() {
        return this.determ();
    }

    public void randomFill() {
        Random ran = new Random();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.array[row][col] = 1.0 + (double)ran.nextInt(101);
            }
        }
    }

    public void randomFill(int n) {
        Random ran = new Random();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.array[row][col] = 1 + ran.nextInt(n);
            }
        }
    }

    public static boolean isMatrixValue(String matrixValue) {
        MatrixValueParser matrixValueParser = new MatrixValueParser(matrixValue);
        boolean isValid = matrixValueParser.isValid();
        return isValid;
    }

    public String toString() {
        String output = "\n";
        String appender = "";
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                if (column < this.getCols()) {
                    appender = appender + String.format("%7s%3s", this.array[row][column], ",");
                }
                if (column == this.getCols() - 1) {
                    appender = appender.substring(0, appender.length() - 1);
                    appender = appender + "          \n";
                }
                output = output + appender;
                appender = "";
            }
        }
        return output;
    }

    public Matrix getRowMatrix(int row) {
        double[][] arr = new double[1][this.getCols()];
        for (int col = 0; col < this.getCols(); ++col) {
            arr[0][col] = this.array[row][col];
        }
        return new Matrix(arr);
    }

    public Matrix getColumnMatrix(int column) {
        double[][] arr = new double[this.getRows()][1];
        for (int row = 0; row < this.getRows(); ++row) {
            arr[row][0] = this.array[row][column];
        }
        return new Matrix(arr);
    }

    public Matrix oldInverse() {
        Matrix m = new Matrix(this);
        Matrix unit = m.unitMatrix();
        Matrix inverse = new Matrix(new double[m.getRows()][m.getCols()]);
        if (m.isSquareMatrix()) {
            for (int rows = 0; rows < m.getCols(); ++rows) {
                Matrix c = Matrix.columnJoin(m, unit.getColumnMatrix(rows));
                inverse = Matrix.columnJoin(inverse, c.solveEquation());
            }
        }
        inverse.columnDeleteFromStart(m.getRows());
        return inverse;
    }

    public Matrix inverse() {
        Matrix m = new Matrix(this);
        if (m.isSquareMatrix()) {
            int row;
            Matrix unit = m.unitMatrix();
            Matrix inverse = Matrix.columnJoin(this, unit);
            int rows = inverse.getRows();
            int cols = inverse.getCols();
            for (row = 0; row < rows; ++row) {
                int rw;
                double pivot = inverse.array[row][row];
                if (pivot == 0.0) {
                    for (rw = row; rw < rows; ++rw) {
                        pivot = inverse.array[rw][row];
                        if (pivot == 0.0) continue;
                        inverse.swapRow(row, rw);
                        break;
                    }
                    if (pivot == 0.0) {
                        throw new InputMismatchException("INVERSE DOES NOT EXISTS!");
                    }
                }
                int col = row;
                while (col < cols) {
                    double[] dArray = inverse.array[row];
                    int n = col++;
                    dArray[n] = dArray[n] / pivot;
                }
                for (rw = row + 1; rw < rows; ++rw) {
                    double newRowMultiplier = -1.0 * inverse.array[rw][row];
                    for (int col2 = row; col2 < cols; ++col2) {
                        inverse.array[rw][col2] = newRowMultiplier * inverse.array[row][col2] + inverse.array[rw][col2];
                    }
                }
            }
            for (row = rows - 1; row >= 0; --row) {
                for (int rw = row - 1; rw >= 0; --rw) {
                    double newRowMultiplier = -1.0 * inverse.array[rw][row];
                    if (newRowMultiplier == 0.0) continue;
                    for (int col = row; col < cols; ++col) {
                        inverse.array[rw][col] = newRowMultiplier * inverse.array[row][col] + inverse.array[rw][col];
                    }
                }
            }
            inverse.columnDeleteFromStart(m.getRows());
            return inverse;
        }
        return null;
    }

    public double determ() {
        int cols;
        double detMultiplier = 1.0;
        Matrix mat = new Matrix(this);
        int rows = mat.getRows();
        if (rows == (cols = mat.getCols())) {
            int row;
            for (row = 0; row < rows; ++row) {
                int rw;
                double pivot = mat.array[row][row];
                if (pivot == 0.0) {
                    for (rw = row; rw < rows; ++rw) {
                        pivot = mat.array[rw][row];
                        if (pivot == 0.0) continue;
                        mat.swapRow(row, rw);
                        detMultiplier *= -1.0;
                        break;
                    }
                    if (pivot == 0.0) {
                        throw new InputMismatchException("INVERSE DOES NOT EXISTS!");
                    }
                }
                int col = row;
                while (col < cols) {
                    double[] dArray = mat.array[row];
                    int n = col++;
                    dArray[n] = dArray[n] / pivot;
                }
                detMultiplier *= pivot;
                for (rw = row + 1; rw < rows; ++rw) {
                    double newRowMultiplier = -1.0 * mat.array[rw][row];
                    for (int col2 = row; col2 < cols; ++col2) {
                        mat.array[rw][col2] = newRowMultiplier * mat.array[row][col2] + mat.array[rw][col2];
                    }
                }
            }
            for (row = 0; row < rows; ++row) {
                detMultiplier *= mat.array[row][row];
            }
        }
        return detMultiplier;
    }

    public static void main(String ... args) {
        Matrix a = new Matrix(5, 5);
        double[][] arr = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0}, {6.0, 7.0, 8.0, 9.0, 0.0}, {1.0, 2.0, 3.0, 4.0, 5.0}, {6.0, 7.0, 8.0, 9.0, 0.0}, {1.0, 2.0, 3.0, 4.0, 5.0}};
        a.array = arr;
        System.out.println("A: " + a);
        System.out.println("det(A): " + Matrix.det(a));
        Matrix m1 = new Matrix(4, 4);
        double[][] array = new double[][]{{1.0, -8.0, 2.0, 5.0}, {4.0, 8.0, 2.0, 4.0}, {6.0, 5.0, 2.0, 1.0}, {2.0, 1.0, 6.0, 8.0}};
        m1.array = array;
        System.out.printf("Matrix: %s\nDeterminant:\n %f\n", m1.toString(), Matrix.det(m1));
        Matrix triMatrix = m1.reduceToRowEchelonMatrix();
        System.out.printf("Echelon-matrix of above: %s\n", triMatrix.toString());
        int rows = 11;
        int cols = 11;
        Matrix m = new Matrix(rows, cols);
        m.randomFill(20);
        System.out.println("Processing begins.");
        double t0 = System.nanoTime();
        double det = Matrix.det(m);
        double t1 = (double)System.nanoTime() - t0;
        System.out.printf("Old method for determinant gives %4f in %4f %2s \n", det, t1 * 1.0E-6, "ms");
        double t2 = System.nanoTime();
        double det_1 = m.determ();
        double t3 = (double)System.nanoTime() - t2;
        System.out.printf("New method for determinant gives %4f in %4f %2s \n", det_1, t3 * 1.0E-6, "ms");
    }
}

