/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.Derivative;
import math.differentialcalculus.DerivativeScanner;
import math.differentialcalculus.Differentiable;
import math.differentialcalculus.Utilities;

public class Methods {
    public static final String[] inbuiltOperators = new String[]{"+", "-", "*", "/", "^", "(", ")", "-\u00b9", "\u00b2", "\u00b3", "\u221a", "\u00b3\u221a"};
    public static final String[] inbuiltMethods = new String[]{"abs", "sin", "cos", "tan", "sinh", "cosh", "tanh", "sin-\u00b9", "cos-\u00b9", "tan-\u00b9", "sinh-\u00b9", "cosh-\u00b9", "tanh-\u00b9", "sec", "csc", "cot", "sech", "csch", "coth", "sec-\u00b9", "csc-\u00b9", "cot-\u00b9", "sech-\u00b9", "csch-\u00b9", "coth-\u00b9", "exp", "ln", "lg", "log", "ln-\u00b9", "lg-\u00b9", "log-\u00b9", "asin", "acos", "atan", "asinh", "acosh", "atanh", "asec", "acsc", "acot", "asech", "acsch", "acoth", "aln", "alg", "alog", "sqrt", "cbrt", "inverse", "square", "cube", "pow", "floor", "ceil", "diff", "quad", "intg"};

    public static boolean isInbuiltMethodName(String name) {
        for (String nm : inbuiltMethods) {
            if (!nm.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> getMethodDifferential(String method, String var, Derivative d) {
        String append;
        String der = "";
        String string = append = var.equals("x") ? "" : "*diff(" + var + ")";
        if (method.equals("sin")) {
            der = "cos(" + var + ")" + append;
        } else if (method.equals("cos")) {
            der = "-sin(" + var + ")" + append;
        } else if (method.equals("tan")) {
            der = "sec(" + var + ")^2" + append;
        } else if (method.equals("sinh")) {
            der = "cosh(" + var + ")" + append;
        } else if (method.equals("cosh")) {
            der = "sinh(" + var + ")" + append;
        } else if (method.equals("tanh")) {
            der = "sech(" + var + ")^2" + append;
        } else if (method.equals("sin-\u00b9") || method.equals("asin")) {
            der = "1/sqrt(1-" + var + "^2)" + append;
        } else if (method.equals("cos-\u00b9") || method.equals("acos")) {
            der = "-1/sqrt(1-" + var + "^2)" + append;
        } else if (method.equals("tan-\u00b9") || method.equals("atan")) {
            der = "1/sqrt(1+" + var + "^2)" + append;
        } else if (method.equals("sinh-\u00b9") || method.equals("asinh")) {
            der = "1/sqrt(" + var + "^2+1)" + append;
        } else if (method.equals("cosh-\u00b9") || method.equals("acosh")) {
            der = "1/sqrt(" + var + "^2-1)" + append;
        } else if (method.equals("tanh-\u00b9") || method.equals("atanh")) {
            der = "1/(1-" + var + "^2)" + append;
        } else if (method.equals("sec")) {
            der = "sec(" + var + ")*tan(" + var + ")" + append;
        } else if (method.equals("csc")) {
            der = "-csc(" + var + ")*cot(" + var + ")" + append;
        } else if (method.equals("cot")) {
            der = "-csc(" + var + ")^2" + append;
        } else if (method.equals("sech")) {
            der = "sech(" + var + ")*tanh(" + var + ")" + append;
        } else if (method.equals("csch")) {
            der = "csch(" + var + ")*coth(" + var + ")" + append;
        } else if (method.equals("coth")) {
            der = "-csch(" + var + ")^2" + append;
        } else if (method.equals("sec-\u00b9") || method.equals("asec")) {
            der = "1/(abs(" + var + ")*sqrt(" + var + "^2-1))" + append;
        } else if (method.equals("csc-\u00b9") || method.equals("acsc")) {
            der = "-1/(abs(" + var + ")*sqrt(" + var + "^2-1))" + append;
        } else if (method.equals("cot-\u00b9") || method.equals("acot")) {
            der = "-1/(1+" + var + "^2)" + append;
        } else if (method.equals("sech-\u00b9") || method.equals("asech")) {
            der = "-1/(" + var + "*sqrt(1-" + var + "^2))" + append;
        } else if (method.equals("csch-\u00b9") || method.equals("acsch")) {
            der = "-1/(" + var + "*sqrt(1+" + var + "^2))" + append;
        } else if (method.equals("coth-\u00b9") || method.equals("acoth")) {
            der = "1/(1-" + var + "^2)" + append;
        } else if (method.equals("exp")) {
            der = "exp(" + var + ")" + append;
        } else if (method.equals("ln")) {
            der = "1/(" + var + ")" + append;
        } else if (method.equals("lg")) {
            der = "1/(" + var + "*ln(10))" + append;
        } else if (method.equals("abs")) {
            der = var + "/abs(" + var + ")" + append;
        } else if (!method.equals("log")) {
            if (method.equals("ln-\u00b9") || method.equals("aln")) {
                der = "exp(" + var + ")" + append;
            } else if (!method.equals("alog") && !method.equals("log-\u00b9")) {
                if (method.equals("lg-\u00b9") || method.equals("alg")) {
                    der = "10^(" + var + ")*ln(10)" + append;
                } else if (method.equals("sqrt")) {
                    der = "1/(2*sqrt(" + var + "))" + append;
                } else if (method.equals("cbrt")) {
                    der = "1/(3*cbrt(" + var + "^2))" + append;
                } else if (method.equals("inverse")) {
                    der = "-" + var + "^-2" + append;
                } else if (method.equals("square")) {
                    der = "2*" + var + "" + append;
                } else if (method.equals("cube")) {
                    der = "3*" + var + "^2" + append;
                } else if (!(method.equals("pow") || method.equals("floor") || method.equals("ceil"))) {
                    if (method.equals("diff")) {
                        try {
                            Differentiable diff = d.builder.getManager().lookUp(var);
                            String expr = Utilities.getText(d.translateToBaseTerms(diff));
                            Utilities.print("Expression: " + expr + ", var = " + var);
                            Derivative drv = new Derivative(expr);
                            der = drv.differentiate();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (method.equals("quad") || method.equals("intg")) {
                        der = var;
                    }
                }
            }
        }
        try {
            ArrayList<String> scan = new DerivativeScanner("(" + der + ")").getScanner();
            return scan;
        }
        catch (Exception ex) {
            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

