/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.AmqArguments;
import com.github.fridujo.rabbitmq.mock.MockChannel;
import com.github.fridujo.rabbitmq.mock.MockConnection;
import com.github.fridujo.rabbitmq.mock.MockQueue;
import com.github.fridujo.rabbitmq.mock.RandomStringGenerator;
import com.github.fridujo.rabbitmq.mock.Receiver;
import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.github.fridujo.rabbitmq.mock.TransactionalOperations;
import com.github.fridujo.rabbitmq.mock.configuration.Configuration;
import com.github.fridujo.rabbitmq.mock.exchange.MockDefaultExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockExchangeFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.impl.AMQImpl;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class MockNode
implements ReceiverRegistry,
TransactionalOperations {
    private final Configuration configuration = new Configuration();
    private final MockExchangeFactory mockExchangeFactory = new MockExchangeFactory(this.configuration);
    private final MockDefaultExchange defaultExchange = new MockDefaultExchange(this);
    private final Map<String, MockExchange> exchanges = new ConcurrentHashMap<String, MockExchange>();
    private final Map<String, MockQueue> queues = new ConcurrentHashMap<String, MockQueue>();
    private final RandomStringGenerator consumerTagGenerator = new RandomStringGenerator("amq.ctag-", "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 22);

    public MockNode() {
        this.exchanges.put("", this.defaultExchange);
    }

    @Override
    public boolean basicPublish(String exchangeName, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        MockExchange exchange = this.getExchangeUnchecked(exchangeName);
        return exchange.publish(null, routingKey, props, body);
    }

    public String basicConsume(String queueName, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback, Supplier<Long> deliveryTagSupplier, MockConnection mockConnection, MockChannel mockChannel) {
        String definitiveConsumerTag = "".equals(consumerTag) ? this.consumerTagGenerator.generate() : consumerTag;
        this.getQueueUnchecked(queueName).basicConsume(definitiveConsumerTag, callback, autoAck, deliveryTagSupplier, mockConnection, mockChannel);
        return definitiveConsumerTag;
    }

    public Optional<MockQueue> getQueue(String name) {
        return Optional.ofNullable(this.queues.get(name));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchangeName, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.exchanges.putIfAbsent(exchangeName, this.mockExchangeFactory.build(exchangeName, type, new AmqArguments(arguments), this));
        return new AMQImpl.Exchange.DeclareOk();
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) {
        this.exchanges.remove(exchange);
        return new AMQImpl.Exchange.DeleteOk();
    }

    public AMQP.Exchange.BindOk exchangeBind(String destinationName, String sourceName, String routingKey, Map<String, Object> arguments) {
        MockExchange source = this.getExchangeUnchecked(sourceName);
        MockExchange destination = this.getExchangeUnchecked(destinationName);
        source.bind(destination.pointer(), routingKey, arguments);
        return new AMQImpl.Exchange.BindOk();
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destinationName, String sourceName, String routingKey, Map<String, Object> arguments) {
        MockExchange source = this.getExchangeUnchecked(sourceName);
        MockExchange destination = this.getExchangeUnchecked(destinationName);
        source.unbind(destination.pointer(), routingKey, arguments);
        return new AMQImpl.Exchange.UnbindOk();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queueName, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        this.queues.putIfAbsent(queueName, new MockQueue(queueName, new AmqArguments(arguments), this));
        return new AMQP.Queue.DeclareOk.Builder().queue(queueName).build();
    }

    public AMQP.Queue.DeleteOk queueDelete(String queueName, boolean ifUnused, boolean ifEmpty) {
        Optional<MockQueue> queue = Optional.ofNullable(this.queues.remove(queueName));
        queue.ifPresent(MockQueue::notifyDeleted);
        return new AMQImpl.Queue.DeleteOk(queue.map(MockQueue::messageCount).orElse(0).intValue());
    }

    public AMQP.Queue.BindOk queueBind(String queueName, String exchangeName, String routingKey, Map<String, Object> arguments) {
        MockExchange exchange = this.getExchangeUnchecked(exchangeName);
        MockQueue queue = this.getQueueUnchecked(queueName);
        exchange.bind(queue.pointer(), routingKey, arguments);
        return new AMQImpl.Queue.BindOk();
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queueName, String exchangeName, String routingKey, Map<String, Object> arguments) {
        MockExchange exchange = this.getExchangeUnchecked(exchangeName);
        MockQueue queue = this.getQueueUnchecked(queueName);
        exchange.unbind(queue.pointer(), routingKey, arguments);
        return new AMQImpl.Queue.UnbindOk();
    }

    public AMQP.Queue.PurgeOk queuePurge(String queueName) {
        MockQueue queue = this.getQueueUnchecked(queueName);
        int messageCount = queue.purge();
        return new AMQImpl.Queue.PurgeOk(messageCount);
    }

    public GetResponse basicGet(String queueName, boolean autoAck, Supplier<Long> deliveryTagSupplier) {
        MockQueue queue = this.getQueueUnchecked(queueName);
        return queue.basicGet(autoAck, deliveryTagSupplier);
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) {
        this.queues.values().forEach(q -> q.basicAck(deliveryTag, multiple));
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.queues.values().forEach(q -> q.basicNack(deliveryTag, multiple, requeue));
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) {
        this.queues.values().forEach(q -> q.basicReject(deliveryTag, requeue));
    }

    public void basicCancel(String consumerTag) {
        this.queues.values().forEach(q -> q.basicCancel(consumerTag));
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) {
        this.queues.values().forEach(q -> q.basicRecover(requeue));
        return new AMQImpl.Basic.RecoverOk();
    }

    @Override
    public Optional<Receiver> getReceiver(ReceiverPointer receiverPointer) {
        Optional<Receiver> receiver = receiverPointer.type == ReceiverPointer.Type.EXCHANGE ? Optional.ofNullable(this.exchanges.get(receiverPointer.name)) : Optional.ofNullable(this.queues.get(receiverPointer.name));
        return receiver;
    }

    private MockExchange getExchangeUnchecked(String exchangeName) {
        if (!this.exchanges.containsKey(exchangeName)) {
            throw new IllegalArgumentException("No exchange named " + exchangeName);
        }
        return this.exchanges.get(exchangeName);
    }

    private MockQueue getQueueUnchecked(String queueName) {
        if (!this.queues.containsKey(queueName)) {
            throw new IllegalArgumentException("No queue named " + queueName);
        }
        return this.queues.get(queueName);
    }

    Optional<MockExchange> getExchange(String name) {
        return Optional.ofNullable(this.exchanges.get(name));
    }

    public int messageCount(String queueName) {
        MockQueue queue = this.getQueueUnchecked(queueName);
        return queue.messageCount();
    }

    public long consumerCount(String queueName) {
        MockQueue queue = this.getQueueUnchecked(queueName);
        return queue.consumerCount();
    }

    public MockNode restartDeliveryLoops() {
        this.queues.values().forEach(MockQueue::restartDeliveryLoop);
        return this;
    }

    public void close(MockConnection mockConnection) {
        this.queues.values().forEach(q -> q.close(mockConnection));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

