/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.metrics;

import com.github.fridujo.rabbitmq.mock.metrics.ImplementedMetricsCollectorWrapper;
import com.github.fridujo.rabbitmq.mock.metrics.NoopMetricsCollectorWrapper;
import com.github.fridujo.rabbitmq.mock.tool.Classes;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

public interface MetricsCollectorWrapper {
    public void newConnection(Connection var1);

    public void closeConnection(Connection var1);

    public void newChannel(Channel var1);

    public void closeChannel(Channel var1);

    public void basicPublish(Channel var1);

    public void consumedMessage(Channel var1, long var2, boolean var4);

    public void consumedMessage(Channel var1, long var2, String var4);

    public void basicAck(Channel var1, long var2, boolean var4);

    public void basicNack(Channel var1, long var2);

    public void basicReject(Channel var1, long var2);

    public void basicConsume(Channel var1, String var2, boolean var3);

    public void basicCancel(Channel var1, String var2);

    public static class Builder {
        public static MetricsCollectorWrapper build(ConnectionFactory connectionFactory) {
            return Builder.build(Builder.class.getClassLoader(), connectionFactory);
        }

        public static MetricsCollectorWrapper build(ClassLoader classLoader, ConnectionFactory connectionFactory) {
            MetricsCollectorWrapper metricsCollectorWrapper = Classes.missingClass(classLoader, "com.rabbitmq.client.MetricsCollector") ? new NoopMetricsCollectorWrapper() : new ImplementedMetricsCollectorWrapper(connectionFactory);
            return metricsCollectorWrapper;
        }
    }
}

