/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.BindableMockExchange;
import com.github.fridujo.rabbitmq.mock.MockDirectExchange;
import com.github.fridujo.rabbitmq.mock.MockFanoutExchange;
import com.github.fridujo.rabbitmq.mock.MockHeadersExchange;
import com.github.fridujo.rabbitmq.mock.MockTopicExchange;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import java.util.Map;

public abstract class MockExchangeFactory {
    public static BindableMockExchange build(String exchangeName, String type, Map<String, Object> arguments, ReceiverRegistry receiverRegistry) {
        if ("topic".equals(type)) {
            return new MockTopicExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("direct".equals(type)) {
            return new MockDirectExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("fanout".equals(type)) {
            return new MockFanoutExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("headers".equals(type)) {
            return new MockHeadersExchange(exchangeName, arguments, receiverRegistry);
        }
        throw new IllegalArgumentException("No exchange type " + type);
    }
}

