/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.ConsumerWrapper;
import com.github.fridujo.rabbitmq.mock.MockConnection;
import com.github.fridujo.rabbitmq.mock.MockNode;
import com.github.fridujo.rabbitmq.mock.MockQueue;
import com.github.fridujo.rabbitmq.mock.RandomStringGenerator;
import com.github.fridujo.rabbitmq.mock.metrics.MetricsCollectorWrapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockChannel
implements Channel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockChannel.class);
    private final int channelNumber;
    private final MockNode node;
    private final MockConnection mockConnection;
    private final MetricsCollectorWrapper metricsCollectorWrapper;
    private final AtomicBoolean opened = new AtomicBoolean(true);
    private final AtomicLong deliveryTagSequence = new AtomicLong();
    private final RandomStringGenerator queueNameGenerator = new RandomStringGenerator("amq.gen-", "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 22);
    private String lastGeneratedQueueName;

    public MockChannel(int channelNumber, MockNode node, MockConnection mockConnection, MetricsCollectorWrapper metricsCollectorWrapper) {
        this.channelNumber = channelNumber;
        this.node = node;
        this.mockConnection = mockConnection;
        this.metricsCollectorWrapper = metricsCollectorWrapper;
        metricsCollectorWrapper.newChannel(this);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public MockConnection getConnection() {
        return this.mockConnection;
    }

    public void close() {
        this.close(200, "OK");
    }

    public void close(int closeCode, String closeMessage) {
        this.metricsCollectorWrapper.closeChannel(this);
        this.opened.set(false);
    }

    public void abort() {
        this.abort(200, "OK");
    }

    public void abort(int closeCode, String closeMessage) {
        this.close(closeCode, closeMessage);
    }

    public void addReturnListener(ReturnListener listener) {
        throw new UnsupportedOperationException();
    }

    public ReturnListener addReturnListener(ReturnCallback returnCallback) {
        throw new UnsupportedOperationException();
    }

    public boolean removeReturnListener(ReturnListener listener) {
        throw new UnsupportedOperationException();
    }

    public void clearReturnListeners() {
        throw new UnsupportedOperationException();
    }

    public void addConfirmListener(ConfirmListener listener) {
        throw new UnsupportedOperationException();
    }

    public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
        throw new UnsupportedOperationException();
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        throw new UnsupportedOperationException();
    }

    public void clearConfirmListeners() {
        throw new UnsupportedOperationException();
    }

    public Consumer getDefaultConsumer() {
        throw new UnsupportedOperationException();
    }

    public void setDefaultConsumer(Consumer consumer) {
        throw new UnsupportedOperationException();
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
    }

    public void basicQos(int prefetchCount, boolean global) {
        this.basicQos(0, prefetchCount, true);
    }

    public void basicQos(int prefetchCount) {
        this.basicQos(prefetchCount, true);
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) {
        this.basicPublish(exchange, routingKey, false, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) {
        this.basicPublish(exchange, routingKey, false, false, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        this.node.basicPublish(exchange, routingKey, mandatory, immediate, this.nullToEmpty(props), body);
        this.metricsCollectorWrapper.basicPublish(this);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) {
        return this.exchangeDeclare(exchange, type, false, true, false, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) {
        return this.exchangeDeclare(exchange, type, false);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) {
        return this.exchangeDeclare(exchange, type, durable, true, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) {
        return this.exchangeDeclare(exchange, type, durable, true, Collections.emptyMap());
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) {
        return this.exchangeDeclare(exchange, type, durable, autoDelete, false, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        return this.node.exchangeDeclare(exchange, type, durable, autoDelete, internal, this.nullToEmpty(arguments));
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        return this.exchangeDeclare(exchange, type.getType(), durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) {
        this.exchangeDeclareNoWait(exchange, type.getType(), durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        if (!this.node.getExchange(name).isPresent()) {
            throw new IOException((Throwable)new ShutdownSignalException(false, false, (Method)new AMQImpl.Channel.Close(404, "NOT_FOUND", 40, 10), null, "no exchange '" + name + "' in vhost '/' ", null));
        }
        return new AMQImpl.Exchange.DeclareOk();
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) {
        return this.node.exchangeDelete(exchange);
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) {
        this.exchangeDelete(exchange, ifUnused);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) {
        return this.exchangeDelete(exchange, false);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) {
        return this.exchangeBind(destination, source, routingKey, Collections.emptyMap());
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return this.node.exchangeBind(destination, source, routingKey, this.nullToEmpty(arguments));
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeBind(destination, source, routingKey, arguments);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) {
        return this.exchangeUnbind(destination, source, routingKey, Collections.emptyMap());
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return this.node.exchangeUnbind(destination, source, routingKey, this.nullToEmpty(arguments));
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeUnbind(destination, source, routingKey, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclare() {
        return this.queueDeclare("", false, true, true, Collections.emptyMap());
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        return this.node.queueDeclare(this.generateIfEmpty(queue), durable, exclusive, autoDelete, arguments, this);
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queueName) throws IOException {
        String definitiveQueueName = this.lastGeneratedIfEmpty(queueName);
        Optional<MockQueue> queue = this.node.getQueue(definitiveQueueName);
        if (!queue.isPresent()) {
            throw new IOException((Throwable)new ShutdownSignalException(false, false, (Method)new AMQImpl.Channel.Close(404, "NOT_FOUND", 50, 10), null, "no queue '" + definitiveQueueName + "' in vhost '/' ", null));
        }
        return new AMQImpl.Queue.DeclareOk(definitiveQueueName, queue.get().messageCount(), queue.get().consumerCount());
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) {
        return this.queueDelete(queue, false, false);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) {
        return this.node.queueDelete(this.lastGeneratedIfEmpty(queue), ifUnused, ifEmpty);
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) {
        this.queueDelete(queue, ifUnused, ifEmpty);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) {
        return this.queueBind(queue, exchange, routingKey, Collections.emptyMap());
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.node.queueBind(this.lastGeneratedIfEmpty(queue), exchange, routingKey, this.nullToEmpty(arguments));
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueBind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) {
        return this.queueUnbind(queue, exchange, routingKey, Collections.emptyMap());
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return this.node.queueUnbind(this.lastGeneratedIfEmpty(queue), exchange, routingKey, this.nullToEmpty(arguments));
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) {
        return this.node.queuePurge(this.lastGeneratedIfEmpty(queue));
    }

    public GetResponse basicGet(String queue, boolean autoAck) {
        GetResponse getResponse = this.node.basicGet(this.lastGeneratedIfEmpty(queue), autoAck, this::nextDeliveryTag);
        if (getResponse != null) {
            this.metricsCollectorWrapper.consumedMessage((Channel)this, getResponse.getEnvelope().getDeliveryTag(), autoAck);
        }
        return getResponse;
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.node.basicAck(deliveryTag, multiple);
        this.metricsCollectorWrapper.basicAck(this, deliveryTag, multiple);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.node.basicNack(deliveryTag, multiple, requeue);
        this.metricsCollectorWrapper.basicNack(this, deliveryTag);
    }

    public void basicReject(long deliveryTag, boolean requeue) {
        this.node.basicReject(deliveryTag, requeue);
        this.metricsCollectorWrapper.basicReject(this, deliveryTag);
    }

    public String basicConsume(String queue, Consumer callback) {
        return this.basicConsume(queue, false, callback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.basicConsume(queue, false, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, false, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, false, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) {
        return this.basicConsume(queue, autoAck, Collections.emptyMap(), callback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.basicConsume(queue, autoAck, Collections.emptyMap(), deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, Collections.emptyMap(), deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, Collections.emptyMap(), deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) {
        return this.basicConsume(queue, autoAck, "", false, false, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback, null);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, arguments, deliverCallback, null, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, "", false, false, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) {
        return this.basicConsume(queue, autoAck, consumerTag, false, false, Collections.emptyMap(), callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback, null);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, deliverCallback, null, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, false, false, Collections.emptyMap(), deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) {
        String serverConsumerTag = this.node.basicConsume(this.lastGeneratedIfEmpty(queue), autoAck, consumerTag, noLocal, exclusive, this.nullToEmpty(arguments), callback, this::nextDeliveryTag);
        this.metricsCollectorWrapper.basicConsume(this, serverConsumerTag, autoAck);
        return serverConsumerTag;
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback, null);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, null, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        return this.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, new ConsumerWrapper(deliverCallback, cancelCallback, shutdownSignalCallback));
    }

    public void basicCancel(String consumerTag) {
        this.node.basicCancel(consumerTag);
        this.metricsCollectorWrapper.basicCancel(this, consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() {
        return this.basicRecover(true);
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) {
        return this.node.basicRecover(true);
    }

    public AMQP.Tx.SelectOk txSelect() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Tx.CommitOk txCommit() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Tx.RollbackOk txRollback() {
        throw new UnsupportedOperationException();
    }

    public AMQP.Confirm.SelectOk confirmSelect() {
        throw new UnsupportedOperationException();
    }

    public long getNextPublishSeqNo() {
        throw new UnsupportedOperationException();
    }

    public boolean waitForConfirms() {
        throw new UnsupportedOperationException();
    }

    public boolean waitForConfirms(long timeout) {
        throw new UnsupportedOperationException();
    }

    public void waitForConfirmsOrDie() {
        throw new UnsupportedOperationException();
    }

    public void waitForConfirmsOrDie(long timeout) {
        throw new UnsupportedOperationException();
    }

    public void asyncRpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public Command rpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public long messageCount(String queue) {
        return this.node.messageCount(this.lastGeneratedIfEmpty(queue));
    }

    public long consumerCount(String queue) {
        return this.node.consumerCount(this.lastGeneratedIfEmpty(queue));
    }

    public CompletableFuture<Command> asyncCompletableRpc(Method method) {
        throw new UnsupportedOperationException();
    }

    public void addShutdownListener(ShutdownListener listener) {
    }

    public void removeShutdownListener(ShutdownListener listener) {
        throw new UnsupportedOperationException();
    }

    public ShutdownSignalException getCloseReason() {
        return null;
    }

    public void notifyListeners() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return this.opened.get();
    }

    private AMQP.BasicProperties nullToEmpty(AMQP.BasicProperties props) {
        return props != null ? props : new AMQP.BasicProperties.Builder().build();
    }

    private Map<String, Object> nullToEmpty(Map<String, Object> arguments) {
        return arguments != null ? arguments : Collections.emptyMap();
    }

    private String generateIfEmpty(String queue) {
        String definitiveQueueName;
        if ("".equals(queue)) {
            this.lastGeneratedQueueName = definitiveQueueName = this.queueNameGenerator.generate();
        } else {
            definitiveQueueName = queue;
        }
        return definitiveQueueName;
    }

    private String lastGeneratedIfEmpty(String queue) {
        return "".equals(queue) ? Objects.requireNonNull(this.lastGeneratedQueueName, "No server-named queue previously created") : queue;
    }

    private long nextDeliveryTag() {
        return this.deliveryTagSequence.incrementAndGet();
    }

    public MetricsCollectorWrapper getMetricsCollector() {
        return this.metricsCollectorWrapper;
    }
}

