/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockExchange;
import com.github.fridujo.rabbitmq.mock.Receiver;
import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.rabbitmq.client.AMQP;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BindableMockExchange
implements MockExchange {
    private final Set<BindConfiguration> bindConfigurations = new LinkedHashSet<BindConfiguration>();
    private final String name;
    private final Map<String, Object> arguments;
    private final ReceiverPointer pointer;
    private final ReceiverRegistry receiverRegistry;

    protected BindableMockExchange(String name, Map<String, Object> arguments, ReceiverRegistry receiverRegistry) {
        this.name = name;
        this.arguments = arguments;
        this.pointer = new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, name);
        this.receiverRegistry = receiverRegistry;
    }

    @Override
    public void publish(String previousExchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        Set<Receiver> matchingReceivers = this.bindConfigurations.stream().filter(bindConfiguration -> this.match(bindConfiguration.bindingKey, bindConfiguration.bindArguments, routingKey, props.getHeaders())).map(BindConfiguration::receiverPointer).map(this.receiverRegistry::getReceiver).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toSet());
        if (matchingReceivers.isEmpty()) {
            this.getAlternateExchange().ifPresent(e -> e.publish(this.name, routingKey, props, body));
        } else {
            matchingReceivers.forEach(e -> e.publish(this.name, routingKey, props, body));
        }
    }

    private Optional<Receiver> getAlternateExchange() {
        return Optional.ofNullable(this.arguments.get("alternate-exchange")).filter(aeObject -> aeObject instanceof String).map(String.class::cast).map(aeName -> new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, (String)aeName)).flatMap(this.receiverRegistry::getReceiver);
    }

    protected abstract boolean match(String var1, Map<String, Object> var2, String var3, Map<String, Object> var4);

    @Override
    public void bind(ReceiverPointer receiver, String routingKey, Map<String, Object> arguments) {
        this.bindConfigurations.add(new BindConfiguration(routingKey, receiver, arguments));
    }

    @Override
    public void unbind(ReceiverPointer receiver, String routingKey) {
        this.bindConfigurations.remove(new BindConfiguration(routingKey, receiver, Collections.emptyMap()));
    }

    @Override
    public ReceiverPointer pointer() {
        return this.pointer;
    }

    static class BindConfiguration {
        final String bindingKey;
        final ReceiverPointer receiverPointer;
        final Map<String, Object> bindArguments;

        private BindConfiguration(String bindingKey, ReceiverPointer receiverPointer, Map<String, Object> bindArguments) {
            this.bindingKey = bindingKey;
            this.receiverPointer = receiverPointer;
            this.bindArguments = bindArguments;
        }

        public ReceiverPointer receiverPointer() {
            return this.receiverPointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindConfiguration that = (BindConfiguration)o;
            return Objects.equals(this.bindingKey, that.bindingKey) && Objects.equals(this.receiverPointer, that.receiverPointer);
        }

        public int hashCode() {
            return Objects.hash(this.bindingKey, this.receiverPointer);
        }
    }
}

