/*
 * Decompiled with CFR 0.152.
 */
package com.franriadigos.view;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.franriadigos.view.AttributesHelper;
import com.franriadigos.view.CircularProgressContract;

public class FrameLayoutCircularProgress
extends FrameLayout
implements CircularProgressContract {
    private float mMax = 100.0f;
    private float mProgress = 0.0f;
    private float mCurrentProgress = 0.0f;
    private float mBackgroundRingSize;
    private float mProgressRingSize = this.mBackgroundRingSize = 40.0f;
    private boolean mProgressRingOutline = false;
    private int mBackgroundRingColor = -1434201911;
    private int mProgressRingColor = -16738680;
    private int[] mProgressGradient;
    private boolean mIsJoinGradient;
    private float mGradientFactor;
    private Paint.Cap mProgressRingCorner = Paint.Cap.BUTT;
    private ObjectAnimator mAnimator;
    private Interpolator mDefaultInterpolator = new OvershootInterpolator();
    private Paint mProgressRingPaint;
    private Paint mBackgroundRingPaint;
    private RectF mRingBounds;

    public FrameLayoutCircularProgress(Context context) {
        this(context, null);
    }

    public FrameLayoutCircularProgress(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FrameLayoutCircularProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public FrameLayoutCircularProgress(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setWillNotDraw(false);
        new AttributesHelper(this).loadFromAttributes(attrs, defStyleAttr, 0);
        this.setupAnimator();
        if (this.isProgressRingOutline()) {
            int paddingSize = (int)Math.max(this.mBackgroundRingSize, this.mProgressRingSize);
            this.setPadding(Float.valueOf(paddingSize + this.getPaddingLeft()).intValue(), Float.valueOf(paddingSize + this.getPaddingTop()).intValue(), Float.valueOf(paddingSize + this.getPaddingRight()).intValue(), Float.valueOf(paddingSize + this.getPaddingBottom()).intValue());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() > 0) {
            int minSize = Math.max(this.getMinimumWidth(), this.getMinimumHeight());
            View child = this.getChildAt(0);
            size = Math.max(child.getMeasuredWidth(), child.getMeasuredHeight());
            size = Math.max(minSize, size);
        } else {
            size = Math.max(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setupBounds(w, h);
        this.setupBackgroundRingPaint();
        this.setupProgressRingPaint();
        this.requestLayout();
        this.invalidate();
    }

    private void setupBounds(int w, int h) {
        float paddingSize = Math.max(this.mBackgroundRingSize, this.mProgressRingSize);
        float paddingOffset = paddingSize / 2.0f;
        this.mRingBounds = new RectF(paddingSize - paddingOffset, paddingSize - paddingOffset, (float)w - paddingOffset, (float)h - paddingOffset);
    }

    private void setupProgressRingPaint() {
        this.mProgressRingPaint = new Paint();
        this.mProgressRingPaint.setAntiAlias(true);
        this.mProgressRingPaint.setStrokeCap(this.mProgressRingCorner);
        this.mProgressRingPaint.setStyle(Paint.Style.STROKE);
        this.mProgressRingPaint.setStrokeWidth(this.mProgressRingSize);
        this.mProgressRingPaint.setColor(this.mProgressRingColor);
        if (this.mProgressGradient != null) {
            int[] colors = this.mProgressGradient;
            if (this.isJoinGradient()) {
                colors = new int[this.mProgressGradient.length + 1];
                float[] positions = new float[colors.length];
                int i = 0;
                positions[i] = i;
                int[] nArray = this.mProgressGradient;
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int color;
                    colors[i] = color = nArray[j];
                    if (i == this.mProgressGradient.length - 1) {
                        positions[i] = (360.0f - this.mProgressRingSize * this.getGradientFactor()) / 360.0f;
                    } else if (i > 0) {
                        positions[i] = (float)i / (float)colors.length;
                    }
                    ++i;
                }
                colors[i] = colors[0];
                positions[i] = 1.0f;
            }
            SweepGradient gradient = new SweepGradient(this.mRingBounds.centerX(), this.mRingBounds.centerY(), colors, null);
            this.mProgressRingPaint.setShader((Shader)gradient);
            Matrix matrix = new Matrix();
            this.mProgressRingPaint.getShader().setLocalMatrix(matrix);
            matrix.postTranslate(-this.mRingBounds.centerX(), -this.mRingBounds.centerY());
            matrix.postRotate(-90.0f);
            matrix.postTranslate(this.mRingBounds.centerX(), this.mRingBounds.centerY());
            this.mProgressRingPaint.getShader().setLocalMatrix(matrix);
            this.mProgressRingPaint.setColor(this.mProgressGradient[0]);
        }
    }

    private void setupBackgroundRingPaint() {
        this.mBackgroundRingPaint = new Paint();
        this.mBackgroundRingPaint.setColor(this.mBackgroundRingColor);
        this.mBackgroundRingPaint.setAntiAlias(true);
        this.mBackgroundRingPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundRingPaint.setStrokeWidth(this.mBackgroundRingSize);
    }

    private void setupAnimator() {
        this.mAnimator = ObjectAnimator.ofFloat((Object)this, (String)"progress", (float[])new float[]{this.getProgress(), this.getProgress()});
        this.mAnimator.setDuration(1200L);
        this.mAnimator.setInterpolator((TimeInterpolator)this.mDefaultInterpolator);
        this.mAnimator.setStartDelay(500L);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayoutCircularProgress.this.setCurrentProgress(((Float)animation.getAnimatedValue()).floatValue());
                FrameLayoutCircularProgress.this.setProgress(FrameLayoutCircularProgress.this.getCurrentProgress());
            }
        });
    }

    public void startAnimation() {
        float finalProgress = this.getProgress();
        this.setProgress(this.getCurrentProgress());
        this.mAnimator.setFloatValues(new float[]{this.getCurrentProgress(), finalProgress});
        this.mAnimator.start();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBackgroundRingSize > 0.0f) {
            canvas.drawArc(this.mRingBounds, 360.0f, 360.0f, false, this.mBackgroundRingPaint);
        }
        if (this.mProgressRingSize > 0.0f) {
            canvas.drawArc(this.mRingBounds, -90.0f, this.getSweepAngle(), false, this.mProgressRingPaint);
        }
    }

    private float getSweepAngle() {
        return 360.0f / this.mMax * this.mProgress;
    }

    public ObjectAnimator getAnimator() {
        return this.mAnimator;
    }

    @Override
    public float getMax() {
        return this.mMax;
    }

    @Override
    public void setMax(float max) {
        this.mMax = max;
    }

    @Override
    public float getCurrentProgress() {
        return this.mCurrentProgress;
    }

    @Override
    public void setCurrentProgress(float currentProgress) {
        this.mCurrentProgress = currentProgress;
    }

    @Override
    public float getProgress() {
        return this.mProgress;
    }

    @Override
    public void setProgress(float progress) {
        this.mProgress = progress < 0.0f ? 0.0f : (progress > 100.0f ? 100.0f : progress);
        this.invalidate();
    }

    @Override
    public float getProgressRingSize() {
        return this.mProgressRingSize;
    }

    @Override
    public void setProgressRingSize(float progressRingSize) {
        this.mProgressRingSize = progressRingSize;
    }

    @Override
    public float getBackgroundRingSize() {
        return this.mBackgroundRingSize;
    }

    @Override
    public void setBackgroundRingSize(float backgroundRingSize) {
        this.mBackgroundRingSize = backgroundRingSize;
    }

    @Override
    public boolean isProgressRingOutline() {
        return this.mProgressRingOutline;
    }

    @Override
    public void setProgressRingOutline(boolean progressRingOutline) {
        this.mProgressRingOutline = progressRingOutline;
    }

    @Override
    public int getBackgroundRingColor() {
        return this.mBackgroundRingColor;
    }

    @Override
    public void setBackgroundRingColor(int backgroundRingColor) {
        this.mBackgroundRingColor = backgroundRingColor;
    }

    @Override
    public int getProgressRingColor() {
        return this.mProgressRingColor;
    }

    @Override
    public void setProgressRingColor(int progressRingColor) {
        this.mProgressRingColor = progressRingColor;
    }

    @Override
    public int[] getProgressGradient() {
        return this.mProgressGradient;
    }

    @Override
    public void setProgressGradient(int[] progressGradient) {
        this.mProgressGradient = progressGradient;
    }

    @Override
    public boolean isJoinGradient() {
        return this.mIsJoinGradient;
    }

    @Override
    public void setJoinGradient(boolean isJoinGradient) {
        this.mIsJoinGradient = isJoinGradient;
    }

    @Override
    public float getGradientFactor() {
        return this.mGradientFactor;
    }

    @Override
    public void setGradientFactor(float gradientFactor) {
        this.mGradientFactor = gradientFactor;
    }

    @Override
    public Paint.Cap getProgressRingCorner() {
        return this.mProgressRingCorner;
    }

    @Override
    public void setProgressRingCorner(int progressRingCorner) {
        this.mProgressRingCorner = this.getCap(progressRingCorner);
    }

    @Override
    public Paint.Cap getCap(int id) {
        for (Paint.Cap value : Paint.Cap.values()) {
            if (id != value.ordinal()) continue;
            return value;
        }
        return Paint.Cap.BUTT;
    }
}

