/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import androidx.annotation.IntRange;
import com.github.florent37.viewanimator.AnimationListener;
import com.github.florent37.viewanimator.ViewAnimator;
import java.util.ArrayList;
import java.util.List;

public class AnimationBuilder {
    private final ViewAnimator viewAnimator;
    private final View[] views;
    private final List<Animator> animatorList = new ArrayList<Animator>();
    private boolean waitForHeight;
    private boolean nextValueWillBeDp = false;
    private Interpolator singleInterpolator = null;

    public AnimationBuilder(ViewAnimator viewAnimator, View ... views) {
        this.viewAnimator = viewAnimator;
        this.views = views;
    }

    public AnimationBuilder dp() {
        this.nextValueWillBeDp = true;
        return this;
    }

    protected AnimationBuilder add(Animator animator) {
        this.animatorList.add(animator);
        return this;
    }

    protected float toDp(float px) {
        return px / this.views[0].getContext().getResources().getDisplayMetrics().density;
    }

    protected float toPx(float dp) {
        return dp * this.views[0].getContext().getResources().getDisplayMetrics().density;
    }

    protected float[] getValues(float ... values) {
        if (!this.nextValueWillBeDp) {
            return values;
        }
        float[] pxValues = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            pxValues[i] = this.toPx(values[i]);
        }
        return pxValues;
    }

    public AnimationBuilder property(String propertyName, float ... values) {
        for (View view : this.views) {
            this.animatorList.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])this.getValues(values)));
        }
        return this;
    }

    public AnimationBuilder translationY(float ... y) {
        return this.property("translationY", y);
    }

    public AnimationBuilder translationX(float ... x) {
        return this.property("translationX", x);
    }

    public AnimationBuilder alpha(float ... alpha) {
        return this.property("alpha", alpha);
    }

    public AnimationBuilder scaleX(float ... scaleX) {
        return this.property("scaleX", scaleX);
    }

    public AnimationBuilder scaleY(float ... scaleY) {
        return this.property("scaleY", scaleY);
    }

    public AnimationBuilder scale(float ... scale) {
        this.scaleX(scale);
        this.scaleY(scale);
        return this;
    }

    public AnimationBuilder pivotX(float pivotX) {
        for (View view : this.views) {
            view.setPivotX(pivotX);
        }
        return this;
    }

    public AnimationBuilder pivotY(float pivotY) {
        for (View view : this.views) {
            view.setPivotY(pivotY);
        }
        return this;
    }

    public AnimationBuilder pivotX(float ... pivotX) {
        ObjectAnimator.ofFloat((Object)this.getView(), (String)"pivotX", (float[])this.getValues(pivotX));
        return this;
    }

    public AnimationBuilder pivotY(float ... pivotY) {
        ObjectAnimator.ofFloat((Object)this.getView(), (String)"pivotY", (float[])this.getValues(pivotY));
        return this;
    }

    public AnimationBuilder rotationX(float ... rotationX) {
        return this.property("rotationX", rotationX);
    }

    public AnimationBuilder rotationY(float ... rotationY) {
        return this.property("rotationY", rotationY);
    }

    public AnimationBuilder rotation(float ... rotation) {
        return this.property("rotation", rotation);
    }

    public AnimationBuilder backgroundColor(int ... colors) {
        for (View view : this.views) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)view, (String)"backgroundColor", (int[])colors);
            objectAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            this.animatorList.add((Animator)objectAnimator);
        }
        return this;
    }

    public AnimationBuilder textColor(int ... colors) {
        for (View view : this.views) {
            if (!(view instanceof TextView)) continue;
            TextView textView = (TextView)view;
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)textView, (String)"textColor", (int[])colors);
            objectAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            this.animatorList.add((Animator)objectAnimator);
        }
        return this;
    }

    public AnimationBuilder custom(final AnimationListener.Update update, float ... values) {
        for (final View view : this.views) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])this.getValues(values));
            if (update != null) {
                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        update.update(view, ((Float)animation.getAnimatedValue()).floatValue());
                    }
                });
            }
            this.add((Animator)valueAnimator);
        }
        return this;
    }

    public AnimationBuilder height(float ... height) {
        return this.custom(new AnimationListener.Update(){

            public void update(View view, float value) {
                view.getLayoutParams().height = (int)value;
                view.requestLayout();
            }
        }, height);
    }

    public AnimationBuilder width(float ... width) {
        return this.custom(new AnimationListener.Update(){

            public void update(View view, float value) {
                view.getLayoutParams().width = (int)value;
                view.requestLayout();
            }
        }, width);
    }

    public AnimationBuilder waitForHeight() {
        this.waitForHeight = true;
        return this;
    }

    protected List<Animator> createAnimators() {
        return this.animatorList;
    }

    public AnimationBuilder andAnimate(View ... views) {
        return this.viewAnimator.addAnimationBuilder(views);
    }

    public AnimationBuilder thenAnimate(View ... views) {
        return this.viewAnimator.thenAnimate(views);
    }

    public AnimationBuilder duration(@IntRange(from=1L) long duration) {
        this.viewAnimator.duration(duration);
        return this;
    }

    public AnimationBuilder startDelay(@IntRange(from=0L) long startDelay) {
        this.viewAnimator.startDelay(startDelay);
        return this;
    }

    public AnimationBuilder repeatCount(@IntRange(from=-1L) int repeatCount) {
        this.viewAnimator.repeatCount(repeatCount);
        return this;
    }

    public AnimationBuilder repeatMode(int repeatMode) {
        this.viewAnimator.repeatMode(repeatMode);
        return this;
    }

    public AnimationBuilder onStart(AnimationListener.Start startListener) {
        this.viewAnimator.onStart(startListener);
        return this;
    }

    public AnimationBuilder onStop(AnimationListener.Stop stopListener) {
        this.viewAnimator.onStop(stopListener);
        return this;
    }

    public AnimationBuilder interpolator(Interpolator interpolator) {
        this.viewAnimator.interpolator(interpolator);
        return this;
    }

    public AnimationBuilder singleInterpolator(Interpolator interpolator) {
        this.singleInterpolator = interpolator;
        return this;
    }

    public Interpolator getSingleInterpolator() {
        return this.singleInterpolator;
    }

    public ViewAnimator accelerate() {
        return this.viewAnimator.interpolator((Interpolator)new AccelerateInterpolator());
    }

    public ViewAnimator decelerate() {
        return this.viewAnimator.interpolator((Interpolator)new DecelerateInterpolator());
    }

    public ViewAnimator start() {
        this.viewAnimator.start();
        return this.viewAnimator;
    }

    public View[] getViews() {
        return this.views;
    }

    public View getView() {
        return this.views[0];
    }

    public boolean isWaitForHeight() {
        return this.waitForHeight;
    }

    public AnimationBuilder bounce() {
        return this.translationY(0.0f, 0.0f, -30.0f, 0.0f, -15.0f, 0.0f, 0.0f);
    }

    public AnimationBuilder bounceIn() {
        this.alpha(0.0f, 1.0f, 1.0f, 1.0f);
        this.scaleX(0.3f, 1.05f, 0.9f, 1.0f);
        this.scaleY(0.3f, 1.05f, 0.9f, 1.0f);
        return this;
    }

    public AnimationBuilder bounceOut() {
        this.scaleY(1.0f, 0.9f, 1.05f, 0.3f);
        this.scaleX(1.0f, 0.9f, 1.05f, 0.3f);
        this.alpha(1.0f, 1.0f, 1.0f, 0.0f);
        return this;
    }

    public AnimationBuilder fadeIn() {
        return this.alpha(0.0f, 0.25f, 0.5f, 0.75f, 1.0f);
    }

    public AnimationBuilder fadeOut() {
        return this.alpha(1.0f, 0.75f, 0.5f, 0.25f, 0.0f);
    }

    public AnimationBuilder flash() {
        return this.alpha(1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public AnimationBuilder flipHorizontal() {
        return this.rotationX(90.0f, -15.0f, 15.0f, 0.0f);
    }

    public AnimationBuilder flipVertical() {
        return this.rotationY(90.0f, -15.0f, 15.0f, 0.0f);
    }

    public AnimationBuilder pulse() {
        this.scaleY(1.0f, 1.1f, 1.0f);
        this.scaleX(1.0f, 1.1f, 1.0f);
        return this;
    }

    public AnimationBuilder rollIn() {
        for (View view : this.views) {
            this.alpha(0.0f, 1.0f);
            this.translationX(-(view.getWidth() - view.getPaddingLeft() - view.getPaddingRight()), 0.0f);
            this.rotation(-120.0f, 0.0f);
        }
        return this;
    }

    public AnimationBuilder rollOut() {
        for (View view : this.views) {
            this.alpha(1.0f, 0.0f);
            this.translationX(0.0f, view.getWidth());
            this.rotation(0.0f, 120.0f);
        }
        return this;
    }

    public AnimationBuilder rubber() {
        this.scaleX(1.0f, 1.25f, 0.75f, 1.15f, 1.0f);
        this.scaleY(1.0f, 0.75f, 1.25f, 0.85f, 1.0f);
        return this;
    }

    public AnimationBuilder shake() {
        this.translationX(0.0f, 25.0f, -25.0f, 25.0f, -25.0f, 15.0f, -15.0f, 6.0f, -6.0f, 0.0f);
        this.interpolator((Interpolator)new CycleInterpolator(5.0f));
        return this;
    }

    public AnimationBuilder standUp() {
        for (View view : this.views) {
            float x = (view.getWidth() - view.getPaddingLeft() - view.getPaddingRight()) / 2 + view.getPaddingLeft();
            float y = view.getHeight() - view.getPaddingBottom();
            this.pivotX(x, x, x, x, x);
            this.pivotY(y, y, y, y, y);
            this.rotationX(55.0f, -30.0f, 15.0f, -15.0f, 0.0f);
        }
        return this;
    }

    public AnimationBuilder swing() {
        return this.rotation(0.0f, 10.0f, -10.0f, 6.0f, -6.0f, 3.0f, -3.0f, 0.0f);
    }

    public AnimationBuilder tada() {
        this.scaleX(1.0f, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.0f);
        this.scaleY(1.0f, 0.9f, 0.9f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.1f, 1.0f);
        this.rotation(0.0f, -3.0f, -3.0f, 3.0f, -3.0f, 3.0f, -3.0f, 3.0f, -3.0f, 0.0f);
        return this;
    }

    public AnimationBuilder wave() {
        for (View view : this.views) {
            float x = (view.getWidth() - view.getPaddingLeft() - view.getPaddingRight()) / 2 + view.getPaddingLeft();
            float y = view.getHeight() - view.getPaddingBottom();
            this.rotation(12.0f, -12.0f, 3.0f, -3.0f, 0.0f);
            this.pivotX(x, x, x, x, x);
            this.pivotY(y, y, y, y, y);
        }
        return this;
    }

    public AnimationBuilder wobble() {
        for (View view : this.views) {
            float width = view.getWidth();
            float one = (float)((double)width / 100.0);
            this.translationX(0.0f * one, -25.0f * one, 20.0f * one, -15.0f * one, 10.0f * one, -5.0f * one, 0.0f * one, 0.0f);
            this.rotation(0.0f, -5.0f, 3.0f, -3.0f, 2.0f, -1.0f, 0.0f);
        }
        return this;
    }

    public AnimationBuilder zoomIn() {
        this.scaleX(0.45f, 1.0f);
        this.scaleY(0.45f, 1.0f);
        this.alpha(0.0f, 1.0f);
        return this;
    }

    public AnimationBuilder zoomOut() {
        this.scaleX(1.0f, 0.3f, 0.0f);
        this.scaleY(1.0f, 0.3f, 0.0f);
        this.alpha(1.0f, 0.0f, 0.0f);
        return this;
    }

    public AnimationBuilder fall() {
        this.rotation(1080.0f, 720.0f, 360.0f, 0.0f);
        return this;
    }

    public AnimationBuilder newsPaper() {
        this.alpha(0.0f, 1.0f);
        this.scaleX(0.1f, 0.5f, 1.0f);
        this.scaleY(0.1f, 0.5f, 1.0f);
        return this;
    }

    public AnimationBuilder slit() {
        this.rotationY(90.0f, 88.0f, 88.0f, 45.0f, 0.0f);
        this.alpha(0.0f, 0.4f, 0.8f, 1.0f);
        this.scaleX(0.0f, 0.5f, 0.9f, 0.9f, 1.0f);
        this.scaleY(0.0f, 0.5f, 0.9f, 0.9f, 1.0f);
        return this;
    }

    public AnimationBuilder slideLeftIn() {
        this.translationX(-300.0f, 0.0f);
        this.alpha(0.0f, 1.0f);
        return this;
    }

    public AnimationBuilder slideRightIn() {
        this.translationX(300.0f, 0.0f);
        this.alpha(0.0f, 1.0f);
        return this;
    }

    public AnimationBuilder slideTopIn() {
        this.translationY(-300.0f, 0.0f);
        this.alpha(0.0f, 1.0f);
        return this;
    }

    public AnimationBuilder slideBottomIn() {
        this.translationY(300.0f, 0.0f);
        this.alpha(0.0f, 1.0f);
        return this;
    }

    public AnimationBuilder path(Path path) {
        if (path == null) {
            return this;
        }
        final PathMeasure pathMeasure = new PathMeasure(path, false);
        return this.custom(new AnimationListener.Update(){

            public void update(View view, float value) {
                if (view == null) {
                    return;
                }
                float[] currentPosition = new float[2];
                pathMeasure.getPosTan(value, currentPosition, null);
                float x = currentPosition[0];
                float y = currentPosition[1];
                view.setX(x);
                view.setY(y);
                Log.d(null, (String)("path: value=" + value + ", x=" + x + ", y=" + y));
            }
        }, 0.0f, pathMeasure.getLength());
    }
}

