/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import com.github.florent37.viewanimator.AnimationListener;
import com.github.florent37.viewanimator.ViewAnimator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.TypeEvaluator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import java.util.ArrayList;
import java.util.List;

public class AnimationBuilder {
    private final ViewAnimator viewAnimator;
    private final View[] views;
    private final List<Animator> animatorList = new ArrayList<Animator>();
    protected boolean waitForHeight;
    protected boolean nextValueWillBeDp = false;

    public AnimationBuilder(ViewAnimator viewAnimator, View ... views) {
        this.viewAnimator = viewAnimator;
        this.views = views;
    }

    public AnimationBuilder dp() {
        this.nextValueWillBeDp = true;
        return this;
    }

    protected AnimationBuilder add(Animator animator) {
        this.animatorList.add(animator);
        return this;
    }

    protected float toDp(float px) {
        return px / this.views[0].getContext().getResources().getDisplayMetrics().density;
    }

    protected float toPx(float dp) {
        return dp * this.views[0].getContext().getResources().getDisplayMetrics().density;
    }

    protected float[] getValues(float ... values) {
        if (!this.nextValueWillBeDp) {
            return values;
        }
        float[] pxValues = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            pxValues[i] = this.toPx(values[i]);
        }
        return pxValues;
    }

    public AnimationBuilder property(String propertyName, float ... values) {
        for (View view : this.views) {
            this.animatorList.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)propertyName, (float[])this.getValues(values)));
        }
        return this;
    }

    public AnimationBuilder translationY(float ... y) {
        return this.property("translationY", y);
    }

    public AnimationBuilder translationX(float ... x) {
        return this.property("translationX", x);
    }

    public AnimationBuilder alpha(float ... alpha) {
        return this.property("alpha", alpha);
    }

    public AnimationBuilder scaleX(float ... scaleX) {
        return this.property("scaleX", scaleX);
    }

    public AnimationBuilder scaleY(float ... scaleY) {
        return this.property("scaleY", scaleY);
    }

    public AnimationBuilder scale(float ... scale) {
        this.scaleX(scale);
        this.scaleY(scale);
        return this;
    }

    public AnimationBuilder pivotX(float pivotX) {
        for (View view : this.views) {
            ViewHelper.setPivotX((View)view, (float)pivotX);
        }
        return this;
    }

    public AnimationBuilder pivotY(float pivotY) {
        for (View view : this.views) {
            ViewHelper.setPivotY((View)view, (float)pivotY);
        }
        return this;
    }

    public AnimationBuilder rotationX(float ... rotationX) {
        return this.property("rotationX", rotationX);
    }

    public AnimationBuilder rotationY(float ... rotationY) {
        return this.property("rotationY", rotationY);
    }

    public AnimationBuilder rotation(float ... rotation) {
        return this.property("rotation", rotation);
    }

    public AnimationBuilder backgroundColor(int ... colors) {
        for (View view : this.views) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)view, (String)"backgroundColor", (int[])colors);
            objectAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            this.animatorList.add((Animator)objectAnimator);
        }
        return this;
    }

    public AnimationBuilder textColor(int ... colors) {
        for (View view : this.views) {
            if (!(view instanceof TextView)) continue;
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)view, (String)"textColor", (int[])colors);
            objectAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            this.animatorList.add((Animator)objectAnimator);
        }
        return this;
    }

    public AnimationBuilder custom(final AnimationListener.Update update, float ... values) {
        for (final View view : this.views) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])this.getValues(values));
            if (update != null) {
                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        update.update(view, ((Float)animation.getAnimatedValue()).floatValue());
                    }
                });
            }
            this.add((Animator)valueAnimator);
        }
        return this;
    }

    public AnimationBuilder height(float ... height) {
        return this.custom(new AnimationListener.Update(){

            public void update(View view, float value) {
                view.getLayoutParams().height = (int)value;
                view.requestLayout();
            }
        }, height);
    }

    public AnimationBuilder width(float ... width) {
        return this.custom(new AnimationListener.Update(){

            public void update(View view, float value) {
                view.getLayoutParams().width = (int)value;
                view.requestLayout();
            }
        }, width);
    }

    public AnimationBuilder waitForHeight() {
        this.waitForHeight = true;
        return this;
    }

    protected List<Animator> createAnimators() {
        return this.animatorList;
    }

    public AnimationBuilder andAnimate(View ... views) {
        return this.viewAnimator.addAnimationBuilder(views);
    }

    public AnimationBuilder thenAnimate(View ... views) {
        return this.viewAnimator.thenAnimate(views);
    }

    public ViewAnimator start() {
        return this.viewAnimator.start();
    }

    public ViewAnimator duration(long duration) {
        return this.viewAnimator.duration(duration);
    }

    public ViewAnimator startDelay(long startDelay) {
        return this.viewAnimator.startDelay(startDelay);
    }

    public ViewAnimator onStart(AnimationListener.Start start) {
        return this.viewAnimator.onStart(start);
    }

    public ViewAnimator onStop(AnimationListener.Stop stop) {
        return this.viewAnimator.onStop(stop);
    }

    public ViewAnimator onEnd(AnimationListener.Stop stop) {
        return this.onStop(stop);
    }

    public ViewAnimator interpolator(Interpolator interpolator) {
        return this.viewAnimator.interpolator(interpolator);
    }

    public ViewAnimator accelerate() {
        return this.viewAnimator.interpolator((Interpolator)new AccelerateInterpolator());
    }

    public ViewAnimator descelerate() {
        return this.viewAnimator.interpolator((Interpolator)new DecelerateInterpolator());
    }

    public View[] getViews() {
        return this.views;
    }

    public View getView() {
        return this.views[0];
    }

    public boolean isWaitForHeight() {
        return this.waitForHeight;
    }
}

