/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.DateWithLabel;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WheelDayPicker
extends WheelPicker<DateWithLabel> {
    private static final String DAY_FORMAT_PATTERN = "EEE d MMM";
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat customDateFormat;
    private OnDaySelectedListener onDaySelectedListener;

    public WheelDayPicker(Context context) {
        super(context);
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.simpleDateFormat = new SimpleDateFormat(DAY_FORMAT_PATTERN, this.getCurrentLocale());
        this.simpleDateFormat.setTimeZone(DateHelper.getTimeZone());
    }

    @Override
    public void setCustomLocale(Locale customLocale) {
        super.setCustomLocale(customLocale);
        this.simpleDateFormat = new SimpleDateFormat(DAY_FORMAT_PATTERN, this.getCurrentLocale());
        this.simpleDateFormat.setTimeZone(DateHelper.getTimeZone());
    }

    @Override
    protected DateWithLabel initDefault() {
        return new DateWithLabel(this.getTodayText(), new Date());
    }

    @NonNull
    private String getTodayText() {
        return this.getLocalizedString(R.string.picker_today);
    }

    @Override
    protected void onItemSelected(int position, DateWithLabel item) {
        if (this.onDaySelectedListener != null) {
            this.onDaySelectedListener.onDaySelected(this, position, (String)item.first, (Date)item.second);
        }
    }

    @Override
    protected List<DateWithLabel> generateAdapterValues() {
        Date date;
        int i;
        ArrayList<DateWithLabel> days = new ArrayList<DateWithLabel>();
        Calendar instance = Calendar.getInstance();
        instance.setTimeZone(DateHelper.getTimeZone());
        instance.add(5, -365);
        for (i = -364; i < 0; ++i) {
            instance.add(5, 1);
            date = instance.getTime();
            days.add(new DateWithLabel(this.getFormattedValue(date), date));
        }
        days.add(new DateWithLabel(this.getTodayText(), new Date()));
        instance = Calendar.getInstance();
        instance.setTimeZone(DateHelper.getTimeZone());
        for (i = 0; i < 364; ++i) {
            instance.add(5, 1);
            date = instance.getTime();
            days.add(new DateWithLabel(this.getFormattedValue(date), date));
        }
        return days;
    }

    @Override
    protected String getFormattedValue(Object value) {
        return this.getDateFormat().format(value);
    }

    public WheelDayPicker setDayFormatter(SimpleDateFormat simpleDateFormat) {
        simpleDateFormat.setTimeZone(DateHelper.getTimeZone());
        this.customDateFormat = simpleDateFormat;
        this.updateAdapter();
        return this;
    }

    public void setOnDaySelectedListener(OnDaySelectedListener onDaySelectedListener) {
        this.onDaySelectedListener = onDaySelectedListener;
    }

    public Date getCurrentDate() {
        return this.convertItemToDate(super.getCurrentItemPosition());
    }

    private SimpleDateFormat getDateFormat() {
        if (this.customDateFormat != null) {
            return this.customDateFormat;
        }
        return this.simpleDateFormat;
    }

    private Date convertItemToDate(int itemPosition) {
        Date date = null;
        String itemText = this.adapter.getItemText(itemPosition);
        Calendar todayCalendar = Calendar.getInstance();
        todayCalendar.setTimeZone(DateHelper.getTimeZone());
        int todayPosition = this.adapter.getData().indexOf(this.getTodayText());
        if (this.getTodayText().equals(itemText)) {
            date = todayCalendar.getTime();
        } else {
            todayCalendar.add(6, itemPosition - todayPosition);
            date = todayCalendar.getTime();
        }
        return date;
    }

    public void setTodayText(DateWithLabel today) {
        int index = this.adapter.getData().indexOf(this.getTodayText());
        if (index != -1) {
            this.adapter.getData().set(index, today);
            this.notifyDatasetChanged();
        }
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(WheelDayPicker var1, int var2, String var3, Date var4);
    }
}

