/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.dialog;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.SingleDateAndTimePicker;
import com.github.florent37.singledateandtimepicker.dialog.BaseDialog;
import com.github.florent37.singledateandtimepicker.dialog.BottomSheetHelper;
import com.github.florent37.singledateandtimepicker.widget.DateWithLabel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SingleDateAndTimePickerDialog
extends BaseDialog {
    private Listener listener;
    private BottomSheetHelper bottomSheetHelper;
    private SingleDateAndTimePicker picker;
    @Nullable
    private String title;
    @Nullable
    private Integer titleTextSize;
    @Nullable
    private Integer bottomSheetHeight;
    @Nullable
    private String todayText;
    @Nullable
    private DisplayListener displayListener;

    private SingleDateAndTimePickerDialog(Context context) {
        this(context, false);
    }

    private SingleDateAndTimePickerDialog(Context context, boolean bottomSheet) {
        int layout2 = bottomSheet ? R.layout.bottom_sheet_picker_bottom_sheet : R.layout.bottom_sheet_picker;
        this.bottomSheetHelper = new BottomSheetHelper(context, layout2);
        this.bottomSheetHelper.setListener(new BottomSheetHelper.Listener(){

            @Override
            public void onOpen() {
            }

            @Override
            public void onLoaded(View view) {
                SingleDateAndTimePickerDialog.this.init(view);
                if (SingleDateAndTimePickerDialog.this.displayListener != null) {
                    SingleDateAndTimePickerDialog.this.displayListener.onDisplayed(SingleDateAndTimePickerDialog.this.picker);
                }
            }

            @Override
            public void onClose() {
                SingleDateAndTimePickerDialog.this.onClose();
            }
        });
    }

    private void init(View view) {
        TextView titleTextView;
        View sheetContentLayout;
        TextView buttonOk;
        this.picker = (SingleDateAndTimePicker)view.findViewById(R.id.picker);
        if (this.picker != null && this.bottomSheetHeight != null) {
            ViewGroup.LayoutParams params = this.picker.getLayoutParams();
            params.height = this.bottomSheetHeight;
            this.picker.setLayoutParams(params);
        }
        if ((buttonOk = (TextView)view.findViewById(R.id.buttonOk)) != null) {
            buttonOk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SingleDateAndTimePickerDialog.this.okClicked = true;
                    SingleDateAndTimePickerDialog.this.close();
                }
            });
            if (this.mainColor != null) {
                buttonOk.setTextColor(this.mainColor.intValue());
            }
            if (this.titleTextSize != null) {
                buttonOk.setTextSize((float)this.titleTextSize.intValue());
            }
        }
        if ((sheetContentLayout = view.findViewById(R.id.sheetContentLayout)) != null) {
            sheetContentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
            if (this.backgroundColor != null) {
                sheetContentLayout.setBackgroundColor(this.backgroundColor.intValue());
            }
        }
        if ((titleTextView = (TextView)view.findViewById(R.id.sheetTitle)) != null) {
            titleTextView.setText((CharSequence)this.title);
            if (this.titleTextColor != null) {
                titleTextView.setTextColor(this.titleTextColor.intValue());
            }
            if (this.titleTextSize != null) {
                titleTextView.setTextSize((float)this.titleTextSize.intValue());
            }
        }
        this.picker.setTodayText(new DateWithLabel(this.todayText, new Date()));
        View pickerTitleHeader = view.findViewById(R.id.pickerTitleHeader);
        if (this.mainColor != null && pickerTitleHeader != null) {
            pickerTitleHeader.setBackgroundColor(this.mainColor.intValue());
        }
        if (this.curved) {
            this.picker.setCurved(true);
            this.picker.setVisibleItemCount(7);
        } else {
            this.picker.setCurved(false);
            this.picker.setVisibleItemCount(5);
        }
        this.picker.setMustBeOnFuture(this.mustBeOnFuture);
        this.picker.setStepMinutes(this.minutesStep);
        if (this.dayFormatter != null) {
            this.picker.setDayFormatter(this.dayFormatter);
        }
        if (this.customLocale != null) {
            this.picker.setCustomLocale(this.customLocale);
        }
        if (this.mainColor != null) {
            this.picker.setSelectedTextColor(this.mainColor);
        }
        if (this.minDate != null) {
            this.picker.setMinDate(this.minDate);
        }
        if (this.maxDate != null) {
            this.picker.setMaxDate(this.maxDate);
        }
        if (this.defaultDate != null) {
            this.picker.setDefaultDate(this.defaultDate);
        }
        if (this.isAmPm != null) {
            this.picker.setIsAmPm(this.isAmPm);
        }
        this.picker.setDisplayDays(this.displayDays);
        this.picker.setDisplayYears(this.displayYears);
        this.picker.setDisplayMonths(this.displayMonth);
        this.picker.setDisplayDaysOfMonth(this.displayDaysOfMonth);
        this.picker.setDisplayMinutes(this.displayMinutes);
        this.picker.setDisplayHours(this.displayHours);
        this.picker.setDisplayMonthNumbers(this.displayMonthNumbers);
    }

    public SingleDateAndTimePickerDialog setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public SingleDateAndTimePickerDialog setCurved(boolean curved) {
        this.curved = curved;
        return this;
    }

    public SingleDateAndTimePickerDialog setMinutesStep(int minutesStep) {
        this.minutesStep = minutesStep;
        return this;
    }

    private void setDisplayListener(DisplayListener displayListener) {
        this.displayListener = displayListener;
    }

    public SingleDateAndTimePickerDialog setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public SingleDateAndTimePickerDialog setTitleTextSize(@Nullable Integer titleTextSize) {
        this.titleTextSize = titleTextSize;
        return this;
    }

    public SingleDateAndTimePickerDialog setBottomSheetHeight(@Nullable Integer bottomSheetHeight) {
        this.bottomSheetHeight = bottomSheetHeight;
        return this;
    }

    public SingleDateAndTimePickerDialog setTodayText(@Nullable String todayText) {
        this.todayText = todayText;
        return this;
    }

    public SingleDateAndTimePickerDialog setMustBeOnFuture(boolean mustBeOnFuture) {
        this.mustBeOnFuture = mustBeOnFuture;
        return this;
    }

    public SingleDateAndTimePickerDialog setMinDateRange(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    public SingleDateAndTimePickerDialog setMaxDateRange(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    public SingleDateAndTimePickerDialog setDefaultDate(Date defaultDate) {
        this.defaultDate = defaultDate;
        return this;
    }

    public SingleDateAndTimePickerDialog setDisplayDays(boolean displayDays) {
        this.displayDays = displayDays;
        return this;
    }

    public SingleDateAndTimePickerDialog setDisplayMinutes(boolean displayMinutes) {
        this.displayMinutes = displayMinutes;
        return this;
    }

    public SingleDateAndTimePickerDialog setDisplayMonthNumbers(boolean displayMonthNumbers) {
        this.displayMonthNumbers = displayMonthNumbers;
        return this;
    }

    public SingleDateAndTimePickerDialog setDisplayHours(boolean displayHours) {
        this.displayHours = displayHours;
        return this;
    }

    public SingleDateAndTimePickerDialog setDisplayDaysOfMonth(boolean displayDaysOfMonth) {
        this.displayDaysOfMonth = displayDaysOfMonth;
        return this;
    }

    private SingleDateAndTimePickerDialog setDisplayMonth(boolean displayMonth) {
        this.displayMonth = displayMonth;
        return this;
    }

    private SingleDateAndTimePickerDialog setDisplayYears(boolean displayYears) {
        this.displayYears = displayYears;
        return this;
    }

    public SingleDateAndTimePickerDialog setDayFormatter(SimpleDateFormat dayFormatter) {
        this.dayFormatter = dayFormatter;
        return this;
    }

    public SingleDateAndTimePickerDialog setCustomLocale(Locale locale) {
        this.customLocale = locale;
        return this;
    }

    public SingleDateAndTimePickerDialog setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        return this;
    }

    @Override
    public void display() {
        super.display();
        this.bottomSheetHelper.display();
    }

    @Override
    public void close() {
        super.close();
        this.bottomSheetHelper.hide();
        if (this.listener != null && this.okClicked) {
            this.listener.onDateSelected(this.picker.getDate());
        }
    }

    @Override
    public void dismiss() {
        super.dismiss();
        this.bottomSheetHelper.dismiss();
    }

    public static class Builder {
        private final Context context;
        private SingleDateAndTimePickerDialog dialog;
        @Nullable
        private Listener listener;
        @Nullable
        private DisplayListener displayListener;
        @Nullable
        private String title;
        @Nullable
        private Integer titleTextSize;
        @Nullable
        private Integer bottomSheetHeight;
        @Nullable
        private String todayText;
        private boolean bottomSheet;
        private boolean curved;
        private boolean mustBeOnFuture;
        private int minutesStep = 5;
        private boolean displayDays = true;
        private boolean displayMinutes = true;
        private boolean displayHours = true;
        private boolean displayMonth = false;
        private boolean displayDaysOfMonth = false;
        private boolean displayYears = false;
        private boolean displayMonthNumbers = false;
        @Nullable
        private Boolean isAmPm;
        @ColorInt
        @Nullable
        private Integer backgroundColor = null;
        @ColorInt
        @Nullable
        private Integer mainColor = null;
        @ColorInt
        @Nullable
        private Integer titleTextColor = null;
        @Nullable
        private Date minDate;
        @Nullable
        private Date maxDate;
        @Nullable
        private Date defaultDate;
        @Nullable
        private SimpleDateFormat dayFormatter;
        @Nullable
        private Locale customLocale;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder titleTextSize(@Nullable Integer titleTextSize) {
            this.titleTextSize = titleTextSize;
            return this;
        }

        public Builder bottomSheetHeight(@Nullable Integer bottomSheetHeight) {
            this.bottomSheetHeight = bottomSheetHeight;
            return this;
        }

        public Builder todayText(@Nullable String todayText) {
            this.todayText = todayText;
            return this;
        }

        public Builder bottomSheet() {
            this.bottomSheet = true;
            return this;
        }

        public Builder curved() {
            this.curved = true;
            return this;
        }

        public Builder mustBeOnFuture() {
            this.mustBeOnFuture = true;
            return this;
        }

        public Builder minutesStep(int minutesStep) {
            this.minutesStep = minutesStep;
            return this;
        }

        public Builder displayDays(boolean displayDays) {
            this.displayDays = displayDays;
            return this;
        }

        public Builder displayAmPm(boolean isAmPm) {
            this.isAmPm = isAmPm;
            return this;
        }

        public Builder displayMinutes(boolean displayMinutes) {
            this.displayMinutes = displayMinutes;
            return this;
        }

        public Builder displayHours(boolean displayHours) {
            this.displayHours = displayHours;
            return this;
        }

        public Builder displayDaysOfMonth(boolean displayDaysOfMonth) {
            this.displayDaysOfMonth = displayDaysOfMonth;
            return this;
        }

        public Builder displayMonth(boolean displayMonth) {
            this.displayMonth = displayMonth;
            return this;
        }

        public Builder displayYears(boolean displayYears) {
            this.displayYears = displayYears;
            return this;
        }

        public Builder listener(@Nullable Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder displayListener(@Nullable DisplayListener displayListener) {
            this.displayListener = displayListener;
            return this;
        }

        public Builder titleTextColor(@NonNull @ColorInt int titleTextColor) {
            this.titleTextColor = titleTextColor;
            return this;
        }

        public Builder backgroundColor(@NonNull @ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder mainColor(@NonNull @ColorInt int mainColor) {
            this.mainColor = mainColor;
            return this;
        }

        public Builder minDateRange(Date minDate) {
            this.minDate = minDate;
            return this;
        }

        public Builder maxDateRange(Date maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public Builder displayMonthNumbers(boolean displayMonthNumbers) {
            this.displayMonthNumbers = displayMonthNumbers;
            return this;
        }

        public Builder defaultDate(Date defaultDate) {
            this.defaultDate = defaultDate;
            return this;
        }

        public Builder setDayFormatter(SimpleDateFormat dayFormatter) {
            this.dayFormatter = dayFormatter;
            return this;
        }

        public Builder customLocale(Locale locale) {
            this.customLocale = locale;
            return this;
        }

        public Builder setTimeZone(TimeZone timeZone) {
            DateHelper.setTimeZone(timeZone);
            return this;
        }

        public SingleDateAndTimePickerDialog build() {
            SingleDateAndTimePickerDialog dialog = new SingleDateAndTimePickerDialog(this.context, this.bottomSheet).setTitle(this.title).setTitleTextSize(this.titleTextSize).setBottomSheetHeight(this.bottomSheetHeight).setTodayText(this.todayText).setListener(this.listener).setCurved(this.curved).setMinutesStep(this.minutesStep).setMaxDateRange(this.maxDate).setMinDateRange(this.minDate).setDefaultDate(this.defaultDate).setDisplayHours(this.displayHours).setDisplayMonth(this.displayMonth).setDisplayYears(this.displayYears).setDisplayDaysOfMonth(this.displayDaysOfMonth).setDisplayMinutes(this.displayMinutes).setDisplayMonthNumbers(this.displayMonthNumbers).setDisplayDays(this.displayDays).setDayFormatter(this.dayFormatter).setCustomLocale(this.customLocale).setMustBeOnFuture(this.mustBeOnFuture);
            if (this.mainColor != null) {
                dialog.setMainColor(this.mainColor);
            }
            if (this.backgroundColor != null) {
                dialog.setBackgroundColor(this.backgroundColor);
            }
            if (this.titleTextColor != null) {
                dialog.setTitleTextColor(this.titleTextColor);
            }
            if (this.displayListener != null) {
                dialog.setDisplayListener(this.displayListener);
            }
            if (this.isAmPm != null) {
                dialog.setIsAmPm(this.isAmPm);
            }
            return dialog;
        }

        public void display() {
            this.dialog = this.build();
            this.dialog.display();
        }

        public void close() {
            if (this.dialog != null) {
                this.dialog.close();
            }
        }

        public void dismiss() {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
        }
    }

    public static interface DisplayListener {
        public void onDisplayed(SingleDateAndTimePicker var1);
    }

    public static interface Listener {
        public void onDateSelected(Date var1);
    }
}

