/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.List;

public class WheelDayOfMonthPicker
extends WheelPicker<String> {
    private int daysInMonth;
    private DayOfMonthSelectedListener listener;
    private FinishedLoopListener finishedLoopListener;

    public WheelDayOfMonthPicker(Context context) {
        this(context, null);
    }

    public WheelDayOfMonthPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
    }

    @Override
    protected List<String> generateAdapterValues() {
        ArrayList<String> dayList = new ArrayList<String>();
        for (int i = 1; i <= this.daysInMonth; ++i) {
            dayList.add(String.format("%02d", i));
        }
        return dayList;
    }

    @Override
    protected String initDefault() {
        return String.valueOf(DateHelper.getDay(DateHelper.today()));
    }

    public void setOnFinishedLoopListener(FinishedLoopListener finishedLoopListener) {
        this.finishedLoopListener = finishedLoopListener;
    }

    @Override
    protected void onFinishedLoop() {
        super.onFinishedLoop();
        if (this.finishedLoopListener != null) {
            this.finishedLoopListener.onFinishedLoop(this);
        }
    }

    public void setDayOfMonthSelectedListener(DayOfMonthSelectedListener listener) {
        this.listener = listener;
    }

    public int getDaysInMonth() {
        return this.daysInMonth;
    }

    public void setDaysInMonth(int daysInMonth) {
        this.daysInMonth = daysInMonth;
    }

    @Override
    protected void onItemSelected(int position, String item) {
        if (this.listener != null) {
            this.listener.onDayOfMonthSelected(this, position);
        }
    }

    public int getCurrentDay() {
        return this.getCurrentItemPosition();
    }

    public static interface DayOfMonthSelectedListener {
        public void onDayOfMonthSelected(WheelDayOfMonthPicker var1, int var2);
    }

    public static interface FinishedLoopListener {
        public void onFinishedLoop(WheelDayOfMonthPicker var1);
    }
}

