/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelAmPmPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelDayPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelHourPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelMinutePicker;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SingleDateAndTimePicker
extends LinearLayout {
    public static final boolean IS_CYCLIC_DEFAULT = true;
    public static final boolean IS_CURVED_DEFAULT = false;
    public static final boolean MUST_BE_ON_FUTUR_DEFAULT = false;
    public static final int DELAY_BEFORE_CHECK_PAST = 200;
    private static final int VISIBLE_ITEM_COUNT_DEFAULT = 7;
    private static final int PM_HOUR_ADDITION = 12;
    private static final CharSequence FORMAT_24_HOUR = "EEE d MMM H:mm";
    private static final CharSequence FORMAT_12_HOUR = "EEE d MMM h:mm a";
    @NonNull
    private final WheelDayPicker daysPicker;
    @NonNull
    private final WheelMinutePicker minutesPicker;
    @NonNull
    private final WheelHourPicker hoursPicker;
    @NonNull
    private final WheelAmPmPicker amPmPicker;
    private List<WheelPicker> pickers = new ArrayList<WheelPicker>();
    private List<OnDateChangedListener> listeners = new ArrayList<OnDateChangedListener>();
    private View dtSelector;
    private boolean mustBeOnFuture;
    @Nullable
    private Date minDate;
    @Nullable
    private Date maxDate;
    @NonNull
    private Date defaultDate = new Date();
    private boolean displayYears = false;
    private boolean displayMonth = false;
    private boolean displayDays = true;
    private boolean displayMinutes = true;
    private boolean displayHours = true;
    private boolean isAmPm;
    private int selectorHeight;

    public SingleDateAndTimePicker(Context context) {
        this(context, null);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.isAmPm = !DateFormat.is24HourFormat((Context)context);
        SingleDateAndTimePicker.inflate((Context)context, (int)R.layout.single_day_picker, (ViewGroup)this);
        this.daysPicker = (WheelDayPicker)this.findViewById(R.id.daysPicker);
        this.minutesPicker = (WheelMinutePicker)this.findViewById(R.id.minutesPicker);
        this.hoursPicker = (WheelHourPicker)this.findViewById(R.id.hoursPicker);
        this.amPmPicker = (WheelAmPmPicker)this.findViewById(R.id.amPmPicker);
        this.dtSelector = this.findViewById(R.id.dtSelector);
        this.pickers.addAll(Arrays.asList(new WheelPicker[]{this.daysPicker, this.minutesPicker, this.hoursPicker, this.amPmPicker}));
        this.init(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.daysPicker.setOnDaySelectedListener(new WheelDayPicker.OnDaySelectedListener(){

            @Override
            public void onDaySelected(WheelDayPicker picker, int position, String name, Date date) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.minutesPicker.setOnMinuteChangedListener(new WheelMinutePicker.OnMinuteChangedListener(){

            @Override
            public void onMinuteChanged(WheelMinutePicker picker, int minutes) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        }).setOnFinishedLoopListener(new WheelMinutePicker.OnFinishedLoopListener(){

            @Override
            public void onFinishedLoop(WheelMinutePicker picker) {
                SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.getCurrentItemPosition() + 1);
            }
        });
        this.hoursPicker.setOnFinishedLoopListener(new WheelHourPicker.FinishedLoopListener(){

            @Override
            public void onFinishedLoop(WheelHourPicker picker) {
                SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.getCurrentItemPosition() + 1);
            }
        }).setHourChangedListener(new WheelHourPicker.OnHourChangedListener(){

            @Override
            public void onHourChanged(WheelHourPicker picker, int hour) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.amPmPicker.setAmPmListener(new WheelAmPmPicker.AmPmListener(){

            @Override
            public void onAmPmChanged(WheelAmPmPicker picker, boolean isAm) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkMinMaxDate(picker);
            }
        });
        this.setDefaultDate(this.defaultDate);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (WheelPicker picker : this.pickers) {
            picker.setEnabled(enabled);
        }
    }

    public void setDisplayDays(boolean displayDays) {
        this.displayDays = displayDays;
        this.daysPicker.setVisibility(displayDays ? 0 : 8);
    }

    public void setDisplayMinutes(boolean displayMinutes) {
        this.displayMinutes = displayMinutes;
        this.minutesPicker.setVisibility(displayMinutes ? 0 : 8);
    }

    public void setDisplayHours(boolean displayHours) {
        this.displayHours = displayHours;
        this.hoursPicker.setVisibility(displayHours ? 0 : 8);
        this.setIsAmPm(this.isAmPm);
        this.hoursPicker.setIsAmPm(this.isAmPm);
    }

    public void setTodayText(String todayText) {
        if (todayText != null && !todayText.isEmpty()) {
            this.daysPicker.setTodayText(todayText);
        }
    }

    public void setCurved(boolean curved) {
        for (WheelPicker picker : this.pickers) {
            picker.setCurved(curved);
        }
    }

    public void setCyclic(boolean cyclic) {
        for (WheelPicker picker : this.pickers) {
            picker.setCyclic(cyclic);
        }
    }

    public void setTextSize(int textSize) {
        for (WheelPicker picker : this.pickers) {
            picker.setItemTextSize(textSize);
        }
    }

    public void setSelectedTextColor(int selectedTextColor) {
        for (WheelPicker picker : this.pickers) {
            picker.setSelectedItemTextColor(selectedTextColor);
        }
    }

    public void setTextColor(int textColor) {
        for (WheelPicker picker : this.pickers) {
            picker.setItemTextColor(textColor);
        }
    }

    public void setSelectorColor(int selectorColor) {
        this.dtSelector.setBackgroundColor(selectorColor);
    }

    public void setSelectorHeight(int selectorHeight) {
        ViewGroup.LayoutParams dtSelectorLayoutParams = this.dtSelector.getLayoutParams();
        dtSelectorLayoutParams.height = selectorHeight;
        this.dtSelector.setLayoutParams(dtSelectorLayoutParams);
    }

    public void setVisibleItemCount(int visibleItemCount) {
        for (WheelPicker picker : this.pickers) {
            picker.setVisibleItemCount(visibleItemCount);
        }
    }

    public void setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        this.amPmPicker.setVisibility(isAmPm && this.displayHours ? 0 : 8);
        this.hoursPicker.setIsAmPm(isAmPm);
    }

    public void setDayFormatter(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.daysPicker.setDayFormatter(simpleDateFormat);
        }
    }

    public boolean isAmPm() {
        return this.isAmPm;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    private void checkMinMaxDate(WheelPicker picker) {
        this.checkBeforeMinDate(picker);
        this.checkAfterMaxDate(picker);
    }

    private void checkBeforeMinDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.minDate != null && SingleDateAndTimePicker.this.isBeforeMinDate(SingleDateAndTimePicker.this.getDate())) {
                    for (WheelPicker p : SingleDateAndTimePicker.this.pickers) {
                        p.scrollTo(p.findIndexOfDate(SingleDateAndTimePicker.this.minDate));
                    }
                }
            }
        }, 200L);
    }

    private void checkAfterMaxDate(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SingleDateAndTimePicker.this.maxDate != null && SingleDateAndTimePicker.this.isAfterMaxDate(SingleDateAndTimePicker.this.getDate())) {
                    for (WheelPicker p : SingleDateAndTimePicker.this.pickers) {
                        p.scrollTo(p.findIndexOfDate(SingleDateAndTimePicker.this.maxDate));
                    }
                }
            }
        }, 200L);
    }

    private boolean isBeforeMinDate(Date date) {
        return DateHelper.getCalendarOfDate(date).before(DateHelper.getCalendarOfDate(this.minDate));
    }

    private boolean isAfterMaxDate(Date date) {
        return DateHelper.getCalendarOfDate(date).after(DateHelper.getCalendarOfDate(this.maxDate));
    }

    public void addOnDateChangedListener(OnDateChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeOnDateChangedListener(OnDateChangedListener listener) {
        this.listeners.remove(listener);
    }

    public Date getDate() {
        int hour = this.hoursPicker.getCurrentHour();
        if (this.isAmPm && this.amPmPicker.isPm()) {
            hour += 12;
        }
        int minute = this.minutesPicker.getCurrentMinute();
        Calendar calendar = Calendar.getInstance();
        Date dayDate = this.daysPicker.getCurrentDate();
        calendar.setTime(dayDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        return calendar.getTime();
    }

    public void setStepMinutes(int minutesStep) {
        this.minutesPicker.setStepMinutes(minutesStep);
    }

    public void setHoursStep(int hoursStep) {
        this.hoursPicker.setHoursStep(hoursStep);
    }

    public void setDefaultDate(Date date) {
        if (date != null) {
            this.defaultDate = date;
            for (WheelPicker picker : this.pickers) {
                picker.setDefaultDate(this.defaultDate);
            }
        }
    }

    public void selectDate(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        for (WheelPicker picker : this.pickers) {
            picker.selectDate(date);
        }
    }

    private void updateListener() {
        Date date = this.getDate();
        CharSequence format = this.isAmPm ? FORMAT_12_HOUR : FORMAT_24_HOUR;
        String displayed = DateFormat.format((CharSequence)format, (Date)date).toString();
        for (OnDateChangedListener listener : this.listeners) {
            listener.onDateChanged(displayed, date);
        }
    }

    public void setMustBeOnFuture(boolean mustBeOnFuture) {
        this.mustBeOnFuture = mustBeOnFuture;
        if (mustBeOnFuture) {
            this.minDate = Calendar.getInstance().getTime();
        }
    }

    public boolean mustBeOnFuture() {
        return this.mustBeOnFuture;
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SingleDateAndTimePicker);
        Resources resources = this.getResources();
        this.setTodayText(a.getString(R.styleable.SingleDateAndTimePicker_picker_todayText));
        this.setTextColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_textColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_text_color)));
        this.setSelectedTextColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectedTextColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_selected_text_color)));
        this.setSelectorColor(a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectorColor, ContextCompat.getColor((Context)context, (int)R.color.picker_default_selector_color)));
        this.setSelectorHeight(a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_selectorHeight, resources.getDimensionPixelSize(R.dimen.wheelSelectorHeight)));
        this.setTextSize(a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_textSize, resources.getDimensionPixelSize(R.dimen.WheelItemTextSize)));
        this.setCurved(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_curved, false));
        this.setCyclic(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_cyclic, true));
        this.setMustBeOnFuture(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_mustBeOnFuture, false));
        this.setVisibleItemCount(a.getInt(R.styleable.SingleDateAndTimePicker_picker_visibleItemCount, 7));
        this.displayMonth = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayMonth, this.displayMonth);
        this.setDisplayDays(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayYears, this.displayYears));
        this.setDisplayDays(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayDays, this.displayDays));
        this.setDisplayMinutes(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayMinutes, this.displayMinutes));
        this.setDisplayHours(a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_displayHours, this.displayHours));
        a.recycle();
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(String var1, Date var2);
    }
}

