/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelDayPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelHourPicker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class WheelPicker
extends View {
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    protected static final String FORMAT = "%1$02d";
    private final Handler handler = new Handler();
    private Paint paint;
    private Scroller scroller;
    private VelocityTracker tracker;
    private OnItemSelectedListener onItemSelectedListener;
    private OnWheelChangeListener onWheelChangeListener;
    private Rect rectDrawn;
    private Rect rectIndicatorHead;
    private Rect rectIndicatorFoot;
    private Rect rectCurrentItem;
    private Camera camera;
    private Matrix matrixRotate;
    private Matrix matrixDepth;
    private BaseAdapter adapter;
    private String maxWidthText;
    private int mVisibleItemCount;
    private int mDrawnItemCount;
    private int mHalfDrawnItemCount;
    private int mTextMaxWidth;
    private int mTextMaxHeight;
    private int mItemTextColor;
    private int mSelectedItemTextColor;
    private int mItemTextSize;
    private int mIndicatorSize;
    private int mIndicatorColor;
    private int mCurtainColor;
    private int mItemSpace;
    private int mItemAlign;
    private int mItemHeight;
    private int mHalfItemHeight;
    private int mHalfWheelHeight;
    private int selectedItemPosition;
    private int currentItemPosition;
    private int minFlingY;
    private int maxFlingY;
    private int minimumVelocity = 50;
    private int maximumVelocity = 8000;
    private int wheelCenterX;
    private int wheelCenterY;
    private int drawnCenterX;
    private int drawnCenterY;
    private int scrollOffsetY;
    private int textMaxWidthPosition;
    private int lastPointY;
    private int downPointY;
    private int touchSlop = 8;
    private boolean hasSameWidth;
    private boolean hasIndicator;
    private boolean hasCurtain;
    private boolean hasAtmospheric;
    private boolean isCyclic;
    private boolean isCurved;
    private boolean isClick;
    private boolean isForceFinishScroll;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            int position;
            if (null == WheelPicker.this.adapter) {
                return;
            }
            int itemCount = WheelPicker.this.adapter.getItemCount();
            if (itemCount == 0) {
                return;
            }
            if (WheelPicker.this.scroller.isFinished() && !WheelPicker.this.isForceFinishScroll) {
                if (WheelPicker.this.mItemHeight == 0) {
                    return;
                }
                position = (-WheelPicker.this.scrollOffsetY / WheelPicker.this.mItemHeight + WheelPicker.this.selectedItemPosition) % itemCount;
                position = position < 0 ? position + itemCount : position;
                WheelPicker.this.currentItemPosition = position;
                WheelPicker.this.onItemSelected();
                if (null != WheelPicker.this.onWheelChangeListener) {
                    WheelPicker.this.onWheelChangeListener.onWheelSelected(position);
                    WheelPicker.this.onWheelChangeListener.onWheelScrollStateChanged(0);
                }
            }
            if (WheelPicker.this.scroller.computeScrollOffset()) {
                if (null != WheelPicker.this.onWheelChangeListener) {
                    WheelPicker.this.onWheelChangeListener.onWheelScrollStateChanged(2);
                }
                WheelPicker.this.scrollOffsetY = WheelPicker.this.scroller.getCurrY();
                position = (-WheelPicker.this.scrollOffsetY / WheelPicker.this.mItemHeight + WheelPicker.this.selectedItemPosition) % itemCount;
                if (WheelPicker.this.onItemSelectedListener != null) {
                    WheelPicker.this.onItemSelectedListener.onCurrentItemOfScroll(WheelPicker.this, position);
                }
                WheelPicker.this.onItemCurrentScroll(position, WheelPicker.this.adapter.getItem(position));
                WheelPicker.this.postInvalidate();
                WheelPicker.this.handler.postDelayed((Runnable)this, 16L);
            }
        }
    };

    public WheelPicker(Context context) {
        this(context, null);
    }

    public WheelPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.adapter = new Adapter();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelPicker);
        this.mItemTextSize = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_item_text_size, this.getResources().getDimensionPixelSize(R.dimen.WheelItemTextSize));
        this.mVisibleItemCount = a.getInt(R.styleable.WheelPicker_wheel_visible_item_count, 7);
        this.selectedItemPosition = a.getInt(R.styleable.WheelPicker_wheel_selected_item_position, 0);
        this.hasSameWidth = a.getBoolean(R.styleable.WheelPicker_wheel_same_width, false);
        this.textMaxWidthPosition = a.getInt(R.styleable.WheelPicker_wheel_maximum_width_text_position, -1);
        this.maxWidthText = a.getString(R.styleable.WheelPicker_wheel_maximum_width_text);
        this.mSelectedItemTextColor = a.getColor(R.styleable.WheelPicker_wheel_selected_item_text_color, -1);
        this.mItemTextColor = a.getColor(R.styleable.WheelPicker_wheel_item_text_color, -7829368);
        this.mItemSpace = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_item_space, this.getResources().getDimensionPixelSize(R.dimen.WheelItemSpace));
        this.isCyclic = a.getBoolean(R.styleable.WheelPicker_wheel_cyclic, false);
        this.hasIndicator = a.getBoolean(R.styleable.WheelPicker_wheel_indicator, false);
        this.mIndicatorColor = a.getColor(R.styleable.WheelPicker_wheel_indicator_color, -1166541);
        this.mIndicatorSize = a.getDimensionPixelSize(R.styleable.WheelPicker_wheel_indicator_size, this.getResources().getDimensionPixelSize(R.dimen.WheelIndicatorSize));
        this.hasCurtain = a.getBoolean(R.styleable.WheelPicker_wheel_curtain, false);
        this.mCurtainColor = a.getColor(R.styleable.WheelPicker_wheel_curtain_color, -1996488705);
        this.hasAtmospheric = a.getBoolean(R.styleable.WheelPicker_wheel_atmospheric, false);
        this.isCurved = a.getBoolean(R.styleable.WheelPicker_wheel_curved, false);
        this.mItemAlign = a.getInt(R.styleable.WheelPicker_wheel_item_align, 0);
        a.recycle();
        this.updateVisibleItemCount();
        this.paint = new Paint(69);
        this.paint.setTextSize((float)this.mItemTextSize);
        this.updateItemTextAlign();
        this.computeTextSize();
        this.scroller = new Scroller(this.getContext());
        if (Build.VERSION.SDK_INT >= 4) {
            ViewConfiguration conf = ViewConfiguration.get((Context)this.getContext());
            this.minimumVelocity = conf.getScaledMinimumFlingVelocity();
            this.maximumVelocity = conf.getScaledMaximumFlingVelocity();
            this.touchSlop = conf.getScaledTouchSlop();
        }
        this.rectDrawn = new Rect();
        this.rectIndicatorHead = new Rect();
        this.rectIndicatorFoot = new Rect();
        this.rectCurrentItem = new Rect();
        this.camera = new Camera();
        this.matrixRotate = new Matrix();
        this.matrixDepth = new Matrix();
    }

    private void updateVisibleItemCount() {
        if (this.mVisibleItemCount < 2) {
            throw new ArithmeticException("Wheel's visible item count can not be less than 2!");
        }
        if (this.mVisibleItemCount % 2 == 0) {
            ++this.mVisibleItemCount;
        }
        this.mDrawnItemCount = this.mVisibleItemCount + 2;
        this.mHalfDrawnItemCount = this.mDrawnItemCount / 2;
    }

    private void computeTextSize() {
        this.mTextMaxHeight = 0;
        this.mTextMaxWidth = 0;
        if (this.hasSameWidth) {
            this.mTextMaxWidth = (int)this.paint.measureText(this.adapter.getItemText(0));
        } else if (this.isPosInRang(this.textMaxWidthPosition)) {
            this.mTextMaxWidth = (int)this.paint.measureText(this.adapter.getItemText(this.textMaxWidthPosition));
        } else if (!TextUtils.isEmpty((CharSequence)this.maxWidthText)) {
            this.mTextMaxWidth = (int)this.paint.measureText(this.maxWidthText);
        } else {
            int itemCount = this.adapter.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                String text = this.adapter.getItemText(i);
                int width = (int)this.paint.measureText(text);
                this.mTextMaxWidth = Math.max(this.mTextMaxWidth, width);
            }
        }
        Paint.FontMetrics metrics = this.paint.getFontMetrics();
        this.mTextMaxHeight = (int)(metrics.bottom - metrics.top);
    }

    private void updateItemTextAlign() {
        switch (this.mItemAlign) {
            case 1: {
                this.paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.paint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultWidth = this.mTextMaxWidth;
        int resultHeight = this.mTextMaxHeight * this.mVisibleItemCount + this.mItemSpace * (this.mVisibleItemCount - 1);
        if (this.isCurved) {
            resultHeight = (int)((double)(2 * resultHeight) / Math.PI);
        }
        resultWidth += this.getPaddingLeft() + this.getPaddingRight();
        resultHeight += this.getPaddingTop() + this.getPaddingBottom();
        resultWidth = this.measureSize(modeWidth, sizeWidth, resultWidth);
        resultHeight = this.measureSize(modeHeight, sizeHeight, resultHeight);
        this.setMeasuredDimension(resultWidth, resultHeight);
    }

    private int measureSize(int mode, int sizeExpect, int sizeActual) {
        int realSize;
        if (mode == 0x40000000) {
            realSize = sizeExpect;
        } else {
            realSize = sizeActual;
            if (mode == Integer.MIN_VALUE) {
                realSize = Math.min(realSize, sizeExpect);
            }
        }
        return realSize;
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.rectDrawn.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        this.wheelCenterX = this.rectDrawn.centerX();
        this.wheelCenterY = this.rectDrawn.centerY();
        this.computeDrawnCenter();
        this.mHalfWheelHeight = this.rectDrawn.height() / 2;
        this.mItemHeight = this.rectDrawn.height() / this.mVisibleItemCount;
        this.mHalfItemHeight = this.mItemHeight / 2;
        this.computeFlingLimitY();
        this.computeIndicatorRect();
        this.computeCurrentItemRect();
    }

    private void computeDrawnCenter() {
        switch (this.mItemAlign) {
            case 1: {
                this.drawnCenterX = this.rectDrawn.left;
                break;
            }
            case 2: {
                this.drawnCenterX = this.rectDrawn.right;
                break;
            }
            default: {
                this.drawnCenterX = this.wheelCenterX;
            }
        }
        this.drawnCenterY = (int)((float)this.wheelCenterY - (this.paint.ascent() + this.paint.descent()) / 2.0f);
    }

    private void computeFlingLimitY() {
        int currentItemOffset = this.selectedItemPosition * this.mItemHeight;
        this.minFlingY = this.isCyclic ? Integer.MIN_VALUE : -this.mItemHeight * (this.adapter.getItemCount() - 1) + currentItemOffset;
        this.maxFlingY = this.isCyclic ? Integer.MAX_VALUE : currentItemOffset;
    }

    private void computeIndicatorRect() {
        if (!this.hasIndicator) {
            return;
        }
        int halfIndicatorSize = this.mIndicatorSize / 2;
        int indicatorHeadCenterY = this.wheelCenterY + this.mHalfItemHeight;
        int indicatorFootCenterY = this.wheelCenterY - this.mHalfItemHeight;
        this.rectIndicatorHead.set(this.rectDrawn.left, indicatorHeadCenterY - halfIndicatorSize, this.rectDrawn.right, indicatorHeadCenterY + halfIndicatorSize);
        this.rectIndicatorFoot.set(this.rectDrawn.left, indicatorFootCenterY - halfIndicatorSize, this.rectDrawn.right, indicatorFootCenterY + halfIndicatorSize);
    }

    private void computeCurrentItemRect() {
        if (!this.hasCurtain && this.mSelectedItemTextColor == -1) {
            return;
        }
        this.rectCurrentItem.set(this.rectDrawn.left, this.wheelCenterY - this.mHalfItemHeight, this.rectDrawn.right, this.wheelCenterY + this.mHalfItemHeight);
    }

    protected void onDraw(Canvas canvas) {
        if (null != this.onWheelChangeListener) {
            this.onWheelChangeListener.onWheelScrolled(this.scrollOffsetY);
        }
        if (this.mItemHeight - this.mHalfDrawnItemCount <= 0) {
            return;
        }
        int drawnDataStartPos = -this.scrollOffsetY / this.mItemHeight - this.mHalfDrawnItemCount;
        int drawnDataPos = drawnDataStartPos + this.selectedItemPosition;
        int drawnOffsetPos = -this.mHalfDrawnItemCount;
        while (drawnDataPos < drawnDataStartPos + this.selectedItemPosition + this.mDrawnItemCount) {
            int drawnCenterY;
            String data = "";
            if (this.isCyclic) {
                int itemCount = this.adapter.getItemCount();
                int actualPos = drawnDataPos % itemCount;
                actualPos = actualPos < 0 ? actualPos + itemCount : actualPos;
                data = this.adapter.getItemText(actualPos);
            } else if (this.isPosInRang(drawnDataPos)) {
                data = this.adapter.getItemText(drawnDataPos);
            }
            this.paint.setColor(this.mItemTextColor);
            this.paint.setStyle(Paint.Style.FILL);
            int mDrawnItemCenterY = this.drawnCenterY + drawnOffsetPos * this.mItemHeight + this.scrollOffsetY % this.mItemHeight;
            int distanceToCenter = 0;
            if (this.isCurved) {
                float ratio = (float)(this.drawnCenterY - Math.abs(this.drawnCenterY - mDrawnItemCenterY) - this.rectDrawn.top) * 1.0f / (float)(this.drawnCenterY - this.rectDrawn.top);
                int unit = 0;
                if (mDrawnItemCenterY > this.drawnCenterY) {
                    unit = 1;
                } else if (mDrawnItemCenterY < this.drawnCenterY) {
                    unit = -1;
                }
                float degree = -(1.0f - ratio) * 90.0f * (float)unit;
                if (degree < -90.0f) {
                    degree = -90.0f;
                }
                if (degree > 90.0f) {
                    degree = 90.0f;
                }
                distanceToCenter = this.computeSpace((int)degree);
                int transX = this.wheelCenterX;
                switch (this.mItemAlign) {
                    case 1: {
                        transX = this.rectDrawn.left;
                        break;
                    }
                    case 2: {
                        transX = this.rectDrawn.right;
                    }
                }
                int transY = this.wheelCenterY - distanceToCenter;
                this.camera.save();
                this.camera.rotateX(degree);
                this.camera.getMatrix(this.matrixRotate);
                this.camera.restore();
                this.matrixRotate.preTranslate((float)(-transX), (float)(-transY));
                this.matrixRotate.postTranslate((float)transX, (float)transY);
                this.camera.save();
                this.camera.translate(0.0f, 0.0f, (float)this.computeDepth((int)degree));
                this.camera.getMatrix(this.matrixDepth);
                this.camera.restore();
                this.matrixDepth.preTranslate((float)(-transX), (float)(-transY));
                this.matrixDepth.postTranslate((float)transX, (float)transY);
                this.matrixRotate.postConcat(this.matrixDepth);
            }
            if (this.hasAtmospheric) {
                int alpha = (int)((float)(this.drawnCenterY - Math.abs(this.drawnCenterY - mDrawnItemCenterY)) * 1.0f / (float)this.drawnCenterY * 255.0f);
                alpha = alpha < 0 ? 0 : alpha;
                this.paint.setAlpha(alpha);
            }
            int n = drawnCenterY = this.isCurved ? this.drawnCenterY - distanceToCenter : mDrawnItemCenterY;
            if (this.mSelectedItemTextColor != -1) {
                canvas.save();
                if (this.isCurved) {
                    canvas.concat(this.matrixRotate);
                }
                canvas.clipRect(this.rectCurrentItem, Region.Op.DIFFERENCE);
                canvas.drawText(data, (float)this.drawnCenterX, (float)drawnCenterY, this.paint);
                canvas.restore();
                this.paint.setColor(this.mSelectedItemTextColor);
                canvas.save();
                if (this.isCurved) {
                    canvas.concat(this.matrixRotate);
                }
                canvas.clipRect(this.rectCurrentItem);
                canvas.drawText(data, (float)this.drawnCenterX, (float)drawnCenterY, this.paint);
                canvas.restore();
            } else {
                canvas.save();
                canvas.clipRect(this.rectDrawn);
                if (this.isCurved) {
                    canvas.concat(this.matrixRotate);
                }
                canvas.drawText(data, (float)this.drawnCenterX, (float)drawnCenterY, this.paint);
                canvas.restore();
            }
            ++drawnDataPos;
            ++drawnOffsetPos;
        }
        if (this.hasCurtain) {
            this.paint.setColor(this.mCurtainColor);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.rectCurrentItem, this.paint);
        }
        if (this.hasIndicator) {
            this.paint.setColor(this.mIndicatorColor);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.rectIndicatorHead, this.paint);
            canvas.drawRect(this.rectIndicatorFoot, this.paint);
        }
    }

    private boolean isPosInRang(int position) {
        return position >= 0 && position < this.adapter.getItemCount();
    }

    private int computeSpace(int degree) {
        return (int)(Math.sin(Math.toRadians(degree)) * (double)this.mHalfWheelHeight);
    }

    private int computeDepth(int degree) {
        return (int)((double)this.mHalfWheelHeight - Math.cos(Math.toRadians(degree)) * (double)this.mHalfWheelHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    if (null != this.getParent()) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    if (null == this.tracker) {
                        this.tracker = VelocityTracker.obtain();
                    } else {
                        this.tracker.clear();
                    }
                    this.tracker.addMovement(event);
                    if (!this.scroller.isFinished()) {
                        this.scroller.abortAnimation();
                        this.isForceFinishScroll = true;
                    }
                    this.downPointY = this.lastPointY = (int)event.getY();
                    break;
                }
                case 2: {
                    float move;
                    if (Math.abs((float)this.downPointY - event.getY()) < (float)this.touchSlop) {
                        this.isClick = true;
                        break;
                    }
                    this.isClick = false;
                    this.tracker.addMovement(event);
                    if (null != this.onWheelChangeListener) {
                        this.onWheelChangeListener.onWheelScrollStateChanged(1);
                    }
                    if (Math.abs(move = event.getY() - (float)this.lastPointY) < 1.0f) break;
                    this.scrollOffsetY = (int)((float)this.scrollOffsetY + move);
                    this.lastPointY = (int)event.getY();
                    this.invalidate();
                    break;
                }
                case 1: {
                    if (null != this.getParent()) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    if (this.isClick) break;
                    this.tracker.addMovement(event);
                    if (Build.VERSION.SDK_INT >= 4) {
                        this.tracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
                    } else {
                        this.tracker.computeCurrentVelocity(1000);
                    }
                    this.isForceFinishScroll = false;
                    int velocity = (int)this.tracker.getYVelocity();
                    if (Math.abs(velocity) > this.minimumVelocity) {
                        this.scroller.fling(0, this.scrollOffsetY, 0, velocity, 0, 0, this.minFlingY, this.maxFlingY);
                        this.scroller.setFinalY(this.scroller.getFinalY() + this.computeDistanceToEndPoint(this.scroller.getFinalY() % this.mItemHeight));
                    } else {
                        this.scroller.startScroll(0, this.scrollOffsetY, 0, this.computeDistanceToEndPoint(this.scrollOffsetY % this.mItemHeight));
                    }
                    if (!this.isCyclic) {
                        if (this.scroller.getFinalY() > this.maxFlingY) {
                            this.scroller.setFinalY(this.maxFlingY);
                        } else if (this.scroller.getFinalY() < this.minFlingY) {
                            this.scroller.setFinalY(this.minFlingY);
                        }
                    }
                    this.handler.post(this.runnable);
                    if (null == this.tracker) break;
                    this.tracker.recycle();
                    this.tracker = null;
                    break;
                }
                case 3: {
                    if (null != this.getParent()) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    if (null == this.tracker) break;
                    this.tracker.recycle();
                    this.tracker = null;
                }
            }
        }
        return true;
    }

    private int computeDistanceToEndPoint(int remainder) {
        if (Math.abs(remainder) > this.mHalfItemHeight) {
            if (this.scrollOffsetY < 0) {
                return -this.mItemHeight - remainder;
            }
            return this.mItemHeight - remainder;
        }
        return -remainder;
    }

    public void scrollTo(final int itemPosition) {
        if (itemPosition != this.currentItemPosition) {
            int differencesLines = this.currentItemPosition - itemPosition;
            int newScrollOffsetY = this.scrollOffsetY + differencesLines * this.mItemHeight;
            ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{this.scrollOffsetY, newScrollOffsetY});
            va.setDuration(300L);
            va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    WheelPicker.this.scrollOffsetY = (Integer)animation.getAnimatedValue();
                    WheelPicker.this.invalidate();
                }
            });
            va.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    WheelPicker.this.currentItemPosition = itemPosition;
                    WheelPicker.this.onItemSelected();
                }
            });
            va.start();
        }
    }

    private final void onItemSelected() {
        int position = this.currentItemPosition;
        Object item = this.adapter.getItem(position);
        if (null != this.onItemSelectedListener) {
            this.onItemSelectedListener.onItemSelected(this, item, position);
        }
        this.onItemSelected(position, item);
    }

    protected abstract void onItemSelected(int var1, Object var2);

    protected abstract void onItemCurrentScroll(int var1, Object var2);

    protected abstract String getFormattedValue(Object var1);

    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    public void setVisibleItemCount(int count) {
        this.mVisibleItemCount = count;
        this.updateVisibleItemCount();
        this.requestLayout();
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
        this.computeFlingLimitY();
        this.invalidate();
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.onItemSelectedListener = listener;
    }

    public int getSelectedItemPosition() {
        return this.selectedItemPosition;
    }

    public void setSelectedItemPosition(int position) {
        position = Math.min(position, this.adapter.getItemCount() - 1);
        this.selectedItemPosition = position = Math.max(position, 0);
        this.currentItemPosition = position;
        this.scrollOffsetY = 0;
        this.computeFlingLimitY();
        this.requestLayout();
        this.invalidate();
    }

    public int getCurrentItemPosition() {
        return this.currentItemPosition;
    }

    public abstract int getDefaultItemPosition();

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
        this.notifyDatasetChanged();
    }

    public void notifyDatasetChanged() {
        this.selectedItemPosition = this.selectedItemPosition > this.adapter.getItemCount() - 1 || this.currentItemPosition > this.adapter.getItemCount() - 1 ? (this.currentItemPosition = this.adapter.getItemCount() - 1) : this.currentItemPosition;
        this.scrollOffsetY = 0;
        this.computeTextSize();
        this.computeFlingLimitY();
        this.requestLayout();
        this.invalidate();
    }

    public void setSameWidth(boolean hasSameWidth) {
        this.hasSameWidth = hasSameWidth;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public boolean hasSameWidth() {
        return this.hasSameWidth;
    }

    public void setOnWheelChangeListener(OnWheelChangeListener listener) {
        this.onWheelChangeListener = listener;
    }

    public String getMaximumWidthText() {
        return this.maxWidthText;
    }

    public void setMaximumWidthText(String text) {
        if (null == text) {
            throw new NullPointerException("Maximum width text can not be null!");
        }
        this.maxWidthText = text;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getMaximumWidthTextPosition() {
        return this.textMaxWidthPosition;
    }

    public void setMaximumWidthTextPosition(int position) {
        if (!this.isPosInRang(position)) {
            throw new ArrayIndexOutOfBoundsException("Maximum width text Position must in [0, " + this.adapter.getItemCount() + "), but current is " + position);
        }
        this.textMaxWidthPosition = position;
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getSelectedItemTextColor() {
        return this.mSelectedItemTextColor;
    }

    public void setSelectedItemTextColor(int color) {
        this.mSelectedItemTextColor = color;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    public int getItemTextColor() {
        return this.mItemTextColor;
    }

    public void setItemTextColor(int color) {
        this.mItemTextColor = color;
        this.invalidate();
    }

    public int getItemTextSize() {
        return this.mItemTextSize;
    }

    public void setItemTextSize(int size) {
        if (this.mItemTextSize != size) {
            this.mItemTextSize = size;
            this.paint.setTextSize((float)this.mItemTextSize);
            this.computeTextSize();
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getItemSpace() {
        return this.mItemSpace;
    }

    public void setItemSpace(int space) {
        this.mItemSpace = space;
        this.requestLayout();
        this.invalidate();
    }

    public void setIndicator(boolean hasIndicator) {
        this.hasIndicator = hasIndicator;
        this.computeIndicatorRect();
        this.invalidate();
    }

    public boolean hasIndicator() {
        return this.hasIndicator;
    }

    public int getIndicatorSize() {
        return this.mIndicatorSize;
    }

    public void setIndicatorSize(int size) {
        this.mIndicatorSize = size;
        this.computeIndicatorRect();
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.mIndicatorColor;
    }

    public void setIndicatorColor(int color) {
        this.mIndicatorColor = color;
        this.invalidate();
    }

    public void setCurtain(boolean hasCurtain) {
        this.hasCurtain = hasCurtain;
        this.computeCurrentItemRect();
        this.invalidate();
    }

    public boolean hasCurtain() {
        return this.hasCurtain;
    }

    public int getCurtainColor() {
        return this.mCurtainColor;
    }

    public void setCurtainColor(int color) {
        this.mCurtainColor = color;
        this.invalidate();
    }

    public void setAtmospheric(boolean hasAtmospheric) {
        this.hasAtmospheric = hasAtmospheric;
        this.invalidate();
    }

    public boolean hasAtmospheric() {
        return this.hasAtmospheric;
    }

    public boolean isCurved() {
        return this.isCurved;
    }

    public void setCurved(boolean isCurved) {
        this.isCurved = isCurved;
        this.requestLayout();
        this.invalidate();
    }

    public int getItemAlign() {
        return this.mItemAlign;
    }

    public void setItemAlign(int align) {
        this.mItemAlign = align;
        this.updateItemTextAlign();
        this.computeDrawnCenter();
        this.invalidate();
    }

    public Typeface getTypeface() {
        if (null != this.paint) {
            return this.paint.getTypeface();
        }
        return null;
    }

    public void setTypeface(Typeface tf) {
        if (null != this.paint) {
            this.paint.setTypeface(tf);
        }
        this.computeTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int findIndexOfDate(@NonNull Date date) {
        String today;
        String formatItem = this.getFormattedValue(date);
        if (this instanceof WheelDayPicker && (today = this.getFormattedValue(new Date())).equals(formatItem)) {
            return this.getDefaultItemPosition();
        }
        int formatItemInt = Integer.MIN_VALUE;
        try {
            formatItemInt = Integer.parseInt(formatItem);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int itemCount = this.adapter.getItemCount();
        int index = 0;
        for (int i = 0; i < itemCount; ++i) {
            String object = this.adapter.getItemText(i);
            if (formatItemInt != Integer.MIN_VALUE) {
                int objectInt = Integer.parseInt(object);
                if (this instanceof WheelHourPicker && ((WheelHourPicker)this).isAmPm) {
                    objectInt %= 12;
                }
                if (objectInt > formatItemInt) continue;
                index = i;
                continue;
            }
            if (!formatItem.equals(object)) continue;
            return i;
        }
        return index;
    }

    @TargetApi(value=24)
    public Locale getCurrentLocale() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.getResources().getConfiguration().getLocales().get(0);
        }
        return this.getResources().getConfiguration().locale;
    }

    public static class Adapter
    implements BaseAdapter {
        private List data = new ArrayList();

        public Adapter() {
            this(new ArrayList());
        }

        public Adapter(List data) {
            this.data.addAll(data);
        }

        @Override
        public int getItemCount() {
            return this.data.size();
        }

        @Override
        public Object getItem(int position) {
            int itemCount = this.getItemCount();
            return this.data.get((position + itemCount) % itemCount);
        }

        @Override
        public String getItemText(int position) {
            return String.valueOf(this.data.get(position));
        }

        public void setData(List data) {
            this.data.clear();
            this.data.addAll(data);
        }

        public List getData() {
            return this.data;
        }

        public void addData(List data) {
            this.data.addAll(data);
        }
    }

    public static interface OnWheelChangeListener {
        public void onWheelScrolled(int var1);

        public void onWheelSelected(int var1);

        public void onWheelScrollStateChanged(int var1);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(WheelPicker var1, Object var2, int var3);

        public void onCurrentItemOfScroll(WheelPicker var1, int var2);
    }

    public static interface BaseAdapter {
        public int getItemCount();

        public Object getItem(int var1);

        public String getItemText(int var1);
    }
}

