/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;

public class WheelHourPicker
extends WheelPicker {
    public static final int MIN_HOUR = 0;
    public static final int MAX_HOUR = 23;
    public static final int STEP_HOUR = 1;
    private OnHourSelectedListener hoursSelectedListener;
    private int defaultHour;
    private int lastScrollPosition;
    private WheelPicker.Adapter adapter;

    public WheelHourPicker(Context context) {
        this(context, null);
    }

    public WheelHourPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        String format = "%1$02d";
        ArrayList<String> hours = new ArrayList<String>();
        for (int hour = 0; hour <= 23; ++hour) {
            hours.add(String.format("%1$02d", hour));
        }
        this.adapter = new WheelPicker.Adapter(hours);
        this.setAdapter(this.adapter);
        this.defaultHour = Calendar.getInstance().get(11);
        this.updateDefaultHour();
    }

    @Override
    protected void onItemSelected(int position, Object item) {
        if (this.hoursSelectedListener != null) {
            this.hoursSelectedListener.onHourSelected(this, position, this.convertItemToHour(item));
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, Object item) {
        if (this.hoursSelectedListener != null) {
            this.hoursSelectedListener.onHourCurrentScrolled(this, position, this.convertItemToHour(item));
        }
        if (this.lastScrollPosition != position) {
            this.hoursSelectedListener.onHourCurrentScrolled(this, position, this.convertItemToHour(item));
            if (this.lastScrollPosition == 23 && position == 0 && this.hoursSelectedListener != null) {
                this.hoursSelectedListener.onHourCurrentNewDay(this);
            }
            this.lastScrollPosition = position;
        }
    }

    private void updateDefaultHour() {
        this.setSelectedItemPosition(this.defaultHour);
    }

    @Override
    public int getDefaultItemPosition() {
        return this.defaultHour;
    }

    public void setOnHourSelectedListener(OnHourSelectedListener hoursSelectedListener) {
        this.hoursSelectedListener = hoursSelectedListener;
    }

    public void setDefaultHour(int hour) {
        this.defaultHour = hour;
        this.updateDefaultHour();
    }

    private int convertItemToHour(Object item) {
        return Integer.valueOf(String.valueOf(item));
    }

    public int getCurrentHour() {
        return this.convertItemToHour(this.adapter.getItem(this.getCurrentItemPosition()));
    }

    public static interface OnHourSelectedListener {
        public void onHourSelected(WheelHourPicker var1, int var2, int var3);

        public void onHourCurrentScrolled(WheelHourPicker var1, int var2, int var3);

        public void onHourCurrentNewDay(WheelHourPicker var1);
    }
}

