/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelDayPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelHourPicker;
import com.github.florent37.singledateandtimepicker.widget.WheelMinutePicker;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class SingleDateAndTimePicker
extends LinearLayout {
    public static final boolean IS_CYCLIC_DEFAULT = true;
    public static final boolean IS_CURVED_DEFAULT = false;
    public static final boolean CAN_BE_ON_PAST_DEFAULT = false;
    public static final int DELAY_BEFORE_CHECK_PAST = 200;
    private static final int VISIBLE_ITEM_COUNT_DEFAULT = 7;
    private WheelDayPicker daysPicker;
    private WheelMinutePicker minutesPicker;
    private WheelHourPicker hoursPicker;
    private Listener listener;
    private int textColor;
    private int selectedTextColor;
    private int textSize;
    private boolean isCyclic;
    private boolean isCurved;
    private int visibleItemCount;
    private boolean canBeOnPast;

    public SingleDateAndTimePicker(Context context) {
        this(context, null);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SingleDateAndTimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        SingleDateAndTimePicker.inflate((Context)context, (int)R.layout.single_day_picker, (ViewGroup)this);
        this.daysPicker = (WheelDayPicker)this.findViewById(R.id.daysPicker);
        this.minutesPicker = (WheelMinutePicker)this.findViewById(R.id.minutesPicker);
        this.hoursPicker = (WheelHourPicker)this.findViewById(R.id.hoursPicker);
        this.daysPicker.setOnDaySelectedListener(new WheelDayPicker.OnDaySelectedListener(){

            @Override
            public void onDaySelected(WheelDayPicker picker, int position, String name, Date date) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkInPast(picker);
            }
        });
        this.minutesPicker.setOnMinuteSelectedListener(new WheelMinutePicker.OnMinuteSelectedListener(){

            @Override
            public void onMinuteSelected(WheelMinutePicker picker, int position, int minutes) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkInPast(picker);
            }

            @Override
            public void onMinuteCurrentScrolled(WheelMinutePicker picker, int position, int minutes) {
            }

            @Override
            public void onMinuteScrolledNewHour(WheelMinutePicker picker) {
                SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.getCurrentItemPosition() + 1);
            }
        });
        this.hoursPicker.setOnHourSelectedListener(new WheelHourPicker.OnHourSelectedListener(){

            @Override
            public void onHourSelected(WheelHourPicker picker, int position, int hours) {
                SingleDateAndTimePicker.this.updateListener();
                SingleDateAndTimePicker.this.checkInPast(picker);
            }

            @Override
            public void onHourCurrentScrolled(WheelHourPicker picker, int position, int hours) {
            }

            @Override
            public void onHourCurrentNewDay(WheelHourPicker picker) {
                SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.getCurrentItemPosition() + 1);
            }
        });
        this.updatePicker();
    }

    public void setCurved(boolean curved) {
        this.isCurved = curved;
        this.updatePicker();
    }

    public void setCyclic(boolean cyclic) {
        this.isCyclic = cyclic;
        this.updatePicker();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.updatePicker();
    }

    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
        this.updatePicker();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.updatePicker();
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
        this.updatePicker();
    }

    private void updatePicker() {
        if (this.daysPicker != null && this.minutesPicker != null && this.hoursPicker != null) {
            for (WheelPicker wheelPicker : Arrays.asList(new WheelPicker[]{this.daysPicker, this.minutesPicker, this.hoursPicker})) {
                wheelPicker.setItemTextColor(this.textColor);
                wheelPicker.setSelectedItemTextColor(this.selectedTextColor);
                wheelPicker.setItemTextSize(this.textSize);
                wheelPicker.setCyclic(this.isCyclic);
                wheelPicker.setCurved(this.isCurved);
                wheelPicker.setVisibleItemCount(this.visibleItemCount);
            }
        }
    }

    private void checkInPast(WheelPicker picker) {
        picker.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!SingleDateAndTimePicker.this.canBeOnPast && SingleDateAndTimePicker.this.isInPast(SingleDateAndTimePicker.this.getDate())) {
                    SingleDateAndTimePicker.this.daysPicker.scrollTo(SingleDateAndTimePicker.this.daysPicker.getDefaultItemPosition());
                    SingleDateAndTimePicker.this.minutesPicker.scrollTo(SingleDateAndTimePicker.this.minutesPicker.getDefaultItemPosition());
                    SingleDateAndTimePicker.this.hoursPicker.scrollTo(SingleDateAndTimePicker.this.hoursPicker.getDefaultItemPosition());
                }
            }
        }, 200L);
    }

    private boolean isInPast(Date date) {
        Calendar todayCalendar = Calendar.getInstance();
        todayCalendar.set(14, 0);
        todayCalendar.set(13, 0);
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.set(14, 0);
        dateCalendar.set(13, 0);
        dateCalendar.setTime(date);
        return dateCalendar.before(todayCalendar);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Date getDate() {
        int hour = this.hoursPicker.getCurrentHour();
        int minute = this.minutesPicker.getCurrentMinute();
        Calendar calendar = Calendar.getInstance();
        Date dayDate = this.daysPicker.getCurrentDate();
        calendar.setTime(dayDate);
        calendar.set(11, hour);
        calendar.set(12, minute);
        Date time = calendar.getTime();
        return time;
    }

    private void updateListener() {
        int hour = this.hoursPicker.getCurrentHour();
        int minute = this.minutesPicker.getCurrentMinute();
        String displayed = this.daysPicker.getCurrentDay() + " " + hour + ":" + minute;
        if (this.listener != null) {
            this.listener.onDateChanged(displayed, this.getDate());
        }
    }

    public void setCanBeOnPast(boolean canBeOnPast) {
        this.canBeOnPast = canBeOnPast;
    }

    public boolean canBeOnPast() {
        return this.canBeOnPast;
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SingleDateAndTimePicker);
        this.textColor = a.getColor(R.styleable.SingleDateAndTimePicker_picker_textColor, this.getResources().getColor(R.color.picker_default_text_color));
        this.selectedTextColor = a.getColor(R.styleable.SingleDateAndTimePicker_picker_selectedTextColor, this.getResources().getColor(R.color.picker_default_selected_text_color));
        this.textSize = a.getDimensionPixelSize(R.styleable.SingleDateAndTimePicker_picker_textSize, this.getResources().getDimensionPixelSize(R.dimen.WheelItemTextSize));
        this.isCurved = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_curved, false);
        this.isCyclic = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_cyclic, true);
        this.canBeOnPast = a.getBoolean(R.styleable.SingleDateAndTimePicker_picker_canBeOnPast, false);
        this.visibleItemCount = a.getInt(R.styleable.SingleDateAndTimePicker_picker_visibleItemCount, 7);
        a.recycle();
    }

    public static interface Listener {
        public void onDateChanged(String var1, Date var2);
    }
}

