/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class RoundRectView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private final Paint borderPaint = new Paint(1);
    private final RectF borderRectF = new RectF();
    private final Path borderPath = new Path();
    private float topLeftRadius = 0.0f;
    private float topRightRadius = 0.0f;
    private float bottomRightRadius = 0.0f;
    private float bottomLeftRadius = 0.0f;
    @ColorInt
    private int borderColor = -1;
    private float borderWidthPx = 0.0f;

    public RoundRectView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RoundRectView);
            this.topLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_topLeftRadius, (int)this.topLeftRadius);
            this.topRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_topRightRadius, (int)this.topRightRadius);
            this.bottomLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_bottomLeftRadius, (int)this.bottomLeftRadius);
            this.bottomRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_bottomRightRadius, (int)this.bottomRightRadius);
            this.borderColor = attributes.getColor(R.styleable.RoundRectView_shape_roundRect_borderColor, this.borderColor);
            this.borderWidthPx = attributes.getDimensionPixelSize(R.styleable.RoundRectView_shape_roundRect_borderWidth, (int)this.borderWidthPx);
            attributes.recycle();
        }
        this.borderPaint.setStyle(Paint.Style.STROKE);
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                RoundRectView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return RoundRectView.this.generatePath(RoundRectView.this.rectF, RoundRectView.this.limitSize(RoundRectView.this.topLeftRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.topRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomLeftRadius, width, height));
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    protected float limitSize(float from, float width, float height) {
        return Math.min(from, Math.min(width, height));
    }

    @Override
    public void requiresShapeUpdate() {
        this.borderRectF.set(this.borderWidthPx / 2.0f, this.borderWidthPx / 2.0f, (float)this.getWidth() - this.borderWidthPx / 2.0f, (float)this.getHeight() - this.borderWidthPx / 2.0f);
        this.borderPath.set(this.generatePath(this.borderRectF, this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius));
        super.requiresShapeUpdate();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.borderWidthPx > 0.0f) {
            this.borderPaint.setStrokeWidth(this.borderWidthPx);
            this.borderPaint.setColor(this.borderColor);
            canvas.drawPath(this.borderPath, this.borderPaint);
        }
    }

    private Path generatePath(RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        return this.generatePath(false, rect, topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius);
    }

    private Path generatePath(boolean useBezier, RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        float arc;
        Path path = new Path();
        float left = rect.left;
        float top = rect.top;
        float bottom = rect.bottom;
        float right = rect.right;
        float maxSize = Math.min(rect.width() / 2.0f, rect.height() / 2.0f);
        float topLeftRadiusAbs = Math.abs(topLeftRadius);
        float topRightRadiusAbs = Math.abs(topRightRadius);
        float bottomLeftRadiusAbs = Math.abs(bottomLeftRadius);
        float bottomRightRadiusAbs = Math.abs(bottomRightRadius);
        if (topLeftRadiusAbs > maxSize) {
            topLeftRadiusAbs = maxSize;
        }
        if (topRightRadiusAbs > maxSize) {
            topRightRadiusAbs = maxSize;
        }
        if (bottomLeftRadiusAbs > maxSize) {
            bottomLeftRadiusAbs = maxSize;
        }
        if (bottomRightRadiusAbs > maxSize) {
            bottomRightRadiusAbs = maxSize;
        }
        path.moveTo(left + topLeftRadiusAbs, top);
        path.lineTo(right - topRightRadiusAbs, top);
        if (useBezier) {
            path.quadTo(right, top, right, top + topRightRadiusAbs);
        } else {
            arc = topRightRadius > 0.0f ? 90.0f : -270.0f;
            path.arcTo(new RectF(right - topRightRadiusAbs * 2.0f, top, right, top + topRightRadiusAbs * 2.0f), -90.0f, arc);
        }
        path.lineTo(right, bottom - bottomRightRadiusAbs);
        if (useBezier) {
            path.quadTo(right, bottom, right - bottomRightRadiusAbs, bottom);
        } else {
            arc = bottomRightRadiusAbs > 0.0f ? 90.0f : -270.0f;
            path.arcTo(new RectF(right - bottomRightRadiusAbs * 2.0f, bottom - bottomRightRadiusAbs * 2.0f, right, bottom), 0.0f, arc);
        }
        path.lineTo(left + bottomLeftRadiusAbs, bottom);
        if (useBezier) {
            path.quadTo(left, bottom, left, bottom - bottomLeftRadiusAbs);
        } else {
            arc = bottomLeftRadiusAbs > 0.0f ? 90.0f : -270.0f;
            path.arcTo(new RectF(left, bottom - bottomLeftRadiusAbs * 2.0f, left + bottomLeftRadiusAbs * 2.0f, bottom), 90.0f, arc);
        }
        path.lineTo(left, top + topLeftRadiusAbs);
        if (useBezier) {
            path.quadTo(left, top, left + topLeftRadiusAbs, top);
        } else {
            arc = topLeftRadiusAbs > 0.0f ? 90.0f : -270.0f;
            path.arcTo(new RectF(left, top, left + topLeftRadiusAbs * 2.0f, top + topLeftRadiusAbs * 2.0f), 180.0f, arc);
        }
        path.close();
        return path;
    }

    public float getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public void setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        this.requiresShapeUpdate();
    }

    public float getTopLeftRadiusDp() {
        return this.pxToDp(this.getTopLeftRadius());
    }

    public void setTopLeftRadiusDp(float topLeftRadius) {
        this.setTopLeftRadius(this.dpToPx(topLeftRadius));
    }

    public float getTopRightRadius() {
        return this.topRightRadius;
    }

    public void setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
        this.requiresShapeUpdate();
    }

    public float getTopRightRadiusDp() {
        return this.pxToDp(this.getTopRightRadius());
    }

    public void setTopRightRadiusDp(float topRightRadius) {
        this.setTopRightRadius(this.dpToPx(topRightRadius));
    }

    public float getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public void setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        this.requiresShapeUpdate();
    }

    public float getBottomRightRadiusDp() {
        return this.pxToDp(this.getBottomRightRadius());
    }

    public void setBottomRightRadiusDp(float bottomRightRadius) {
        this.setBottomRightRadius(this.dpToPx(bottomRightRadius));
    }

    public float getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public void setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        this.requiresShapeUpdate();
    }

    public float getBottomLeftRadiusDp() {
        return this.pxToDp(this.getBottomLeftRadius());
    }

    public void setBottomLeftRadiusDp(float bottomLeftRadius) {
        this.setBottomLeftRadius(this.dpToPx(bottomLeftRadius));
    }

    public float getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.requiresShapeUpdate();
    }

    public float getBorderWidth() {
        return this.borderWidthPx;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidthPx = borderWidth;
        this.requiresShapeUpdate();
    }

    public float getBorderWidthDp() {
        return this.pxToDp(this.getBorderWidth());
    }

    public void setBorderWidthDp(float borderWidth) {
        this.setBorderWidth(this.dpToPx(borderWidth));
    }
}

