/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class CircleView
extends ShapeOfView {
    private float borderWidthPx = 0.0f;
    @ColorInt
    private int borderColor = -1;
    private final Paint borderPaint = new Paint(1);

    public CircleView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircleView);
            this.borderWidthPx = attributes.getDimensionPixelSize(R.styleable.CircleView_shape_circle_borderWidth, (int)this.borderWidthPx);
            this.borderColor = attributes.getColor(R.styleable.CircleView_shape_circle_borderColor, this.borderColor);
            attributes.recycle();
        }
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                path.addCircle((float)width / 2.0f, (float)height / 2.0f, Math.min((float)width / 2.0f, (float)height / 2.0f), Path.Direction.CW);
                return path;
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.borderWidthPx > 0.0f) {
            this.borderPaint.setStrokeWidth(this.borderWidthPx);
            this.borderPaint.setColor(this.borderColor);
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min(((float)this.getWidth() - this.borderWidthPx) / 2.0f, ((float)this.getHeight() - this.borderWidthPx) / 2.0f), this.borderPaint);
        }
    }

    public void setBorderWidthPx(int borderWidth) {
        this.borderWidthPx = borderWidth;
        this.requiresShapeUpdate();
    }

    public void setBorderWidthDp(int borderWidth) {
        this.setBorderWidthPx(this.dpToPx(borderWidth));
    }

    public void setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        this.requiresShapeUpdate();
    }

    public float getBorderWidthPx() {
        return this.borderWidthPx;
    }

    public int getBorderColor() {
        return this.borderColor;
    }
}

