/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class PolygonView
extends ShapeOfView {
    private int numberOfSides = 4;

    public PolygonView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public PolygonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PolygonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.PolygonView);
            int sides = attributes.getInteger(R.styleable.PolygonView_shape_polygon_noOfSides, this.numberOfSides);
            this.numberOfSides = sides > 3 ? sides : this.numberOfSides;
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                float section = (float)(Math.PI * 2 / (double)PolygonView.this.numberOfSides);
                int polygonSize = Math.min(width, height);
                int radius = polygonSize / 2;
                int centerX = width / 2;
                int centerY = height / 2;
                Path polygonPath = new Path();
                polygonPath.moveTo((float)centerX + (float)radius * (float)Math.cos(0.0), (float)centerY + (float)radius * (float)Math.sin(0.0));
                for (int i = 1; i < PolygonView.this.numberOfSides; ++i) {
                    polygonPath.lineTo((float)centerX + (float)radius * (float)Math.cos(section * (float)i), (float)centerY + (float)radius * (float)Math.sin(section * (float)i));
                }
                polygonPath.close();
                return polygonPath;
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    public int getNoOfSides() {
        return this.numberOfSides;
    }

    public void setNoOfSides(int numberOfSides) {
        this.numberOfSides = numberOfSides;
        this.requiresShapeUpdate();
    }
}

