/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.runtimepermission.rx;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.github.florent37.runtimepermission.PermissionResult;
import com.github.florent37.runtimepermission.RuntimePermission;
import com.github.florent37.runtimepermission.callbacks.ResponseCallback;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.util.Arrays;
import java.util.List;

public class RxPermissions {
    private final RuntimePermission runtimePermission;

    public RxPermissions(FragmentActivity activity) {
        this.runtimePermission = RuntimePermission.askPermission((FragmentActivity)activity, (String[])new String[0]);
    }

    public RxPermissions(Fragment fragment) {
        this.runtimePermission = RuntimePermission.askPermission((FragmentActivity)fragment.getActivity(), (String[])new String[0]);
    }

    public Observable<PermissionResult> request(final List<String> permissions) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<PermissionResult>(){

            public void subscribe(final ObservableEmitter<PermissionResult> emitter) throws Exception {
                RxPermissions.this.runtimePermission.request(permissions).onResponse(new ResponseCallback(){

                    public void onResponse(PermissionResult result) {
                        if (result.isAccepted()) {
                            emitter.onNext((Object)result);
                            emitter.onComplete();
                        } else {
                            emitter.onError((Throwable)new Error(result));
                        }
                    }
                }).ask();
            }
        });
    }

    public Observable<PermissionResult> request(String ... permissions) {
        return this.request(Arrays.asList(permissions));
    }

    public Single<PermissionResult> requestAsSingle(String ... permissions) {
        return this.requestAsSingle(Arrays.asList(permissions));
    }

    public Single<PermissionResult> requestAsSingle(final List<String> permissions) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<PermissionResult>(){

            public void subscribe(final SingleEmitter<PermissionResult> emitter) throws Exception {
                RxPermissions.this.runtimePermission.request(permissions).onResponse(new ResponseCallback(){

                    public void onResponse(PermissionResult result) {
                        if (result.isAccepted()) {
                            emitter.onSuccess((Object)result);
                        } else {
                            emitter.onError((Throwable)new Error(result));
                        }
                    }
                }).ask();
            }
        });
    }

    public Flowable<PermissionResult> requestAsFlowable(String ... permissions) {
        return this.requestAsFlowable(Arrays.asList(permissions));
    }

    public Flowable<PermissionResult> requestAsFlowable(final List<String> permissions) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<PermissionResult>(){

            public void subscribe(final FlowableEmitter<PermissionResult> emitter) throws Exception {
                RxPermissions.this.runtimePermission.request(permissions).onResponse(new ResponseCallback(){

                    public void onResponse(PermissionResult result) {
                        if (result.isAccepted()) {
                            emitter.onNext((Object)result);
                        } else {
                            emitter.onError((Throwable)new Error(result));
                        }
                    }
                }).ask();
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    public Maybe<PermissionResult> requestAsMaybe(String ... permissions) {
        return this.requestAsMaybe(Arrays.asList(permissions));
    }

    public Maybe<PermissionResult> requestAsMaybe(final List<String> permissions) {
        return Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<PermissionResult>(){

            public void subscribe(final MaybeEmitter<PermissionResult> emitter) throws Exception {
                RxPermissions.this.runtimePermission.request(permissions).onResponse(new ResponseCallback(){

                    public void onResponse(PermissionResult result) {
                        if (result.isAccepted()) {
                            emitter.onSuccess((Object)result);
                        } else {
                            emitter.onError((Throwable)new Error(result));
                        }
                    }
                }).ask();
            }
        });
    }

    public static class Error
    extends Throwable {
        private final PermissionResult result;

        private Error(PermissionResult result) {
            this.result = result;
        }

        public PermissionResult getResult() {
            return this.result;
        }
    }
}

