/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.inlineactivityresult;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.github.florent37.inlineactivityresult.ActivityResultFragment;
import com.github.florent37.inlineactivityresult.Result;
import com.github.florent37.inlineactivityresult.callbacks.ActivityResultListener;
import com.github.florent37.inlineactivityresult.callbacks.FailCallback;
import com.github.florent37.inlineactivityresult.callbacks.SuccessCallback;
import com.github.florent37.inlineactivityresult.request.Request;
import com.github.florent37.inlineactivityresult.request.RequestFabric;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class InlineActivityResult {
    private static final String TAG = "ACTIVITY_RESULT_FRAGMENT_WEEEEE";
    private final Reference<FragmentActivity> activityReference;
    private final Reference<Fragment> fragmentReference;
    private final List<ActivityResultListener> responseListeners = new ArrayList<ActivityResultListener>();
    private final List<SuccessCallback> successCallbacks = new ArrayList<SuccessCallback>();
    private final List<FailCallback> failCallbacks = new ArrayList<FailCallback>();
    private final ActivityResultFragment.ActivityResultListener listener = new ActivityResultFragment.ActivityResultListener(){

        @Override
        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            InlineActivityResult.this.onReceivedActivityResult(requestCode, resultCode, data);
        }

        @Override
        public void error(Throwable throwable) {
            InlineActivityResult.this.onReceivedActivityException(throwable);
        }
    };

    public static InlineActivityResult startForResult(FragmentActivity activity, @Nullable Intent intent, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(activity).startForResult(intent, listener);
    }

    public static InlineActivityResult startForResult(Fragment fragment, @Nullable Intent intent, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(fragment).startForResult(intent, listener);
    }

    public static InlineActivityResult startForResult(FragmentActivity activity, @Nullable Request request, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(activity).startForResult(request, listener);
    }

    public static InlineActivityResult startForResult(Fragment fragment, @Nullable Request request, @Nullable ActivityResultListener listener) {
        return new InlineActivityResult(fragment).startForResult(request, listener);
    }

    public InlineActivityResult(@Nullable FragmentActivity activity) {
        this.activityReference = activity != null ? new WeakReference<FragmentActivity>(activity) : new WeakReference<Object>(null);
        this.fragmentReference = new WeakReference<Object>(null);
    }

    public InlineActivityResult(@Nullable Fragment fragment) {
        FragmentActivity activity = null;
        if (fragment != null) {
            activity = fragment.getActivity();
            this.fragmentReference = new WeakReference<Fragment>(fragment);
        } else {
            this.fragmentReference = new WeakReference<Object>(null);
        }
        this.activityReference = activity != null ? new WeakReference<FragmentActivity>(activity) : new WeakReference<Object>(null);
    }

    private void onReceivedActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block5: {
            Result result;
            block4: {
                result = new Result(this, requestCode, resultCode, data);
                if (resultCode != -1) break block4;
                for (SuccessCallback callback : this.successCallbacks) {
                    callback.onSuccess(result);
                }
                for (ActivityResultListener listener : this.responseListeners) {
                    listener.onSuccess(result);
                }
                break block5;
            }
            if (resultCode != 0) break block5;
            for (FailCallback callback : this.failCallbacks) {
                callback.onFailed(result);
            }
            for (ActivityResultListener listener : this.responseListeners) {
                listener.onFailed(result);
            }
        }
    }

    private void onReceivedActivityException(Throwable throwable) {
        Result result = new Result(this, throwable);
        for (FailCallback callback : this.failCallbacks) {
            callback.onFailed(result);
        }
        for (ActivityResultListener listener : this.responseListeners) {
            listener.onFailed(result);
        }
    }

    public InlineActivityResult startForResult(@Nullable Intent intent) {
        return this.startForResult(RequestFabric.create(intent));
    }

    public InlineActivityResult startForResult(@Nullable Intent intent, @Nullable ActivityResultListener listener) {
        return this.startForResult(RequestFabric.create(intent), listener);
    }

    public InlineActivityResult startForResult(@Nullable Request request) {
        if (request != null) {
            this.start(request);
        }
        return this;
    }

    public InlineActivityResult startForResult(@Nullable Request request, @Nullable ActivityResultListener listener) {
        if (request != null) {
            if (listener != null) {
                this.responseListeners.add(listener);
            }
            this.start(request);
        }
        return this;
    }

    public InlineActivityResult onSuccess(@Nullable SuccessCallback callback) {
        if (callback != null) {
            this.successCallbacks.add(callback);
        }
        return this;
    }

    public InlineActivityResult onFail(@Nullable FailCallback callback) {
        if (callback != null) {
            this.failCallbacks.add(callback);
        }
        return this;
    }

    private void start(@NonNull Request request) {
        final FragmentActivity activity = this.activityReference.get();
        if (activity == null || activity.isFinishing()) {
            this.listener.error((Throwable)new ActivityNotFoundException("activity is null or finished"));
            return;
        }
        final ActivityResultFragment newFragment = ActivityResultFragment.newInstance(request, this.listener);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Fragment fragment = (Fragment)InlineActivityResult.this.fragmentReference.get();
                FragmentManager fragmentManager = fragment != null ? fragment.getChildFragmentManager() : activity.getSupportFragmentManager();
                fragmentManager.beginTransaction().add((Fragment)newFragment, InlineActivityResult.TAG).commitNowAllowingStateLoss();
            }
        });
    }
}

