/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.inlineactivityresult;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;

public class ActivityResultFragment
extends Fragment {
    public static final String INTENT_TO_START = "INTENT_TO_START";
    private static final int REQUEST_CODE = 24;
    @Nullable
    private ActivityResultListener listener;
    @Nullable
    private Intent intentToStart;

    public ActivityResultFragment() {
        this.setRetainInstance(true);
    }

    public static ActivityResultFragment newInstance(@NonNull Intent intent) {
        Bundle args = new Bundle();
        args.putParcelable(INTENT_TO_START, (Parcelable)intent);
        ActivityResultFragment fragment = new ActivityResultFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.intentToStart = (Intent)arguments.getParcelable(INTENT_TO_START);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.intentToStart != null) {
            this.startActivityForResult(this.intentToStart, 24);
        } else {
            this.removeFragment();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 24) {
            if (this.listener != null) {
                this.listener.onActivityResult(requestCode, resultCode, data);
            }
            this.removeFragment();
        }
    }

    public ActivityResultFragment setListener(@Nullable ActivityResultListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
        return this;
    }

    private void removeFragment() {
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    static interface ActivityResultListener {
        public void onActivityResult(int var1, int var2, Intent var3);
    }
}

