/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorSelectorPredicate;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ProcessorSelector<IN extends MessageProvider, OUT extends MessageProvider> {
    final Map<Predicate<IN>, Processor<IN, OUT>> choices;
    private final Processor<IN, OUT> byDefault;

    public ProcessorSelector() {
        this.choices = Maps.newLinkedHashMap();
        this.byDefault = null;
    }

    private ProcessorSelector(Map<Predicate<IN>, Processor<IN, OUT>> choices, Processor<IN, OUT> byDefault) {
        this.choices = Maps.newLinkedHashMap(choices);
        this.byDefault = byDefault;
    }

    ProcessorSelector(ProcessorSelectorPredicate<IN, OUT> selector) {
        this(selector.choices, selector.byDefault);
    }

    public ProcessorSelectorPredicate<IN, OUT> when(Predicate<IN> predicate) {
        return new ProcessorSelectorPredicate<IN, OUT>(this, predicate, this.byDefault);
    }

    public ProcessorSelector<IN, OUT> otherwise(Processor<IN, OUT> byDefault) {
        return new ProcessorSelector<IN, OUT>(this.choices, byDefault);
    }

    public Processor<IN, OUT> getProcessor() {
        return new Chooser(this.choices, this.byDefault);
    }

    private static final class Chooser<X extends MessageProvider, Y extends MessageProvider>
    implements Processor<X, Y> {
        private final Map<Predicate<X>, Processor<X, Y>> map;
        private final Processor<X, Y> byDefault;

        private Chooser(Map<Predicate<X>, Processor<X, Y>> map, Processor<X, Y> byDefault) {
            this.map = ImmutableMap.copyOf(map);
            this.byDefault = byDefault;
        }

        @Override
        public Y process(ProcessingReport report, X input) throws ProcessingException {
            for (Map.Entry<Predicate<X>, Processor<X, Y>> entry : this.map.entrySet()) {
                Predicate<X> predicate = entry.getKey();
                Processor<X, Y> processor = entry.getValue();
                if (!predicate.apply(input)) continue;
                return processor.process(report, input);
            }
            if (this.byDefault != null) {
                return this.byDefault.process(report, input);
            }
            ProcessingMessage message = input.newMessage().message("no suitable processor found for input");
            throw new ProcessingException(message);
        }
    }
}

