/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public final class SuperCallRewriter
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.containsPotentialSuperCalls();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        InsnList instructions = method.instructions;
        AbstractInsnNode insn = instructions.getFirst();
        while (insn.getOpcode() != 176) {
            if (insn.getOpcode() == 183) {
                this.process(classNode, method, (MethodInsnNode)insn);
            }
            insn = insn.getNext();
        }
    }

    private void process(ParserClassNode classNode, RuleMethod method, MethodInsnNode insn) {
        if ("<init>".equals(insn.name)) {
            return;
        }
        String superMethodName = SuperCallRewriter.getSuperMethodName(method, insn);
        RuleMethod superMethod = classNode.getRuleMethods().get(superMethodName + insn.desc);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.isBodyRewritten()) {
            return;
        }
        superMethod.dontSkipGeneration();
        insn.setOpcode(182);
        insn.name = superMethodName;
        insn.owner = classNode.name;
        method.setBodyRewritten();
    }

    private static String getSuperMethodName(RuleMethod method, MethodInsnNode insn) {
        Class<?> c = method.getOwnerClass();
        StringBuilder sb = new StringBuilder(method.name);
        do {
            Preconditions.checkState(((c = c.getSuperclass()) != null ? 1 : 0) != 0);
            sb.insert(0, '$');
        } while (!Type.getInternalName(c).equals(insn.owner));
        return sb.toString();
    }
}

