/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.grappa.transform.process;

import com.github.fge.grappa.transform.CodeBlock;
import com.github.fge.grappa.transform.LoadingOpcode;
import com.github.fge.grappa.transform.base.InstructionGraphNode;
import com.github.fge.grappa.transform.base.InstructionGroup;
import com.github.fge.grappa.transform.base.ParserClassNode;
import com.github.fge.grappa.transform.base.RuleMethod;
import com.github.fge.grappa.transform.process.RuleMethodProcessor;
import com.google.common.base.Supplier;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class RuleMethodRewriter
implements RuleMethodProcessor {
    private RuleMethod method;
    private int actionNr = 0;
    private int varInitNr = 0;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Objects.requireNonNull(classNode, "classNode");
        Objects.requireNonNull(method, "method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        this.method = Objects.requireNonNull(method, "method");
        this.actionNr = 0;
        this.varInitNr = 0;
        for (InstructionGroup group : method.getGroups()) {
            this.createNewGroupClassInstance(group);
            this.initializeFields(group);
            InstructionGraphNode root = group.getRoot();
            AbstractInsnNode rootInsn = root.getInstruction();
            if (root.isActionRoot()) {
                method.instructions.remove(rootInsn);
                continue;
            }
            ((MethodInsnNode)rootInsn).desc = CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{Supplier.class});
        }
        method.setBodyRewritten();
    }

    private void createNewGroupClassInstance(InstructionGroup group) {
        String internalName = group.getGroupClassType().getInternalName();
        InstructionGraphNode root = group.getRoot();
        AbstractInsnNode rootInsn = root.getInstruction();
        InsnList insnList = this.method.instructions;
        String constant = this.method.name + (root.isActionRoot() ? "_Action" + ++this.actionNr : "_VarInit" + ++this.varInitNr);
        CodeBlock block = CodeBlock.newCodeBlock();
        block.newobj(internalName).dup().ldc(constant).invokespecial(internalName, "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class}));
        if (root.isActionRoot() && this.method.hasSkipActionsInPredicatesAnnotation()) {
            block.dup().invokevirtual(internalName, "setSkipInPredicates", CodegenUtils.sig(Void.TYPE, (Class[])new Class[0]));
        }
        insnList.insertBefore(rootInsn, block.getInstructionList());
    }

    private void initializeFields(InstructionGroup group) {
        String internalName = group.getGroupClassType().getInternalName();
        for (FieldNode field : group.getFields()) {
            InsnList insnList = this.method.instructions;
            AbstractInsnNode rootInsn = group.getRoot().getInstruction();
            int opcode = LoadingOpcode.forType((Type)field.value);
            VarInsnNode varNode = new VarInsnNode(opcode, field.access);
            FieldInsnNode fieldNode = new FieldInsnNode(181, internalName, field.name, field.desc);
            insnList.insertBefore(rootInsn, (AbstractInsnNode)new InsnNode(89));
            insnList.insertBefore(rootInsn, (AbstractInsnNode)varNode);
            insnList.insertBefore(rootInsn, (AbstractInsnNode)fieldNode);
        }
    }
}

